/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.reflect.AnnotationSet;
import com.caucho.config.reflect.BaseType;
import com.caucho.config.reflect.BaseTypeAnnotated;
import com.caucho.config.reflect.VarType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionAnnotated
implements Annotated,
BaseTypeAnnotated {
    private static final LinkedHashSet<Annotation> _emptyAnnSet = new LinkedHashSet();
    private static final Annotation[] _emptyAnnArray = new Annotation[0];
    private BaseType _type;
    private Set<Type> _typeSet;
    private LinkedHashSet<Annotation> _annSet;
    private AnnotationSet _analysisAnnSet;
    private Annotation[] _annArray;

    protected ReflectionAnnotated(BaseType type, Set<Type> typeClosure, Annotation[] annList) {
        this._type = type;
        this._typeSet = typeClosure;
        if (annList != null && annList.length > 0) {
            this._annSet = new LinkedHashSet();
            for (Annotation ann : annList) {
                if (ann == null) continue;
                this._annSet.add(ann);
            }
            Annotation[] annArray = new Annotation[this._annSet.size()];
            this._annSet.toArray(annArray);
            this._annArray = annArray;
        } else {
            this._annSet = _emptyAnnSet;
            this._annArray = _emptyAnnArray;
        }
    }

    @Override
    public Type getBaseType() {
        return this._type.toType();
    }

    @Override
    public BaseType getBaseTypeImpl() {
        return this._type;
    }

    @Override
    public Set<VarType<?>> getTypeVariables() {
        HashSet typeVariables = new HashSet();
        this.fillTypeVariables(typeVariables);
        return typeVariables;
    }

    protected void fillTypeVariables(Set<VarType<?>> typeVariables) {
        this.getBaseTypeImpl().fillSyntheticTypes(typeVariables);
    }

    @Override
    public HashMap<String, BaseType> getBaseTypeParamMap() {
        return this._type.getParamMap();
    }

    @Override
    public Set<Type> getTypeClosure() {
        return this._typeSet;
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return this._annSet;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annType) {
        for (Annotation ann : this._annArray) {
            if (!annType.equals(ann.annotationType())) continue;
            return (T)ann;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAnnotation(Annotation ann) {
        if (ann == null) {
            return;
        }
        if (this._annSet == _emptyAnnSet) {
            this._annSet = new LinkedHashSet();
        }
        LinkedHashSet<Annotation> linkedHashSet = this._annSet;
        synchronized (linkedHashSet) {
            this._annSet.add(ann);
            Annotation[] annArray = new Annotation[this._annSet.size()];
            this._annSet.toArray(annArray);
            this._annArray = annArray;
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annType) {
        for (Annotation ann : this._annArray) {
            if (ann == null || !annType.equals(ann.annotationType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addOverrideAnnotation(Annotation ann) {
        this.addAnnotation(ann);
    }

    @Override
    public void addAnalysisAnnotation(Annotation ann) {
        if (this._analysisAnnSet == null) {
            this._analysisAnnSet = new AnnotationSet();
        }
        this._analysisAnnSet.add(ann);
    }

    @Override
    public <T extends Annotation> T getAnalysisAnnotation(Class<T> annType) {
        Annotation ann;
        if (this._analysisAnnSet != null && (ann = this._analysisAnnSet.getAnnotation(annType)) != null) {
            return (T)ann;
        }
        return this.getAnnotation(annType);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._type + "]";
    }
}

