/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.inject.Module;
import java.lang.annotation.Annotation;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class AnnotationSet
extends AbstractSet<Annotation> {
    private static final Annotation[] ZERO_SET = new Annotation[0];
    private static final NullAnnotationSetIterator NULL_ITER = new NullAnnotationSetIterator();
    private Annotation[] _annSet = ZERO_SET;
    private int _size;

    public AnnotationSet() {
    }

    public AnnotationSet(Collection<Annotation> set) {
        for (Annotation ann : set) {
            this.add(ann);
        }
    }

    @Override
    public int size() {
        return this._size;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annType) {
        Annotation[] annSet = this._annSet;
        for (int i = this._size - 1; i >= 0; --i) {
            Annotation ann = annSet[i];
            if (!ann.annotationType().equals(annType)) continue;
            return true;
        }
        return false;
    }

    public Annotation getAnnotation(Class<? extends Annotation> annType) {
        Annotation[] annSet = this._annSet;
        for (int i = this._size - 1; i >= 0; --i) {
            Annotation ann = annSet[i];
            if (!ann.annotationType().equals(annType)) continue;
            return ann;
        }
        return null;
    }

    public void replace(Annotation newAnn) {
        Annotation[] annSet = this._annSet;
        for (int i = this._size - 1; i >= 0; --i) {
            Annotation oldAnn = annSet[i];
            if (!oldAnn.annotationType().equals(newAnn.annotationType())) continue;
            annSet[i] = newAnn;
            return;
        }
        this.addImpl(newAnn);
    }

    @Override
    public boolean add(Annotation newAnn) {
        Annotation[] annSet = this._annSet;
        for (int i = this._size - 1; i >= 0; --i) {
            Annotation oldAnn = annSet[i];
            if (!((Object)oldAnn).equals(newAnn)) continue;
            return false;
        }
        this.addImpl(newAnn);
        return true;
    }

    public boolean remove(Annotation newAnn) {
        Annotation[] annSet = this._annSet;
        for (int i = this._size - 1; i >= 0; --i) {
            Annotation oldAnn = annSet[i];
            if (!((Object)oldAnn).equals(newAnn)) continue;
            System.arraycopy(annSet, i + 1, annSet, i, annSet.length - i - 1);
            --this._size;
            return true;
        }
        return false;
    }

    private void addImpl(Annotation newAnn) {
        if (this._annSet.length <= this._size + 1) {
            int newSize = 2 * (this._size + 1);
            if (newSize < 16) {
                newSize = 16;
            }
            Annotation[] annSet = new Annotation[newSize];
            System.arraycopy(this._annSet, 0, annSet, 0, this._annSet.length);
            this._annSet = annSet;
        }
        this._annSet[this._size++] = newAnn;
    }

    @Override
    public void clear() {
        for (int i = this._size - 1; i >= 0; --i) {
            this._annSet[i] = null;
        }
        this._size = 0;
    }

    @Override
    public Iterator<Annotation> iterator() {
        if (this._size > 0) {
            return new AnnotationSetIterator();
        }
        return NULL_ITER;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        for (int i = 0; i < this._size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this._annSet[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullAnnotationSetIterator
    implements Iterator<Annotation> {
        NullAnnotationSetIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Annotation next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AnnotationSetIterator
    implements Iterator<Annotation> {
        int _index;

        AnnotationSetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this._index < AnnotationSet.this._size;
        }

        @Override
        public Annotation next() {
            if (this._index < AnnotationSet.this._size) {
                return AnnotationSet.this._annSet[this._index++];
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }
}

