/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.reflect.AnnotatedElementImpl;
import com.caucho.config.reflect.AnnotatedMethodImpl;
import com.caucho.config.reflect.BaseType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedTypeImpl<X>
extends AnnotatedElementImpl
implements AnnotatedType<X> {
    private Class<X> _javaClass;
    private AnnotatedType<X> _parentType;
    private Set<AnnotatedMethod<? super X>> _methodSet;

    public AnnotatedTypeImpl(AnnotatedType<X> annType) {
        super(annType);
        this._parentType = annType;
        this._javaClass = annType.getJavaClass();
    }

    public static <X> AnnotatedTypeImpl<X> create(AnnotatedType<X> annType) {
        if (annType instanceof AnnotatedTypeImpl) {
            return (AnnotatedTypeImpl)annType;
        }
        return new AnnotatedTypeImpl<X>(annType);
    }

    @Override
    public Class<X> getJavaClass() {
        return this._javaClass;
    }

    @Override
    public HashMap<String, BaseType> getBaseTypeParamMap() {
        return this.getBaseTypeImpl().getParamMap();
    }

    private AnnotatedType<?> getParentType() {
        return this._parentType;
    }

    @Override
    public Set<AnnotatedConstructor<X>> getConstructors() {
        return this.getParentType().getConstructors();
    }

    @Override
    public Set<AnnotatedMethod<? super X>> getMethods() {
        if (this._methodSet != null) {
            return this._methodSet;
        }
        return this.getParentType().getMethods();
    }

    public Set<AnnotatedMethod<? super X>> getMethodsForUpdate() {
        if (this._methodSet == null) {
            this.initMethodSet();
        }
        return this._methodSet;
    }

    public AnnotatedMethod<? super X> createMethod(Method method) {
        if (this._methodSet == null) {
            this.initMethodSet();
        }
        for (AnnotatedMethod<X> annMethod : this._methodSet) {
            if (!AnnotatedMethodImpl.isMatch(annMethod.getJavaMember(), method)) continue;
            return annMethod;
        }
        AnnotatedMethodImpl annMethod = new AnnotatedMethodImpl(this, null, method);
        this._methodSet.add(annMethod);
        return annMethod;
    }

    @Override
    public Set<AnnotatedField<? super X>> getFields() {
        return this.getParentType().getFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMethodSet() {
        AnnotatedTypeImpl annotatedTypeImpl = this;
        synchronized (annotatedTypeImpl) {
            if (this._methodSet != null) {
                return;
            }
            this._methodSet = new CopyOnWriteArraySet<AnnotatedMethod<? super X>>();
            for (AnnotatedMethod<?> annMethod : this.getParentType().getMethods()) {
                if (annMethod.getDeclaringType() == this.getParentType()) {
                    this._methodSet.add(new AnnotatedMethodImpl(this, annMethod, annMethod.getJavaMember()));
                    continue;
                }
                this._methodSet.add(annMethod);
            }
        }
    }
}

