/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.program;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.config.type.ConfigType;
import com.caucho.config.xml.XmlConfigContext;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import javax.enterprise.context.spi.CreationalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigProgram
implements Comparable<ConfigProgram> {
    private static final L10N L = new L10N(ConfigProgram.class);

    public QName getQName() {
        return null;
    }

    public int getPriority() {
        return 0;
    }

    public Class<?> getDeclaringClass() {
        return this.getClass();
    }

    public String getName() {
        return this.getClass().getName();
    }

    public abstract <T> void inject(T var1, CreationalContext<T> var2);

    public void bind() {
    }

    public void addProgram(ConfigProgram program) {
        throw new UnsupportedOperationException(L.l("{0}: Cannot add a program ({1}) to a BuilderProgram. You probably need a BuilderProgramContainer.", (Object)this, (Object)program));
    }

    public final void configure(Object bean) throws ConfigException {
        this.inject(bean, new OwnerCreationalContext(null));
    }

    public final <T> T configure(Class<T> type) throws ConfigException {
        return this.configure(type, XmlConfigContext.create());
    }

    protected final <T> T configure(Class<T> type, XmlConfigContext env) throws ConfigException {
        try {
            T value = type.newInstance();
            this.inject(value, new OwnerCreationalContext(null));
            return value;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    protected final <T> T create(Class<T> type, CreationalContext<T> env) throws ConfigException {
        try {
            T value = type.newInstance();
            this.inject(value, env);
            return value;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public final <T> T create(ConfigType<T> type) throws ConfigException {
        return this.create(type, new OwnerCreationalContext(null));
    }

    public <T> T create(ConfigType<T> type, CreationalContext<T> env) throws ConfigException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void init(Object bean) throws ConfigException {
        Config.init(bean);
    }

    @Override
    public int compareTo(ConfigProgram peer) {
        Class<?> peerClass;
        int cmp = this.getPriority() - peer.getPriority();
        if (this.getPriority() < 0 != peer.getPriority() < 0) {
            return cmp;
        }
        Class<?> selfClass = this.getDeclaringClass();
        if (selfClass == (peerClass = peer.getDeclaringClass())) {
            if (cmp != 0) {
                return cmp;
            }
            return this.getName().compareTo(peer.getName());
        }
        if (selfClass.isAssignableFrom(peerClass)) {
            return -1;
        }
        if (peerClass.isAssignableFrom(selfClass)) {
            return 1;
        }
        if (cmp != 0) {
            return cmp;
        }
        return selfClass.getName().compareTo(peerClass.getName());
    }
}

