/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.j2ee.JavaeeInjectionHandler;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.FieldGeneratorProgram;
import com.caucho.config.program.MethodGeneratorProgram;
import com.caucho.config.program.NullProgram;
import com.caucho.config.program.SingletonValueGenerator;
import com.caucho.config.program.ValueGenerator;
import com.caucho.env.jdbc.DatabaseFactory;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.sql.DataSourceDefinition;
import javax.annotation.sql.DataSourceDefinitions;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceDefinitionHandler
extends JavaeeInjectionHandler {
    private static final Logger log = Logger.getLogger(DataSourceDefinitionHandler.class.getName());
    private static final L10N L = new L10N(DataSourceDefinitionHandler.class);

    public DataSourceDefinitionHandler(InjectManager manager) {
        super(manager);
    }

    @Override
    public ConfigProgram introspectField(AnnotatedField<?> field) {
        DataSourceDefinition db = field.getAnnotation(DataSourceDefinition.class);
        return this.generateProgram(field, db);
    }

    @Override
    public ConfigProgram introspectMethod(AnnotatedMethod<?> method) {
        DataSourceDefinition db = method.getAnnotation(DataSourceDefinition.class);
        return this.generateProgram(method, db);
    }

    @Override
    public ConfigProgram introspectType(AnnotatedType<?> type) {
        DataSourceDefinition db;
        for (Class<?> parentClass = type.getJavaClass().getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
            DataSourceDefinition db2;
            DataSourceDefinitions dbs = parentClass.getAnnotation(DataSourceDefinitions.class);
            if (dbs != null) {
                for (DataSourceDefinition db3 : dbs.value()) {
                    this.introspectClass(this.getClass().getName(), db3);
                }
            }
            if ((db2 = parentClass.getAnnotation(DataSourceDefinition.class)) == null) continue;
            this.introspectClass(this.getClass().getName(), db2);
        }
        DataSourceDefinitions dbs = type.getAnnotation(DataSourceDefinitions.class);
        if (dbs != null) {
            for (DataSourceDefinition db4 : dbs.value()) {
                this.introspectClass(this.getClass().getName(), db4);
            }
        }
        if ((db = type.getAnnotation(DataSourceDefinition.class)) != null) {
            this.introspectClass(this.getClass().getName(), db);
        }
        return new NullProgram();
    }

    private void introspectClass(String location, DataSourceDefinition def) {
        String name = def.name();
        ValueGenerator gen = this.bindGenerator(location, def);
        if (name != null && !"".equals(name)) {
            this.bindJndi(name, gen, name);
        }
    }

    private ConfigProgram generateProgram(AnnotatedField<?> field, DataSourceDefinition def) throws ConfigException {
        String name = def.name();
        Field javaField = field.getJavaMember();
        String location = this.getLocation(javaField);
        Class<?> bindType = javaField.getType();
        ValueGenerator gen = this.bindGenerator(location, def);
        if (name != null && !"".equals(name)) {
            this.bindJndi(name, gen, name);
        }
        this.bindJndi(javaField, gen);
        return new FieldGeneratorProgram(javaField, gen);
    }

    private ConfigProgram generateProgram(AnnotatedMethod<?> method, DataSourceDefinition def) throws ConfigException {
        String name = def.name();
        Method javaMethod = method.getJavaMember();
        String location = this.getLocation(javaMethod);
        ValueGenerator gen = this.bindGenerator(location, def);
        if (name != null && !"".equals(name)) {
            this.bindJndi(name, gen, name);
        }
        this.bindJndi(javaMethod, gen);
        return new MethodGeneratorProgram(javaMethod, gen);
    }

    protected ValueGenerator bindGenerator(String location, DataSourceDefinition def) {
        DataSource db = this.createDatabase(location, def);
        return new SingletonValueGenerator(db);
    }

    private DataSource createDatabase(String location, DataSourceDefinition def) {
        DataSource db = null;
        String name = def.name();
        try {
            db = (DataSource)Jndi.lookup(name);
            if (db != null) {
                return db;
            }
        }
        catch (Exception e) {
            log.log(Level.ALL, e.toString(), e);
        }
        String className = def.className();
        if ("".equals(name)) {
            throw new ConfigException(L.l("{0}: @{1} name() attribute is required.", (Object)location, (Object)DataSourceDefinition.class.getSimpleName()));
        }
        if ("".equals(className)) {
            throw new ConfigException(L.l("{0}: @{1} beanInterface() attribute is required.", (Object)location, (Object)DataSourceDefinition.class.getSimpleName()));
        }
        Class<?> driverClass = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            driverClass = Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(L.l("{0}: @{1} className() {2} is not a valid class.\n  {3}", (Object)location, (Object)DataSourceDefinition.class.getSimpleName(), (Object)className));
        }
        DatabaseFactory factory = DatabaseFactory.createBuilder();
        factory.setName(name);
        factory.setDriverClass(driverClass);
        if (!"".equals(def.url())) {
            factory.setUrl(def.url());
        }
        if (!"".equals(def.databaseName())) {
            factory.setDatabaseName(def.databaseName());
        }
        if (!"".equals(def.user())) {
            factory.setUser(def.user());
        }
        if (!"".equals(def.password())) {
            factory.setPassword(def.password());
        }
        return factory.create();
    }
}

