/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.inject.QualifierBinding;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InterceptorBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorEntry<X> {
    private static final Logger log = Logger.getLogger(InterceptorEntry.class.getName());
    private static final L10N L = new L10N(InterceptorEntry.class);
    private Interceptor<X> _interceptor;
    private ArrayList<QualifierBinding> _bindings = new ArrayList();
    private boolean _isEnabled;

    public InterceptorEntry(Interceptor<X> interceptor) {
        this._interceptor = interceptor;
        for (Annotation ann : interceptor.getInterceptorBindings()) {
            this._bindings.add(new QualifierBinding(ann));
        }
    }

    public Interceptor<X> getInterceptor() {
        return this._interceptor;
    }

    public boolean isMatch(Annotation[] bindingAnn) {
        for (QualifierBinding binding : this._bindings) {
            if (this.isMatch(binding, bindingAnn)) continue;
            return false;
        }
        return true;
    }

    public void setEnabled(boolean isEnabled) {
        this._isEnabled = isEnabled;
    }

    public boolean isMatch(QualifierBinding binding, Annotation[] bindingAnn) {
        for (Annotation ann : bindingAnn) {
            Class<? extends Annotation> annType = ann.annotationType();
            if (!annType.isAnnotationPresent(InterceptorBinding.class)) continue;
            if (binding.isMatch(ann)) {
                return true;
            }
            if (!this.isMatch(binding, annType.getAnnotations())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._interceptor + "," + this._bindings + "]";
    }
}

