/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InjectionPointImpl;
import com.caucho.config.reflect.AnnotatedFieldImpl;
import com.caucho.config.reflect.AnnotatedMethodImpl;
import com.caucho.config.reflect.ReflectionAnnotatedFactory;
import com.caucho.config.reflect.ReflectionAnnotatedType;
import com.caucho.inject.Module;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class InjectionPointImplHandle
implements Serializable {
    private final String _beanClass;
    private final Annotation[] _beanQualifiers;
    private final String _typeClass;
    private final String _memberClass;
    private final String _memberName;
    private final MemberType _memberType;
    private HashSet<Annotation> _qualifiers;

    InjectionPointImplHandle(String beanClass, Set<Annotation> beanQualifierSet, Member member, HashSet<Annotation> qualifiers, String typeClass) {
        Annotation[] beanQualifiers = new Annotation[beanQualifierSet.size()];
        beanQualifierSet.toArray(beanQualifiers);
        this._beanClass = beanClass;
        this._beanQualifiers = beanQualifiers;
        this._typeClass = typeClass;
        this._memberClass = member.getDeclaringClass().getName();
        this._memberName = member.getName();
        this._memberType = member instanceof Field ? MemberType.FIELD : (member instanceof Method ? MemberType.METHOD : MemberType.CONSTRUCTOR);
        this._qualifiers = new HashSet<Annotation>(qualifiers);
    }

    private Object readResolve() {
        try {
            Annotated annotated;
            AccessibleObject member;
            InjectManager cdiManager = InjectManager.create();
            Class<?> beanClass = Class.forName(this._beanClass, false, cdiManager.getClassLoader());
            Class<?> typeClass = Class.forName(this._typeClass, false, cdiManager.getClassLoader());
            Annotation[] qualifiers = new Annotation[this._qualifiers.size()];
            this._qualifiers.toArray(qualifiers);
            Bean bean = cdiManager.resolve(cdiManager.getBeans(beanClass, this._beanQualifiers));
            Class<?> memberClass = Class.forName(this._memberClass, false, cdiManager.getClassLoader());
            ReflectionAnnotatedType<?> annType = ReflectionAnnotatedFactory.introspectType(memberClass);
            switch (this._memberType) {
                case FIELD: {
                    member = this.getField(memberClass, this._memberName);
                    annotated = new AnnotatedFieldImpl(annType, (Field)member);
                    break;
                }
                case METHOD: {
                    member = this.getMethod(memberClass, this._memberName);
                    annotated = new AnnotatedMethodImpl((Method)member);
                    break;
                }
                default: {
                    member = memberClass.getConstructors()[0];
                    annotated = annType;
                }
            }
            return new InjectionPointImpl(cdiManager, bean, annotated, (Member)((Object)member), typeClass);
        }
        catch (Exception e) {
            throw new RuntimeException(this._memberClass + ":" + this._memberName + ":" + e, e);
        }
    }

    private Field getField(Class<?> cl, String name) {
        if (cl == null) {
            return null;
        }
        for (Field field : cl.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return this.getField(cl.getSuperclass(), name);
    }

    private Method getMethod(Class<?> cl, String name) {
        if (cl == null) {
            return null;
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return this.getMethod(cl.getSuperclass(), name);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._memberName + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MemberType {
        FIELD,
        METHOD,
        CONSTRUCTOR;

    }
}

