/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InjectScanClass;
import com.caucho.config.inject.InjectionPointHandler;
import com.caucho.config.inject.ScanRootContext;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.reflect.ReflectionAnnotatedFactory;
import com.caucho.config.reflect.ReflectionAnnotatedType;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.enhancer.ScanClass;
import com.caucho.loader.enhancer.ScanListener;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InjectScanManager
implements ScanListener {
    private static final Logger log = Logger.getLogger(InjectScanManager.class.getName());
    private InjectManager _injectManager;
    private final HashMap<Path, ScanRootContext> _scanRootMap = new HashMap();
    private final ArrayList<ScanRootContext> _pendingScanRootList = new ArrayList();
    private final ConcurrentHashMap<String, InjectScanClass> _scanClassMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<NameKey, AnnType> _annotationMap = new ConcurrentHashMap();
    private final ArrayList<InjectScanClass> _immediateResourceList = new ArrayList();
    private NameKey _nameKey = new NameKey();
    private boolean _isCustomExtension;
    private ArrayList<InjectScanClass> _pendingScanClassList = new ArrayList();

    InjectScanManager(InjectManager injectManager) {
        this._injectManager = injectManager;
    }

    public InjectManager getInjectManager() {
        return this._injectManager;
    }

    public void setIsCustomExtension(boolean isCustomExtension) {
        this._isCustomExtension = isCustomExtension;
        if (isCustomExtension) {
            for (InjectScanClass scanClass : this._scanClassMap.values()) {
                scanClass.register();
            }
        }
    }

    public boolean isCustomExtension() {
        return this._isCustomExtension;
    }

    public ArrayList<ScanRootContext> getPendingScanRootList() {
        ArrayList<ScanRootContext> contextList = new ArrayList<ScanRootContext>(this._pendingScanRootList);
        this._pendingScanRootList.clear();
        return contextList;
    }

    public boolean isPending() {
        return this._pendingScanClassList.size() > 0 || this._pendingScanRootList.size() > 0;
    }

    public void addDiscoveredClass(InjectScanClass injectScanClass) {
        if (!this._pendingScanClassList.contains(injectScanClass)) {
            this._pendingScanClassList.add(injectScanClass);
        }
    }

    public void discover() {
        ArrayList<InjectScanClass> pendingScanClassList = new ArrayList<InjectScanClass>(this._pendingScanClassList);
        this._pendingScanClassList.clear();
        for (InjectScanClass scanClass : pendingScanClassList) {
            this.getInjectManager().discoverBean(scanClass);
        }
    }

    @Override
    public int getScanPriority() {
        return 1;
    }

    @Override
    public boolean isRootScannable(Path root, String packageRoot) {
        ScanRootContext context = this._scanRootMap.get(root);
        List<Path> beansXmlOverride = this._injectManager.getBeansXmlOverride(root);
        Path scanRoot = root;
        if (packageRoot != null) {
            scanRoot = scanRoot.lookup(packageRoot.replace('.', '/'));
        }
        if (beansXmlOverride == null && (packageRoot != null ? !scanRoot.lookup("beans.xml").canRead() && !scanRoot.lookup("META-INF/beans.xml").canRead() : !root.lookup("META-INF/beans.xml").canRead() && (!root.getFullPath().endsWith("WEB-INF/classes/") || !root.lookup("../beans.xml").canRead()))) {
            return false;
        }
        if (context == null) {
            context = new ScanRootContext(scanRoot, packageRoot);
            this._scanRootMap.put(root, context);
            this._pendingScanRootList.add(context);
        }
        if (context.isScanComplete()) {
            return false;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("CanDI scanning " + root.getURL());
        }
        context.setScanComplete(true);
        return true;
    }

    @Override
    public ScanClass scanClass(Path root, String packageRoot, String className, int modifiers) {
        if (Modifier.isPrivate(modifiers)) {
            return null;
        }
        InjectScanClass scanClass = this.createScanClass(className);
        scanClass.setScanClass();
        return scanClass;
    }

    InjectScanClass getScanClass(String className) {
        return this._scanClassMap.get(className);
    }

    InjectScanClass createScanClass(String className) {
        InjectScanClass oldScanClass;
        InjectScanClass scanClass = this._scanClassMap.get(className);
        if (scanClass == null && (oldScanClass = this._scanClassMap.putIfAbsent(className, scanClass = new InjectScanClass(className, this))) != null) {
            scanClass = oldScanClass;
        }
        return scanClass;
    }

    public AnnType loadAnnotation(char[] buffer, int offset, int length) throws ClassNotFoundException {
        NameKey key = this._nameKey;
        key.init(buffer, offset, length);
        AnnType annType = this._annotationMap.get(key);
        if (annType != null) {
            return annType;
        }
        ClassLoader loader = this.getInjectManager().getClassLoader();
        String className = new String(buffer, offset, length);
        Class<?> cl = Class.forName(className, false, loader);
        annType = new AnnType(cl);
        this._annotationMap.put(key.dup(), annType);
        return annType;
    }

    @Override
    public boolean isScanMatchAnnotation(CharBuffer string) {
        return false;
    }

    @Override
    public void classMatchEvent(EnvironmentClassLoader loader, Path root, String className) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImmediateResource(InjectScanClass injectScanClass) {
        ClassLoader classLoader = this._injectManager.getClassLoader();
        if (classLoader instanceof DynamicClassLoader) {
            DynamicClassLoader dynLoader = (DynamicClassLoader)classLoader;
            ClassLoader tmpLoader = dynLoader.getNewTempClassLoader();
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                try {
                    thread.setContextClassLoader(dynLoader);
                    Class<?> cl = tmpLoader.loadClass(injectScanClass.getClassName());
                    ReflectionAnnotatedType<?> annType = ReflectionAnnotatedFactory.introspectType(cl);
                    for (Annotation ann : cl.getAnnotations()) {
                        ConfigProgram program;
                        InjectionPointHandler handler = this._injectManager.getInjectionPointHandler(ann.annotationType());
                        if (handler == null || (program = handler.introspectType(annType)) == null) continue;
                        program.inject(null, null);
                    }
                    Object var16_16 = null;
                    thread.setContextClassLoader(oldLoader);
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                    Object var16_17 = null;
                    thread.setContextClassLoader(oldLoader);
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._injectManager + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AnnType {
        private Class<?> _type;
        private Annotation[] _annotations;

        AnnType(Class<?> type) {
            this._type = type;
        }

        public Class<?> getType() {
            return this._type;
        }

        public Annotation[] getAnnotations() {
            if (this._annotations == null) {
                this._annotations = this._type.getAnnotations();
            }
            return this._annotations;
        }
    }

    static class NameKey {
        private char[] _buffer;
        private int _offset;
        private int _length;

        NameKey(char[] buffer, int offset, int length) {
            this.init(buffer, offset, length);
        }

        NameKey() {
        }

        void init(char[] buffer, int offset, int length) {
            this._buffer = buffer;
            this._offset = offset;
            this._length = length;
        }

        public NameKey dup() {
            char[] buffer = new char[this._length];
            System.arraycopy(this._buffer, this._offset, buffer, 0, this._length);
            return new NameKey(buffer, 0, this._length);
        }

        public int hashCode() {
            char[] buffer = this._buffer;
            int offset = this._offset;
            int length = this._length;
            int hash = length--;
            while (length >= 0) {
                char value = buffer[offset + length];
                hash = 65521 * hash + value;
                --length;
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NameKey)) {
                return false;
            }
            NameKey key = (NameKey)o;
            if (this._length != key._length) {
                return false;
            }
            char[] bufferA = this._buffer;
            char[] bufferB = key._buffer;
            int offsetA = this._offset;
            int offsetB = key._offset;
            for (int i = this._length - 1; i >= 0; --i) {
                if (bufferA[offsetA + i] == bufferB[offsetB + i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + new String(this._buffer, this._offset, this._length);
        }
    }
}

