/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.AbstractAspectFactory;
import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.gen.AspectFactory;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.LockGenerator;
import com.caucho.inject.Module;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class LockFactory<X>
extends AbstractAspectFactory<X> {
    private ConcurrencyManagementType _concurrencyManagement = ConcurrencyManagementType.CONTAINER;
    private LockType _classLockType;
    private AccessTimeout _classAccessTimeout;

    public LockFactory(AspectBeanFactory<X> beanFactory, AspectFactory<X> next) {
        super(beanFactory, next);
        Lock lock;
        AnnotatedType<X> beanType = beanFactory.getBeanType();
        ConcurrencyManagement concurrencyManagement = beanType.getAnnotation(ConcurrencyManagement.class);
        if (concurrencyManagement != null) {
            this._concurrencyManagement = concurrencyManagement.value();
        }
        if ((lock = beanType.getAnnotation(Lock.class)) != null) {
            this._classLockType = lock.value();
        }
        this._classAccessTimeout = beanType.getAnnotation(AccessTimeout.class);
    }

    @Override
    public AspectGenerator<X> create(AnnotatedMethod<? super X> method, boolean isEnhanced) {
        AccessTimeout declaringClassAccessTimeout;
        Lock declaringClassLock;
        AnnotatedType declaringType = method.getDeclaringType();
        LockType lockType = null;
        Lock methodLevelLock = method.getAnnotation(Lock.class);
        Lock lock = declaringClassLock = declaringType != null ? declaringType.getAnnotation(Lock.class) : null;
        lockType = methodLevelLock != null ? methodLevelLock.value() : (declaringClassLock != null ? declaringClassLock.value() : this._classLockType);
        AccessTimeout accessTimeout = null;
        AccessTimeout methodLevelAccessTimeout = method.getAnnotation(AccessTimeout.class);
        AccessTimeout accessTimeout2 = declaringClassAccessTimeout = declaringType != null ? declaringType.getAnnotation(AccessTimeout.class) : null;
        accessTimeout = methodLevelAccessTimeout != null ? methodLevelAccessTimeout : (declaringClassAccessTimeout != null ? declaringClassAccessTimeout : this._classAccessTimeout);
        if (lockType == null || this._concurrencyManagement == ConcurrencyManagementType.BEAN) {
            return super.create(method, isEnhanced);
        }
        AspectGenerator<? super X> next = super.create(method, true);
        if (accessTimeout != null) {
            return new LockGenerator<X>(this, method, next, lockType, accessTimeout.value(), accessTimeout.unit());
        }
        return new LockGenerator<X>(this, method, next, lockType, -1L, null);
    }
}

