/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.extension;

import com.caucho.config.ConfigException;
import com.caucho.config.event.AbstractObserverMethod;
import com.caucho.config.event.EventManager;
import com.caucho.config.extension.AfterBeanDiscoveryImpl;
import com.caucho.config.extension.AfterDeploymentValidationImpl;
import com.caucho.config.extension.BeforeBeanDiscoveryImpl;
import com.caucho.config.extension.ProcessAnnotatedTypeImpl;
import com.caucho.config.extension.ProcessBeanImpl;
import com.caucho.config.extension.ProcessInjectionTargetImpl;
import com.caucho.config.extension.ProcessManagedBeanImpl;
import com.caucho.config.extension.ProcessObserverImpl;
import com.caucho.config.extension.ProcessProducerFieldImpl;
import com.caucho.config.extension.ProcessProducerImpl;
import com.caucho.config.extension.ProcessProducerMethodImpl;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.inject.ProducesFieldBean;
import com.caucho.config.inject.ProducesMethodBean;
import com.caucho.config.program.BeanArg;
import com.caucho.config.reflect.BaseType;
import com.caucho.inject.LazyExtension;
import com.caucho.inject.Module;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.ConcurrentArrayList;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class ExtensionManager {
    private static final L10N L = new L10N(ExtensionManager.class);
    private static final Logger log = Logger.getLogger(ExtensionManager.class.getName());
    private final InjectManager _cdiManager;
    private String _classLoaderHash = "";
    private HashSet<URL> _extensionSet = new HashSet();
    private HashMap<Class<?>, ExtensionItem> _extensionMap = new HashMap();
    private ConcurrentArrayList<PendingEvent> _pendingEventList = new ConcurrentArrayList<PendingEvent>(PendingEvent.class);
    private boolean _isCustomExtension;

    public ExtensionManager(InjectManager cdiManager) {
        this._cdiManager = cdiManager;
    }

    boolean isCustomExtension() {
        return this._isCustomExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateExtensions() {
        try {
            ClassLoader loader = this._cdiManager.getClassLoader();
            if (loader == null) {
                return;
            }
            String hash = DynamicClassLoader.getHash(loader);
            if (this._classLoaderHash.equals(hash)) {
                return;
            }
            this._classLoaderHash = hash;
            Enumeration<URL> e = loader.getResources("META-INF/services/" + Extension.class.getName());
            while (e.hasMoreElements()) {
                Object var10_11;
                URL url = e.nextElement();
                if (this._extensionSet.contains(url)) continue;
                this._extensionSet.add(url);
                InputStream is = null;
                try {
                    try {
                        String line;
                        is = url.openStream();
                        ReadStream in = Vfs.openRead(is);
                        while ((line = in.readLine()) != null) {
                            int p = line.indexOf(35);
                            if (p >= 0) {
                                line = line.substring(0, p);
                            }
                            if ((line = line.trim()).length() <= 0) continue;
                            this.loadExtension(line);
                        }
                        in.close();
                    }
                    catch (IOException e1) {
                        log.log(Level.WARNING, e1.toString(), e1);
                        var10_11 = null;
                        IoUtil.close(is);
                        continue;
                    }
                    var10_11 = null;
                }
                catch (Throwable throwable) {
                    var10_11 = null;
                    IoUtil.close(is);
                    throw throwable;
                }
                IoUtil.close(is);
            }
            return;
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void createExtension(String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName(className, false, loader);
            Constructor<?> ctor = cl.getConstructor(InjectManager.class);
            Extension extension = (Extension)ctor.newInstance(this._cdiManager);
            this.addExtension(extension);
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
        }
    }

    void loadExtension(String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName(className, false, loader);
            if (!Extension.class.isAssignableFrom(cl)) {
                throw new InjectionException(L.l("'{0}' is not a valid extension because it does not implement {1}", (Object)cl, (Object)Extension.class.getName()));
            }
            Extension extension = null;
            for (Constructor<?> ctor : cl.getDeclaredConstructors()) {
                if (ctor.getParameterTypes().length != 0) continue;
                ctor.setAccessible(true);
                extension = (Extension)ctor.newInstance(new Object[0]);
            }
            if (extension == null) {
                extension = (Extension)cl.newInstance();
            }
            this.addExtension(extension);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void addExtension(Extension ext) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " add extension " + ext);
        }
        BeanBuilder<?> beanBuilder = this._cdiManager.createBeanFactory(ext.getClass());
        this._cdiManager.addBean(beanBuilder.singleton(ext));
        ExtensionItem item = this.introspect(ext.getClass());
        for (ExtensionMethod method : item.getExtensionMethods()) {
            Method javaMethod = method.getMethod();
            Class<?> rawType = method.getBaseType().getRawClass();
            ExtensionObserver observer = new ExtensionObserver(ext, method.getMethod(), method.getArgs());
            BaseType baseType = method.getBaseType();
            baseType = baseType.extendGenericType();
            this._cdiManager.getEventManager().addExtensionObserver(observer, baseType, method.getQualifiers());
            if (ProcessAnnotatedType.class.isAssignableFrom(rawType) && !javaMethod.isAnnotationPresent(LazyExtension.class)) {
                this._cdiManager.setIsCustomExtension(true);
            }
            if (ProcessBean.class.isAssignableFrom(rawType) && !javaMethod.isAnnotationPresent(LazyExtension.class)) {
                this._cdiManager.setIsCustomExtension(true);
            }
            if (ProcessInjectionTarget.class.isAssignableFrom(rawType) && !javaMethod.isAnnotationPresent(LazyExtension.class)) {
                this._cdiManager.setIsCustomExtension(true);
            }
            if (!ProcessProducer.class.isAssignableFrom(rawType) || javaMethod.isAnnotationPresent(LazyExtension.class)) continue;
            this._cdiManager.setIsCustomExtension(true);
        }
    }

    private ExtensionItem introspect(Class<?> cl) {
        ExtensionItem item = this._extensionMap.get(cl);
        if (item == null) {
            item = new ExtensionItem(cl);
            this._extensionMap.put(cl, item);
        }
        return item;
    }

    public <T> Bean<T> processBean(Bean<T> bean, ProcessBean<T> processBean) {
        InjectManager cdi = this._cdiManager;
        BaseType baseType = cdi.createTargetBaseType(processBean.getClass());
        baseType = baseType.fill(cdi.createTargetBaseType(bean.getBeanClass()));
        this._pendingEventList.add(new PendingEvent(processBean, baseType));
        return processBean.getBean();
    }

    @Module
    public <T> Bean<T> processBean(Bean<T> bean, Annotated ann) {
        InjectManager cdi = this._cdiManager;
        if (ann == null) {
            ann = cdi.createAnnotatedType(bean.getBeanClass());
        }
        ProcessBeanImpl<T> event = new ProcessBeanImpl<T>(this._cdiManager, bean, ann);
        BaseType baseType = cdi.createTargetBaseType(event.getClass());
        baseType = baseType.fill(cdi.createTargetBaseType(bean.getBeanClass()));
        this._pendingEventList.add(new PendingEvent(event, baseType));
        return event.getBean();
    }

    @Module
    public <T> Bean<T> processManagedBean(ManagedBeanImpl<T> bean, Annotated ann) {
        InjectManager cdi = this._cdiManager;
        ProcessManagedBeanImpl<T> event = new ProcessManagedBeanImpl<T>(this._cdiManager, bean, ann);
        BaseType baseType = cdi.createTargetBaseType(event.getClass());
        baseType = baseType.fill(cdi.createTargetBaseType(bean.getBeanClass()));
        this._pendingEventList.add(new PendingEvent(event, baseType));
        return event.getBean();
    }

    @Module
    public <T, X> Bean<X> processProducerMethod(ProducesMethodBean<T, X> bean) {
        InjectManager cdi = this._cdiManager;
        ProcessProducerMethodImpl<T, X> event = new ProcessProducerMethodImpl<T, X>(this._cdiManager, bean);
        AnnotatedMethod<T> method = bean.getProducesMethod();
        Bean<?> producerBean = bean.getProducerBean();
        BaseType baseType = cdi.createTargetBaseType(event.getClass());
        baseType = baseType.fill(cdi.createTargetBaseType(method.getBaseType()), cdi.createTargetBaseType(producerBean.getBeanClass()));
        this._pendingEventList.add(new PendingEvent(event, baseType));
        return event.getBean();
    }

    @Module
    public <T, X> Bean<X> processProducerField(ProducesFieldBean<T, X> bean) {
        InjectManager cdi = this._cdiManager;
        ProcessProducerFieldImpl<T, X> event = new ProcessProducerFieldImpl<T, X>(this._cdiManager, bean);
        AnnotatedField<T> field = bean.getField();
        BaseType baseType = cdi.createTargetBaseType(event.getClass());
        baseType = baseType.fill(cdi.createTargetBaseType(field.getBaseType()), cdi.createTargetBaseType(bean.getProducerBean().getBeanClass()));
        this._pendingEventList.add(new PendingEvent(event, baseType));
        return event.getBean();
    }

    public void processPendingEvents() {
        while (this._pendingEventList.size() > 0) {
            PendingEvent event = this._pendingEventList.remove(0);
            this.getEventManager().fireExtensionEvent(event.getEvent(), event.getType(), new Annotation[0]);
        }
    }

    public <T> InjectionTarget<T> processInjectionTarget(InjectionTarget<T> target, AnnotatedType<T> annotatedType) {
        InjectManager cdi = this._cdiManager;
        ProcessInjectionTargetImpl<T> processTarget = new ProcessInjectionTargetImpl<T>(this._cdiManager, target, annotatedType);
        BaseType eventType = cdi.createTargetBaseType((Type)((Object)ProcessInjectionTargetImpl.class));
        eventType = eventType.fill(cdi.createTargetBaseType(annotatedType.getBaseType()));
        this.getEventManager().fireExtensionEvent(processTarget, eventType, new Annotation[0]);
        return processTarget.getInjectionTarget();
    }

    public <X, T> Producer<T> processProducer(AnnotatedMethod<X> producesMethod, Producer<T> producer) {
        InjectManager cdi = this._cdiManager;
        ProcessProducerImpl<T, X> event = new ProcessProducerImpl<T, X>(producesMethod, producer);
        AnnotatedType declaringType = producesMethod.getDeclaringType();
        Class<?> declaringClass = declaringType != null ? declaringType.getBaseType() : producesMethod.getJavaMember().getDeclaringClass();
        BaseType eventType = cdi.createTargetBaseType((Type)((Object)ProcessProducerImpl.class));
        eventType = eventType.fill(cdi.createTargetBaseType(producesMethod.getBaseType()), cdi.createTargetBaseType(declaringClass));
        this.getEventManager().fireExtensionEvent(event, eventType, new Annotation[0]);
        return event.getProducer();
    }

    public <X, T> Producer<T> processProducer(AnnotatedField<X> producesField, Producer<T> producer) {
        InjectManager cdi = this._cdiManager;
        ProcessProducerImpl<T, X> event = new ProcessProducerImpl<T, X>(producesField, producer);
        AnnotatedType declaringType = producesField.getDeclaringType();
        BaseType eventType = cdi.createTargetBaseType((Type)((Object)ProcessProducerImpl.class));
        eventType = eventType.fill(cdi.createTargetBaseType(producesField.getBaseType()), cdi.createTargetBaseType(declaringType.getBaseType()));
        this.getEventManager().fireExtensionEvent(event, eventType, new Annotation[0]);
        return event.getProducer();
    }

    public <T, X> void processObserver(ObserverMethod<T> observer, AnnotatedMethod<X> method) {
        ProcessObserverImpl<T, X> event = new ProcessObserverImpl<T, X>(this._cdiManager, observer, method);
        AnnotatedMethod<X> annotatedMethod = event.getAnnotatedMethod();
        AnnotatedType declaringType = annotatedMethod.getDeclaringType();
        ObserverMethod<T> observerMethod = event.getObserverMethod();
        Type observedType = observerMethod.getObservedType();
        BaseType eventType = this._cdiManager.createTargetBaseType((Type)((Object)ProcessObserverImpl.class));
        eventType = eventType.fill(this._cdiManager.createTargetBaseType(observedType), this._cdiManager.createTargetBaseType(declaringType.getBaseType()));
        this.getEventManager().fireExtensionEvent(event, eventType, new Annotation[0]);
    }

    public void fireBeforeBeanDiscovery() {
        this.getEventManager().fireExtensionEvent((Object)new BeforeBeanDiscoveryImpl(this._cdiManager), new Annotation[0]);
    }

    public void fireAfterBeanDiscovery() {
        this.getEventManager().fireExtensionEvent((Object)new AfterBeanDiscoveryImpl(this._cdiManager), new Annotation[0]);
    }

    public void fireAfterDeploymentValidation() {
        AfterDeploymentValidationImpl event = new AfterDeploymentValidationImpl(this._cdiManager);
        this.getEventManager().fireExtensionEvent((Object)event, new Annotation[0]);
    }

    public <T> AnnotatedType<T> processAnnotatedType(AnnotatedType<T> type) {
        InjectManager cdi = this._cdiManager;
        ProcessAnnotatedTypeImpl<T> processType = new ProcessAnnotatedTypeImpl<T>(type);
        BaseType baseType = cdi.createTargetBaseType((Type)((Object)ProcessAnnotatedTypeImpl.class));
        baseType = baseType.fill(cdi.createTargetBaseType(type.getBaseType()));
        this.getEventManager().fireExtensionEvent(processType, baseType, new Annotation[0]);
        if (processType.isVeto()) {
            return null;
        }
        type = processType.getAnnotatedType();
        return type;
    }

    private EventManager getEventManager() {
        return this._cdiManager.getEventManager();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cdiManager + "]";
    }

    static class PendingEvent {
        private Object _event;
        private BaseType _type;

        PendingEvent(Object event, BaseType type) {
            this._event = event;
            this._type = type;
        }

        public Object getEvent() {
            return this._event;
        }

        public BaseType getType() {
            return this._type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExtensionObserver
    extends AbstractObserverMethod<Object> {
        private Extension _extension;
        private Method _method;
        private BeanArg<?>[] _args;

        ExtensionObserver(Extension extension, Method method, BeanArg<?>[] args) {
            this._extension = extension;
            this._method = method;
            this._args = args;
        }

        @Override
        public void notify(Object event) {
            try {
                Object[] args = new Object[this._args.length];
                args[0] = event;
                for (int i = 1; i < args.length; ++i) {
                    args[i] = this._args[i].eval(null);
                }
                this._method.invoke((Object)this._extension, args);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                String loc = this._extension + "." + this._method.getName() + ": ";
                Throwable cause = e.getCause();
                if (cause instanceof ConfigException) {
                    throw (ConfigException)cause;
                }
                throw new InjectionException(loc + cause.getMessage(), cause);
            }
            catch (Exception e) {
                String loc = this._extension + "." + this._method.getName() + ": ";
                throw new InjectionException(loc + e.getMessage(), e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._extension + "," + this._method.getName() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExtensionMethod {
        private final Method _method;
        private final BaseType _type;
        private final Annotation[] _qualifiers;
        private final BeanArg<?>[] _args;

        ExtensionMethod(Method method, BaseType type, Annotation[] qualifiers, BeanArg<?>[] args) {
            this._method = method;
            method.setAccessible(true);
            this._type = type;
            this._qualifiers = qualifiers;
            this._args = args;
        }

        public Method getMethod() {
            return this._method;
        }

        public BeanArg<?>[] getArgs() {
            return this._args;
        }

        public BaseType getBaseType() {
            return this._type;
        }

        public Annotation[] getQualifiers() {
            return this._qualifiers;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._method + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExtensionItem {
        private ArrayList<ExtensionMethod> _observers = new ArrayList();

        ExtensionItem(Class<?> cl) {
            for (Method method : cl.getDeclaredMethods()) {
                ExtensionMethod extMethod = this.bindObserver(cl, method);
                if (extMethod == null) continue;
                this._observers.add(extMethod);
            }
        }

        private ArrayList<ExtensionMethod> getExtensionMethods() {
            return this._observers;
        }

        private ExtensionMethod bindObserver(Class<?> cl, Method method) {
            Type[] param = method.getGenericParameterTypes();
            if (param.length < 1) {
                return null;
            }
            Annotation[][] paramAnn = method.getParameterAnnotations();
            if (!this.hasObserver(paramAnn)) {
                return null;
            }
            InjectManager inject = ExtensionManager.this._cdiManager;
            BeanArg[] args = new BeanArg[param.length];
            for (int i = 1; i < param.length; ++i) {
                Annotation[] bindings = inject.getQualifiers(paramAnn[i]);
                if (bindings.length == 0) {
                    bindings = new Annotation[]{DefaultLiteral.DEFAULT};
                }
                InjectionPoint ip = null;
                args[i] = new BeanArg(inject, param[i], bindings, ip);
            }
            BaseType baseType = inject.createTargetBaseType(param[0]);
            return new ExtensionMethod(method, baseType, inject.getQualifiers(paramAnn[0]), args);
        }

        private boolean hasObserver(Annotation[][] paramAnn) {
            for (int i = 0; i < paramAnn.length; ++i) {
                for (int j = 0; j < paramAnn[i].length; ++j) {
                    if (!paramAnn[i][j].annotationType().equals(Observes.class)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

