/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.ConfigAdmin;
import com.caucho.config.ConfigELContext;
import com.caucho.config.ConfigException;
import com.caucho.config.ConfigRuntimeException;
import com.caucho.config.LineConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.config.types.DirVar;
import com.caucho.config.types.FileVar;
import com.caucho.config.xml.XmlConfigContext;
import com.caucho.el.EL;
import com.caucho.el.EnvironmentContext;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.relaxng.CompactVerifierFactoryImpl;
import com.caucho.relaxng.Schema;
import com.caucho.relaxng.Verifier;
import com.caucho.relaxng.VerifierFilter;
import com.caucho.util.DisplayableException;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.xml.DOMBuilder;
import com.caucho.xml.QAttr;
import com.caucho.xml.QDocument;
import com.caucho.xml.QName;
import com.caucho.xml.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private static final L10N L = new L10N(Config.class);
    private static final Logger log = Logger.getLogger(Config.class.getName());
    private static final EnvironmentLocal<ConfigProperties> _envProperties = new EnvironmentLocal();
    private ClassLoader _classLoader;
    private boolean _isEL = true;
    private boolean _isIgnoreEnvironment;
    private boolean _allowResinInclude;

    public Config() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public Config(ClassLoader loader) {
        this._classLoader = loader;
    }

    public void setResinInclude(boolean useResinInclude) {
        this._allowResinInclude = useResinInclude;
    }

    public boolean isEL() {
        return this._isEL;
    }

    public void setEL(boolean isEL) {
        this._isEL = isEL;
    }

    public boolean isIgnoreEnvironment() {
        return this._isIgnoreEnvironment;
    }

    public void setIgnoreEnvironment(boolean isIgnore) {
        this._isIgnoreEnvironment = isIgnore;
    }

    public static Object getProperty(String key) {
        ConfigProperties props = _envProperties.get();
        if (props != null) {
            return props.get(key);
        }
        return null;
    }

    public static ConfigProperties getConfigProperties() {
        return _envProperties.get();
    }

    public static void setProperty(String key, Object value) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Config.setProperty(key, value, loader);
    }

    public static void setProperty(String key, Object value, ClassLoader loader) {
        ConfigProperties props = _envProperties.getLevel(loader);
        if (props == null) {
            props = Config.createConfigProperties(loader);
        }
        props.put(key, value);
    }

    private static ConfigProperties createConfigProperties(ClassLoader loader) {
        EnvironmentClassLoader envLoader = Environment.getEnvironmentClassLoader(loader);
        ConfigProperties props = _envProperties.getLevel(envLoader);
        if (props != null) {
            return props;
        }
        if (envLoader != null) {
            ConfigProperties parent = Config.createConfigProperties(envLoader.getParent());
            props = new ConfigProperties(parent);
        } else {
            props = new ConfigProperties(null);
        }
        _envProperties.set(props, envLoader);
        return props;
    }

    public Object configure(Object obj, Path path) throws ConfigException, IOException {
        try {
            QDocument doc = this.parseDocument(path, null);
            return this.configure(obj, doc.getDocumentElement());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public Object configure(Object obj, InputStream is) throws Exception {
        QDocument doc = this.parseDocument(is, null);
        return this.configure(obj, doc.getDocumentElement());
    }

    public Object configure(Object obj, Path path, String schemaLocation) throws ConfigException {
        try {
            Schema schema = this.findCompactSchema(schemaLocation);
            QDocument doc = this.parseDocument(path, schema);
            return this.configure(obj, doc.getDocumentElement());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw LineConfigException.create(e);
        }
    }

    public Object configure(Object obj, Path path, Schema schema) throws ConfigException {
        try {
            QDocument doc = this.parseDocument(path, schema);
            return this.configure(obj, doc.getDocumentElement());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public Object configure(Object obj, InputStream is, String schemaLocation) throws Exception {
        Schema schema = this.findCompactSchema(schemaLocation);
        QDocument doc = this.parseDocument(is, schema);
        return this.configure(obj, doc.getDocumentElement());
    }

    public Object configure(Object obj, InputStream is, Schema schema) throws Exception {
        QDocument doc = this.parseDocument(is, schema);
        return this.configure(obj, doc.getDocumentElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object configure(Object obj, Node topNode) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            XmlConfigContext builder = this.createBuilder();
            Config.setProperty("__FILE__", FileVar.__FILE__);
            Config.setProperty("__DIR__", DirVar.__DIR__);
            Object object = builder.configure(obj, topNode);
            Object var8_7 = null;
            thread.setContextClassLoader(oldLoader);
            return object;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public void configureBean(Object obj, Path path, String schemaLocation) throws Exception {
        Schema schema = this.findCompactSchema(schemaLocation);
        QDocument doc = this.parseDocument(path, schema);
        this.configureBean(obj, doc.getDocumentElement());
    }

    public void configureBean(Object obj, Path path) throws Exception {
        QDocument doc = this.parseDocument(path, null);
        this.configureBean(obj, doc.getDocumentElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureBean(Object obj, Node topNode) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            XmlConfigContext builder = this.createBuilder();
            InjectManager webBeans = InjectManager.create();
            Config.setProperty("__FILE__", FileVar.__FILE__);
            Config.setProperty("__DIR__", DirVar.__DIR__);
            builder.configureBean(obj, topNode);
            Object var8_7 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    private XmlConfigContext createBuilder() {
        return new XmlConfigContext(this);
    }

    public void configureBean(Object obj, Path path, Schema schema) throws Exception {
        QDocument doc = this.parseDocument(path, schema);
        this.configureBean(obj, doc.getDocumentElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QDocument parseDocument(Path path, Schema schema) throws LineConfigException, IOException, SAXException {
        QDocument doc;
        SoftReference docRef = null;
        if (docRef != null && (doc = (QDocument)docRef.get()) != null && !doc.isModified()) {
            return doc;
        }
        ReadStream is = path.openRead();
        try {
            QDocument qDocument = doc = this.parseDocument(is, schema);
            Object var8_7 = null;
            is.close();
            return qDocument;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            is.close();
            throw throwable;
        }
    }

    private QDocument parseDocument(InputStream is, Schema schema) throws LineConfigException, IOException, SAXException {
        QDocument doc = new QDocument();
        DOMBuilder builder = new DOMBuilder();
        builder.init(doc);
        String systemId = null;
        String filename = null;
        Path path = null;
        if (is instanceof ReadStream) {
            path = ((ReadStream)is).getPath();
            systemId = path.getURL();
            filename = path.getUserPath();
        }
        doc.setSystemId(systemId);
        builder.setSystemId(systemId);
        doc.setRootFilename(filename);
        builder.setFilename(filename);
        builder.setSkipWhitespace(true);
        InputSource in = new InputSource();
        in.setByteStream(is);
        in.setSystemId(systemId);
        Xml xml = new Xml();
        xml.setOwner(doc);
        xml.setResinInclude(this._allowResinInclude);
        xml.setFilename(filename);
        if (schema != null) {
            Verifier verifier = schema.newVerifier();
            VerifierFilter filter = verifier.getVerifierFilter();
            filter.setParent(xml);
            filter.setContentHandler(builder);
            filter.setErrorHandler(builder);
            filter.parse(in);
        } else {
            xml.setContentHandler(builder);
            xml.parse(in);
        }
        if (path != null) {
            ConfigAdmin.registerPath(path);
        }
        return doc;
    }

    private Schema findCompactSchema(String location) throws IOException, ConfigException {
        try {
            URL url;
            if (location == null) {
                return null;
            }
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            if ((url = loader.getResource(location)) == null) {
                return null;
            }
            Path path = Vfs.lookup(URLDecoder.decode(url.toString()));
            CompactVerifierFactoryImpl factory = new CompactVerifierFactoryImpl();
            return factory.compileSchema(path);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public static void checkCanInstantiate(Class beanClass) throws ConfigException {
        if (beanClass == null) {
            throw new ConfigException(L.l("null classes can't be instantiated."));
        }
        if (beanClass.isInterface()) {
            throw new ConfigException(L.l("'{0}' must be a concrete class.  Interfaces cannot be instantiated.", (Object)beanClass.getName()));
        }
        if (!Modifier.isPublic(beanClass.getModifiers())) {
            throw new ConfigException(L.l("Custom bean class '{0}' is not public.  Bean classes must be public, concrete, and have a zero-argument constructor.", (Object)beanClass.getName()));
        }
        if (Modifier.isAbstract(beanClass.getModifiers())) {
            throw new ConfigException(L.l("Custom bean class '{0}' is abstract.  Bean classes must be public, concrete, and have a zero-argument constructor.", (Object)beanClass.getName()));
        }
        Constructor<?>[] constructors = beanClass.getDeclaredConstructors();
        Constructor<?> constructor = null;
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != 0) continue;
            constructor = constructors[i];
            break;
        }
        if (constructor == null) {
            throw new ConfigException(L.l("Custom bean class '{0}' doesn't have a zero-arg constructor.  Bean classes must be have a zero-argument constructor.", (Object)beanClass.getName()));
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new ConfigException(L.l("The zero-argument constructor for '{0}' isn't public.  Bean classes must have a public zero-argument constructor.", (Object)beanClass.getName()));
        }
    }

    public static void validate(Class cl, Class api) throws ConfigException {
        Config.checkCanInstantiate(cl);
        if (!api.isAssignableFrom(cl)) {
            throw new ConfigException(L.l("{0} must implement {1}.", (Object)cl.getName(), (Object)api.getName()));
        }
    }

    public static void checkCanInstantiate(Class beanClass, Class type) throws ConfigException {
        if (beanClass == null) {
            throw new ConfigException(L.l("null classes can't be instantiated."));
        }
        if (beanClass.isInterface()) {
            throw new ConfigException(L.l("'{0}' must be a concrete class.  Interfaces cannot be instantiated.", (Object)beanClass.getName()));
        }
        if (!Modifier.isPublic(beanClass.getModifiers())) {
            throw new ConfigException(L.l("Custom bean class '{0}' is not public.  Bean classes must be public, concrete, and have a zero-argument constructor.", (Object)beanClass.getName()));
        }
        if (Modifier.isAbstract(beanClass.getModifiers())) {
            throw new ConfigException(L.l("Custom bean class '{0}' is abstract.  Bean classes must be public, concrete, and have a zero-argument constructor.", (Object)beanClass.getName()));
        }
        Constructor<?>[] constructors = beanClass.getDeclaredConstructors();
        Constructor<?> zeroArgsConstructor = null;
        Constructor<?> singleArgConstructor = null;
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length == 0) {
                zeroArgsConstructor = constructors[i];
                if (singleArgConstructor == null) continue;
                break;
            }
            if (type == null || constructors[i].getParameterTypes().length != 1 || !type.isAssignableFrom(constructors[i].getParameterTypes()[0])) continue;
            singleArgConstructor = constructors[i];
            if (zeroArgsConstructor != null) break;
        }
        if (zeroArgsConstructor == null && singleArgConstructor == null) {
            if (type != null) {
                throw new ConfigException(L.l("Custom bean class '{0}' doesn't have a zero-arg constructor, or a constructor accepting parameter of type '{1}'.  Bean class '{0}' must have a zero-argument constructor, or a constructor accepting parameter of type '{1}'", (Object)beanClass.getName(), (Object)type.getName()));
            }
            throw new ConfigException(L.l("Custom bean class '{0}' doesn't have a zero-arg constructor.  Bean classes must have a zero-argument constructor.", (Object)beanClass.getName()));
        }
        if (singleArgConstructor != null) {
            if (!(Modifier.isPublic(singleArgConstructor.getModifiers()) || zeroArgsConstructor != null && Modifier.isPublic(zeroArgsConstructor.getModifiers()))) {
                throw new ConfigException(L.l("The constructor for bean '{0}' accepting parameter of type '{1}' is not public.  Constructor accepting parameter of type '{1}' must be public.", (Object)beanClass.getName(), (Object)type.getName()));
            }
        } else if (zeroArgsConstructor != null && !Modifier.isPublic(zeroArgsConstructor.getModifiers())) {
            throw new ConfigException(L.l("The zero-argument constructor for '{0}' isn't public.  Bean classes must have a public zero-argument constructor.", (Object)beanClass.getName()));
        }
    }

    public static void validate(Class cl, Class api, Class type) throws ConfigException {
        Config.checkCanInstantiate(cl, type);
        if (!api.isAssignableFrom(cl)) {
            throw new ConfigException(L.l("{0} must implement {1}.", (Object)cl.getName(), (Object)api.getName()));
        }
    }

    public static void setAttribute(Object obj, String attr, Object value) {
        QName attrName;
        ConfigType<?> type = TypeFactory.getType(obj.getClass());
        Attribute attrStrategy = type.getAttribute(attrName = new QName(attr));
        if (attrStrategy == null) {
            throw new ConfigException(L.l("{0}: '{1}' is an unknown attribute.", (Object)obj.getClass().getName(), (Object)attrName.getName()));
        }
        value = attrStrategy.getConfigType().valueOf(value);
        attrStrategy.setValue(obj, attrName, value);
    }

    public static void setStringAttribute(Object obj, String attr, String value) throws Exception {
        XmlConfigContext builder = new XmlConfigContext();
        QAttr qAttr = new QAttr(attr);
        qAttr.setValue(value);
        builder.configureAttribute(obj, qAttr);
    }

    public static void init(Object bean) throws ConfigException {
        try {
            ConfigType<?> type = TypeFactory.getType(bean.getClass());
            type.init(bean);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public static void inject(Object bean) throws ConfigException {
        try {
            ConfigType<?> type = TypeFactory.getType(bean.getClass());
            type.inject(bean);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public static Object replaceObject(Object bean) throws Exception {
        ConfigType<?> type = TypeFactory.getType(bean.getClass());
        return type.replaceObject(bean);
    }

    public static ELContext getEnvironment() {
        XmlConfigContext builder = XmlConfigContext.getCurrentBuilder();
        if (builder != null) {
            return builder.getELContext();
        }
        return EL.getEnvironment();
    }

    public static ConfigELContext getELContext() {
        XmlConfigContext builder = XmlConfigContext.getCurrentBuilder();
        if (builder != null) {
            return builder.getELContext();
        }
        return null;
    }

    public static Object getElVar(String var) {
        ELContext context = Config.getEnvironment();
        if (context != null) {
            return context.getELResolver().getValue(context, null, var);
        }
        return Config.getProperty(var);
    }

    public static Object getCurrentVar(String var) {
        return Config.getProperty(var);
    }

    public static String evalString(String str) throws ELException {
        ELContext elContext = ConfigELContext.EL_CONTEXT;
        if (elContext == null) {
            elContext = Config.getEnvironment();
        }
        return EL.evalString(str, elContext);
    }

    public static String evalString(String str, HashMap<String, Object> varMap) throws ELException {
        return EL.evalString(str, Config.getEnvironment(varMap));
    }

    public static boolean evalBoolean(String str) throws ELException {
        return EL.evalBoolean(str, Config.getEnvironment());
    }

    public static ELContext getEnvironment(HashMap<String, Object> varMap) {
        if (varMap != null) {
            return new EnvironmentContext(varMap);
        }
        return new EnvironmentContext();
    }

    public static ConfigException error(Field field, String msg) {
        return new ConfigException(Config.location(field) + msg);
    }

    public static ConfigException error(Method method, String msg) {
        return new ConfigException(Config.location(method) + msg);
    }

    public static RuntimeException createLine(String systemId, int line, Throwable e) {
        while (e.getCause() != null && (e instanceof InstantiationException || e instanceof InvocationTargetException || e.getClass().equals(ConfigRuntimeException.class))) {
            e = e.getCause();
        }
        if (e instanceof LineConfigException) {
            throw (LineConfigException)e;
        }
        String lines = Config.getSourceLines(systemId, line);
        String loc = systemId + ":" + line + ": ";
        if (e instanceof DisplayableException) {
            return new LineConfigException(loc + e.getMessage() + "\n" + lines, e);
        }
        return new LineConfigException(loc + e + "\n" + lines, e);
    }

    public static String location(Field field) {
        String className = field.getDeclaringClass().getName();
        return className + "." + field.getName() + ": ";
    }

    public static String location(Method method) {
        String className = method.getDeclaringClass().getName();
        return className + "." + method.getName() + ": ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSourceLines(String systemId, int errorLine) {
        if (systemId == null) {
            return "";
        }
        ReadStream is = null;
        try {
            String text;
            is = Vfs.lookup().lookup(systemId).openRead();
            int line = 0;
            StringBuilder sb = new StringBuilder("\n\n");
            while ((text = is.readLine()) != null) {
                if (errorLine - 2 > ++line || line > errorLine + 2) continue;
                sb.append(line);
                sb.append(": ");
                sb.append(text);
                sb.append("\n");
            }
            String string = sb.toString();
            Object var8_9 = null;
            if (is != null) {
                is.close();
            }
            return string;
        }
        catch (IOException e) {
            try {
                log.log(Level.FINEST, e.toString(), e);
                String string = "";
                Object var8_10 = null;
                if (is != null) {
                    is.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var8_11 = null;
                    if (is == null) break block8;
                    is.close();
                }
                throw throwable;
            }
        }
    }

    static class ConfigProperties {
        private ConfigProperties _parent;
        private HashMap<String, Object> _properties = new HashMap(8);

        ConfigProperties(ConfigProperties parent) {
            this._parent = parent;
        }

        public Object get(String key) {
            Object value = this._properties.get(key);
            if (value != null) {
                return value;
            }
            if (this._parent != null) {
                return this._parent.get(key);
            }
            return null;
        }

        public void put(String key, Object value) {
            this._properties.put(key, value);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[]";
        }
    }
}

