/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.topology;

import com.caucho.cloud.topology.TriadDispatcher;
import com.caucho.cloud.topology.TriadDispatcherDouble;
import com.caucho.cloud.topology.TriadOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriadDispatcherTriple<X>
extends TriadDispatcher<X> {
    private final X _valueA;
    private final X _valueB;
    private final X _valueC;

    public TriadDispatcherTriple(X valueA, X valueB, X valueC) {
        this._valueA = valueA;
        this._valueB = valueB;
        this._valueC = valueC;
        if (valueA == null) {
            throw new NullPointerException();
        }
        if (valueB == null) {
            throw new NullPointerException();
        }
        if (valueC == null) {
            throw new NullPointerException();
        }
    }

    public static <T> TriadDispatcher<T> create(T valueA, T valueB, T valueC) {
        if (valueA == null) {
            return TriadDispatcherDouble.create(valueB, valueC);
        }
        if (valueB == null) {
            return TriadDispatcherDouble.create(valueA, valueC);
        }
        if (valueC == null) {
            return TriadDispatcherDouble.create(valueB, valueC);
        }
        return new TriadDispatcherTriple<T>(valueA, valueB, valueC);
    }

    @Override
    public X getA() {
        return this._valueA;
    }

    @Override
    public X getB() {
        return this._valueB;
    }

    @Override
    public X getC() {
        return this._valueC;
    }

    @Override
    public X primary(TriadOwner owner) {
        switch (owner) {
            case A_B: 
            case A_C: {
                return this._valueA;
            }
            case B_A: 
            case B_C: {
                return this._valueB;
            }
            case C_A: 
            case C_B: {
                return this._valueC;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public X secondary(TriadOwner owner) {
        switch (owner) {
            case B_A: 
            case C_A: {
                return this._valueA;
            }
            case A_B: 
            case C_B: {
                return this._valueB;
            }
            case A_C: 
            case B_C: {
                return this._valueC;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public X tertiary(TriadOwner owner) {
        switch (owner) {
            case B_C: 
            case C_B: {
                return this._valueA;
            }
            case A_C: 
            case C_A: {
                return this._valueB;
            }
            case A_B: 
            case B_A: {
                return this._valueC;
            }
        }
        throw new IllegalStateException();
    }
}

