/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.topology;

import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudServerState;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.cloud.topology.TriadOwner;
import com.caucho.config.ConfigException;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudServer {
    private static final L10N L = new L10N(CloudServer.class);
    private static final Logger log = Logger.getLogger(CloudServer.class.getName());
    private static final int[] DECODE = new int[128];
    private final String _id;
    private final String _displayId;
    private final CloudPod _pod;
    private final int _index;
    private final ServerType _isStatic;
    private final String _uniqueClusterId;
    private final String _uniqueDomainId;
    private final String _address;
    private final int _port;
    private final boolean _isSSL;
    private final boolean _isAllowExternal;
    private boolean _isSelf;
    private final ConcurrentHashMap<Class<?>, Object> _dataMap = new ConcurrentHashMap();
    private CloudServerState _state = CloudServerState.UNKNOWN;

    public CloudServer(String id, String displayId, CloudPod pod, int index, String address, int port, boolean isSSL, ServerType isStatic, boolean isAllowExternal) {
        if (id.equals("")) {
            throw new IllegalArgumentException();
        }
        this._id = id;
        this._displayId = displayId;
        this._pod = pod;
        this._index = index;
        if (index < 0) {
            throw new IllegalArgumentException(L.l("'{0}' is an invalid server index because it must be between 0 and 64", index));
        }
        if (index >= 64) {
            throw new IllegalArgumentException(L.l("'{0}' is an invalid server index because it would configure more than 64 servers to the pod. Clusters with more than 64 servers must be split into multiple pods.", index));
        }
        if (!isStatic.isStatic() && index == 0) {
            throw new IllegalArgumentException(L.l("The first server must be static."));
        }
        if (id == null) {
            throw new NullPointerException();
        }
        if (pod == null) {
            throw new NullPointerException();
        }
        this._address = address;
        this._port = port;
        this._isSSL = isSSL;
        this._isStatic = isStatic;
        this._isAllowExternal = isAllowExternal;
        StringBuilder sb = new StringBuilder();
        sb.append(CloudServer.convert(this.getIndex()));
        sb.append(CloudServer.convert(this.getPod().getIndex()));
        sb.append(CloudServer.convert(this.getPod().getIndex() / 64));
        this._uniqueClusterId = sb.toString();
        String clusterId = pod.getCluster().getId();
        if (clusterId.equals("")) {
            clusterId = "default";
        }
        this._uniqueDomainId = this._uniqueClusterId + "." + clusterId.replace('.', '_');
        if (!(this.isLocalAddress(this.getAddress()) || this.isExternal() || this.isAllowExternal())) {
            throw new ConfigException(L.l("'{0}' is not a valid cluster IP address because it is not a private network IP address.", (Object)this.getAddress()));
        }
        CloudServer oldServer = pod.getSystem().findServer(address, port);
        if (oldServer != null) {
            throw new IllegalArgumentException(L.l("'{0}' is an invalid server because it has the same IP:port as '{1}", (Object)this, (Object)oldServer));
        }
    }

    private boolean isLocalAddress(String address) {
        try {
            InetAddress addr = InetAddress.getByName(address);
            byte[] ipAddress = addr.getAddress();
            if (ipAddress.length == 16) {
                return true;
            }
            if (ipAddress.length != 4) {
                return false;
            }
            if (ipAddress[0] == 0) {
                return true;
            }
            if (ipAddress[0] == 127) {
                return true;
            }
            if (ipAddress[0] == 10) {
                return true;
            }
            if ((ipAddress[0] & 0xFF) == 192 && (ipAddress[1] & 0xFF) == 168) {
                return true;
            }
            if ((ipAddress[0] & 0xFF) == 169 && (ipAddress[1] & 0xFF) == 254) {
                return true;
            }
            return (ipAddress[0] & 0xFF) == 172 && (ipAddress[1] & 0xF0) == 16;
        }
        catch (Exception e) {
            return false;
        }
    }

    public final String getId() {
        return this._id;
    }

    public final String getDisplayId() {
        return this._displayId;
    }

    public final String getDebugId() {
        if ("".equals(this._id)) {
            return "default";
        }
        return this._id;
    }

    public final int getIndex() {
        return this._index;
    }

    public final String getIdWithinCluster() {
        return this._uniqueClusterId;
    }

    public final String getIdWithinDomain() {
        return this._uniqueDomainId;
    }

    public boolean isTriad() {
        return false;
    }

    public boolean isStatic() {
        return this._isStatic.isStatic();
    }

    public boolean isExternal() {
        return this._isStatic.isExternal();
    }

    public boolean isAllowExternal() {
        return this._isAllowExternal;
    }

    public boolean isSelf() {
        return this._isSelf;
    }

    public void setSelf(boolean isSelf) {
        this._isSelf = isSelf;
        this._pod.setSelf(isSelf);
    }

    public CloudServerState getState() {
        return this._state;
    }

    public CloudPod getPod() {
        return this._pod;
    }

    public CloudCluster getCluster() {
        return this.getPod().getCluster();
    }

    public CloudSystem getSystem() {
        return this.getCluster().getSystem();
    }

    public TriadOwner getTriadOwner() {
        return TriadOwner.getOwner(this.getIndex());
    }

    public final String getAddress() {
        return this._address;
    }

    public final String getIpAddress() {
        try {
            return InetAddress.getByName(this.getAddress()).getHostAddress();
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return this.getAddress();
        }
    }

    public final int getPort() {
        return this._port;
    }

    public boolean isSSL() {
        return this._isSSL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHeartbeatStart() {
        CloudServerState oldState;
        CloudServer cloudServer = this;
        synchronized (cloudServer) {
            oldState = this._state;
            this._state = oldState.onHeartbeatStart();
        }
        if (this._state != oldState) {
            this.updateState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHeartbeatStop() {
        CloudServerState oldState;
        CloudServer cloudServer = this;
        synchronized (cloudServer) {
            oldState = this._state;
            this._state = oldState.onHeartbeatStop();
        }
        if (this._state != oldState) {
            this.updateState();
        }
    }

    public void setState(CloudServerState state) {
        if (this._pod.isSelf()) {
            throw new IllegalStateException();
        }
        this._state = state;
    }

    public void overrideState(CloudServerState state) {
        this._state = state;
        this.updateState();
    }

    public void disable() {
        this.overrideState(CloudServerState.DISABLED);
    }

    public void disableSoft() {
        this.overrideState(CloudServerState.DISABLED_SOFT);
    }

    public void enable() {
        this.overrideState(CloudServerState.ACTIVE);
    }

    private void updateState() {
        this._pod.onServerStateChange(this);
    }

    public void putData(Object value) {
        this._dataMap.put(value.getClass(), value);
    }

    public <T> T putDataIfAbsent(T value) {
        return (T)this._dataMap.putIfAbsent(value.getClass(), value);
    }

    public <T> T getData(Class<T> cl) {
        return (T)this._dataMap.get(cl);
    }

    public <T> T removeData(Class<T> cl) {
        return (T)this._dataMap.remove(cl);
    }

    public String toString() {
        String address = this._address;
        if (CurrentTime.isTest() && address.startsWith("192.168.1.")) {
            address = "192.168.1.x";
        }
        return this.getClass().getSimpleName() + "[" + this._id + "," + this._index + "," + address + ":" + this._port + "]";
    }

    private static char convert(long code) {
        if ((code &= 0x3FL) < 26L) {
            return (char)(97L + code);
        }
        if (code < 52L) {
            return (char)(65L + code - 26L);
        }
        if (code < 62L) {
            return (char)(48L + code - 52L);
        }
        if (code == 62L) {
            return '_';
        }
        return '-';
    }

    public static int decode(int code) {
        return DECODE[code & 0x7F];
    }

    static {
        for (int i = 0; i < 64; ++i) {
            CloudServer.DECODE[CloudServer.convert((long)((long)i))] = i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerType {
        STATIC{

            public boolean isStatic() {
                return true;
            }
        }
        ,
        EXTERNAL{

            public boolean isStatic() {
                return true;
            }

            public boolean isExternal() {
                return true;
            }
        }
        ,
        DYNAMIC{};


        public boolean isStatic() {
            return false;
        }

        public boolean isExternal() {
            return false;
        }
    }
}

