/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.network;

import com.caucho.cloud.network.NetworkClusterSystem;
import com.caucho.cloud.network.NetworkServerConfig;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.config.ConfigException;
import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.network.listen.TcpPort;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.vfs.QServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkListenSystem
extends AbstractResinSubSystem
implements AlarmListener {
    public static final int START_PRIORITY_AT_BEGIN = 50;
    public static final int START_PRIORITY_AT_END = 90;
    private static final L10N L = new L10N(NetworkListenSystem.class);
    private static final Logger log = Logger.getLogger(NetworkListenSystem.class.getName());
    private static final long ALARM_TIMEOUT = 120000L;
    private final CloudServer _cloudServer;
    private TcpPort _clusterListener;
    private final ArrayList<TcpPort> _listeners = new ArrayList();
    private boolean _isBindPortsAtEnd = true;
    private Alarm _alarm;

    private NetworkListenSystem(CloudServer cloudServer) {
        this._cloudServer = cloudServer;
        NetworkClusterSystem clusterService = NetworkClusterSystem.getCurrent();
        if (clusterService != null) {
            this._clusterListener = clusterService.getClusterListener();
        }
        if (this._clusterListener != null) {
            this._listeners.add(this._clusterListener);
        }
        NetworkServerConfig config = new NetworkServerConfig(this);
        this.configure(this._cloudServer, config);
    }

    public static NetworkListenSystem createAndAddService(CloudServer cloudServer) {
        ResinSystem system = NetworkListenSystem.preCreate(NetworkListenSystem.class);
        NetworkListenSystem service = new NetworkListenSystem(cloudServer);
        system.addService(NetworkListenSystem.class, service);
        return service;
    }

    public static NetworkListenSystem getCurrent() {
        return ResinSystem.getCurrentService(NetworkListenSystem.class);
    }

    public TcpPort getClusterListener() {
        return this._clusterListener;
    }

    public void addListener(TcpPort listener) {
        try {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public void setBindPortsAfterStart(boolean bindAtEnd) {
        this._isBindPortsAtEnd = bindAtEnd;
    }

    public boolean isBindPortsAfterStart() {
        return this._isBindPortsAtEnd;
    }

    public Collection<TcpPort> getListeners() {
        return Collections.unmodifiableList(this._listeners);
    }

    public void bind(String address, int port, QServerSocket ss) throws Exception {
        if ("null".equals(address)) {
            address = null;
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            TcpPort serverPort = this._listeners.get(i);
            if (port != serverPort.getPort() || address == null != (serverPort.getAddress() == null) || address != null && !address.equals(serverPort.getAddress())) continue;
            serverPort.bind(ss);
            return;
        }
        throw new IllegalStateException(L.l("No matching port for {0}:{1}", (Object)address, port));
    }

    public TcpSocketLink findConnectionByThreadId(long threadId) {
        for (TcpPort listener : this.getListeners()) {
            TcpSocketLink conn = listener.findConnectionByThreadId(threadId);
            if (conn == null) continue;
            return conn;
        }
        return null;
    }

    @Override
    public int getStartPriority() {
        if (this._isBindPortsAtEnd) {
            return 90;
        }
        return 50;
    }

    @Override
    public void start() throws Exception {
        boolean isFirst = true;
        for (TcpPort listener : this._listeners) {
            if (listener == this._clusterListener) continue;
            if (isFirst) {
                log.info("");
            }
            isFirst = false;
            listener.bind();
            listener.start();
        }
        if (!isFirst) {
            log.info("");
        }
        this._alarm = new Alarm(this);
        this._alarm.queue(120000L);
    }

    private void configure(CloudServer server, Object config) {
        NetworkClusterSystem.configServer(config, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAlarm(Alarm alarm) {
        try {
            for (TcpPort listener : this._listeners) {
                if (!listener.isClosed()) continue;
                log.severe("Resin restarting due to closed listener: " + listener);
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            alarm = this._alarm;
            if (alarm != null) {
                alarm.queue(120000L);
            }
        }
    }

    @Override
    public void stop() {
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
        for (TcpPort listener : this._listeners) {
            try {
                if (listener == this._clusterListener) continue;
                listener.close();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }
}

