/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.network;

import com.caucho.cloud.network.ClusterLinkListener;
import com.caucho.cloud.network.ClusterServer;
import com.caucho.cloud.network.ClusterServerListener;
import com.caucho.cloud.network.ClusterServerProgram;
import com.caucho.cloud.network.ClusterTcpPort;
import com.caucho.cloud.network.NetworkAddressResult;
import com.caucho.cloud.topology.AbstractCloudClusterListener;
import com.caucho.cloud.topology.AbstractCloudPodListener;
import com.caucho.cloud.topology.AbstractCloudServerListener;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.network.listen.Protocol;
import com.caucho.network.listen.TcpPort;
import com.caucho.server.hmux.HmuxProtocol;
import com.caucho.util.HostUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.net.NetworkSystem;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkClusterSystem
extends AbstractResinSubSystem {
    public static final int START_PRIORITY = 42;
    private static final L10N L = new L10N(NetworkClusterSystem.class);
    private static final Logger log = Logger.getLogger(NetworkClusterSystem.class.getName());
    private static final long CLUSTER_IDLE_TIME_MAX = 0x3FFFFFFFFFFFFFFFL;
    private static final long CLUSTER_IDLE_PADDING = 300000L;
    private final CloudServer _selfServer;
    private TcpPort _clusterListener;
    private HmuxProtocol _clusterProtocol;
    private CopyOnWriteArrayList<ClusterServerListener> _serverListeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<ClusterLinkListener> _linkListeners = new CopyOnWriteArrayList();

    public NetworkClusterSystem(CloudServer selfServer) {
        this._selfServer = selfServer;
        this._selfServer.setSelf(true);
        this._selfServer.getSystem().addClusterListener(new NetworkClusterListener());
        ClusterServer clusterServer = selfServer.getData(ClusterServer.class);
        NetworkSystem.createSubSystem(selfServer.getId());
        if (clusterServer.getPort() >= 0) {
            this._clusterListener = new ClusterTcpPort(clusterServer);
            this._clusterProtocol = HmuxProtocol.create();
        }
    }

    public static void createAndAddService(NetworkClusterSystem clusterSystem) {
        ResinSystem resinSystem = NetworkClusterSystem.preCreate(NetworkClusterSystem.class);
        resinSystem.addService(NetworkClusterSystem.class, clusterSystem);
    }

    public static NetworkClusterSystem getCurrent() {
        return ResinSystem.getCurrentService(NetworkClusterSystem.class);
    }

    public static CloudServer getCurrentSelfServer() {
        NetworkClusterSystem clusterService = NetworkClusterSystem.getCurrent();
        if (clusterService == null) {
            throw new IllegalStateException(L.l("{0} is not available in this context", (Object)NetworkClusterSystem.class.getSimpleName()));
        }
        return clusterService.getSelfServer();
    }

    public CloudServer getSelfServer() {
        return this._selfServer;
    }

    public String getServerId() {
        return this.getSelfServer().getId();
    }

    public TcpPort getClusterListener() {
        return this._clusterListener;
    }

    public void addServerListener(ClusterServerListener listener) {
        this._serverListeners.add(listener);
        CloudServer[] serverList = this._selfServer.getPod().getServerList();
        int serverLength = this._selfServer.getPod().getServerLength();
        for (int i = 0; i < serverLength; ++i) {
            ClusterServer server;
            CloudServer cloudServer = serverList[i];
            if (cloudServer == null || !(server = cloudServer.getData(ClusterServer.class)).isHeartbeatActive()) continue;
            listener.serverStart(server);
        }
    }

    public void removeServerListener(ServerListener listener) {
        this._serverListeners.remove(listener);
    }

    protected void notifyHeartbeatStart(ClusterServer server) {
        for (ClusterServerListener listener : this._serverListeners) {
            listener.serverStart(server);
        }
    }

    protected void notifyHeartbeatStop(ClusterServer server) {
        for (ClusterServerListener listener : this._serverListeners) {
            listener.serverStop(server);
        }
    }

    public void addLinkListener(ClusterLinkListener listener) {
        this._linkListeners.add(listener);
    }

    public void notifyLinkClose(Object payload) {
        for (ClusterLinkListener listener : this._linkListeners) {
            listener.onLinkClose(payload);
        }
    }

    public void addClusterExtensionProtocol(int id, Protocol protocol) {
        this._clusterProtocol.putExtension(id, protocol);
    }

    @Override
    public int getStartPriority() {
        return 42;
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.startClusterListener();
        ClusterServer selfServer = this._selfServer.getData(ClusterServer.class);
        selfServer.notifyHeartbeatStart();
        this.validateTriad(this._selfServer.getPod());
    }

    private void validateTriad(CloudPod pod) {
        CloudServer[] servers = pod.getServerList();
        if (servers.length == 0) {
            return;
        }
        String address = servers[0].getAddress();
        boolean isMultipleAddress = false;
        for (int i = 0; i < servers.length; ++i) {
            if (servers[i] == null || address.equals(servers[i].getAddress())) continue;
            isMultipleAddress = true;
        }
        if (!isMultipleAddress) {
            return;
        }
        int triadMax = Math.min(servers.length, 3);
        for (int i = 0; i < triadMax; ++i) {
            for (int j = i + 1; j < triadMax; ++j) {
                CloudServer serverA = servers[i];
                CloudServer serverB = servers[j];
                if (serverA == null || serverB == null || !serverA.getAddress().equals(serverB.getAddress())) continue;
                log.warning(L.l("Triad servers should be on separate machines for better reliability.\n{0}\n{1}", (Object)serverA, (Object)serverB));
                return;
            }
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        try {
            if (this._clusterListener != null) {
                this._clusterListener.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public NetworkAddressResult getLocalSocketAddress(ClusterServer clusterServer) {
        return null;
    }

    private void configureServer(CloudServer cloudServer) {
        ClusterServer server = new ClusterServer(this, cloudServer);
        NetworkClusterSystem.configServer(server, cloudServer);
        server.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configServer(Object server, CloudServer cloudServer) {
        String oldServerId = (String)Config.getCurrentVar("rvar0");
        String oldClusterId = (String)Config.getCurrentVar("rvar1");
        try {
            Config.setProperty("rvar0", cloudServer.getDisplayId());
            Config.setProperty("rvar1", cloudServer.getCluster().getId());
            CloudCluster cluster = cloudServer.getCluster();
            CloudPod pod = cloudServer.getPod();
            ClusterServerProgram clusterServerProgram = cluster.getData(ClusterServerProgram.class);
            ClusterServerProgram podServerProgram = pod.getData(ClusterServerProgram.class);
            ClusterServerProgram serverProgram = cloudServer.getData(ClusterServerProgram.class);
            if (clusterServerProgram != null) {
                clusterServerProgram.getProgram().configure(server);
            }
            if (podServerProgram != null) {
                podServerProgram.getProgram().configure(server);
            }
            if (serverProgram != null) {
                serverProgram.getProgram().configure(server);
            }
            if (cloudServer.putDataIfAbsent(server) != null) {
                throw new IllegalStateException(L.l("{0} cannot be configured twice.", server));
            }
        }
        finally {
            Config.setProperty("rvar0", oldServerId);
            Config.setProperty("rvar1", oldClusterId);
        }
    }

    private void startClusterListener() throws Exception {
        TcpPort listener = this._clusterListener;
        if (listener != null) {
            ClusterServer clusterServer = this._selfServer.getData(ClusterServer.class);
            long idleTime = clusterServer.getClusterIdleTime() + 300000L;
            listener.setKeepaliveConnectionTimeMaxMillis(0x3FFFFFFFFFFFFFFFL);
            listener.setKeepaliveTimeoutMillis(idleTime);
            listener.setSocketTimeoutMillis(clusterServer.getClusterSocketTimeout());
            listener.setProtocol(this._clusterProtocol);
            listener.init();
            this.validateClusterServer(listener, clusterServer);
            log.info("");
            listener.bind();
            listener.start();
            log.info("");
            if (clusterServer.getPort() == 0) {
                clusterServer.setPort(listener.getLocalPort());
            }
        }
    }

    private void validateClusterServer(TcpPort listener, ClusterServer server) {
        if (listener == null || server == null) {
            return;
        }
        if (listener.getSocketTimeout() <= server.getLoadBalanceIdleTime()) {
            throw new ConfigException(L.l("{0}: load-balance-idle-time {1} must be less than socket-timeout {2}", (Object)server, (Object)server.getLoadBalanceIdleTime(), (Object)listener.getSocketTimeout()));
        }
        if (listener.getKeepaliveTimeout() <= server.getLoadBalanceIdleTime()) {
            throw new ConfigException(L.l("{0}: load-balance-idle-time {1} must be less than keepalive-timeout {2}", (Object)server, (Object)server.getLoadBalanceIdleTime(), (Object)listener.getKeepaliveTimeout()));
        }
    }

    public static ArrayList<InetAddress> getLocalAddresses() {
        return HostUtil.getLocalAddresses();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._clusterListener + "]";
    }

    private class ServerListener
    extends AbstractCloudServerListener {
        private ServerListener() {
        }

        public void onServerAdd(CloudServer server) {
            NetworkClusterSystem.this.configureServer(server);
        }
    }

    private class PodListener
    extends AbstractCloudPodListener {
        private PodListener() {
        }

        public void onPodAdd(CloudPod pod) {
            pod.addServerListener(new ServerListener());
        }
    }

    private class NetworkClusterListener
    extends AbstractCloudClusterListener {
        private NetworkClusterListener() {
        }

        public void onClusterAdd(CloudCluster cluster) {
            cluster.addPodListener(new PodListener());
        }
    }
}

