/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.bam;

import com.caucho.bam.broker.ManagedBroker;
import com.caucho.bam.manager.BamManager;
import com.caucho.bam.manager.SimpleBamManager;
import com.caucho.cloud.bam.BamServiceAdmin;
import com.caucho.config.ConfigException;
import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.hemp.broker.DomainManager;
import com.caucho.hemp.broker.HempBroker;
import com.caucho.hemp.broker.HempBrokerManager;
import com.caucho.hemp.servlet.ServerAuthManager;
import com.caucho.util.L10N;
import java.util.concurrent.atomic.AtomicLong;

public class BamSystem
extends AbstractResinSubSystem {
    private static final L10N L = new L10N(BamSystem.class);
    public static final int START_PRIORITY = 30;
    private String _address;
    private final ResinSystem _resinSystem;
    private final HempBrokerManager _hempBrokerManager;
    private final HempBroker _broker;
    private final BamManager _brokerManager;
    private final AtomicLong _externalMessageReadCount = new AtomicLong();
    private final AtomicLong _externalMessageWriteCount = new AtomicLong();
    private ServerAuthManager _linkManager;

    public BamSystem(String address) {
        this._resinSystem = ResinSystem.getCurrent();
        if (this._resinSystem == null) {
            throw new ConfigException(L.l("{0} requires an active {1}", (Object)this.getClass().getSimpleName(), (Object)ResinSystem.class.getSimpleName()));
        }
        this._address = address;
        this._hempBrokerManager = new HempBrokerManager(this._resinSystem);
        this._broker = new HempBroker(this._hempBrokerManager, this.getAddress());
        this._brokerManager = new SimpleBamManager(this._broker);
        if (this.getAddress() != null) {
            this._hempBrokerManager.addBroker(this.getAddress(), this._broker);
        }
        this._hempBrokerManager.addBroker("resin.caucho", this._broker);
    }

    public static BamSystem createAndAddService(String address) {
        ResinSystem system = BamSystem.preCreate(BamSystem.class);
        BamSystem service = new BamSystem(address);
        system.addService(service);
        return service;
    }

    public static BamSystem getCurrent() {
        return ResinSystem.getCurrentService(BamSystem.class);
    }

    public static ManagedBroker getCurrentBroker() {
        return BamSystem.getCurrent().getBroker();
    }

    public static BamManager getCurrentManager() {
        return BamSystem.getCurrent().getBamManager();
    }

    public String getAddress() {
        return this._address;
    }

    public ManagedBroker getBroker() {
        return this._broker;
    }

    public BamManager getBamManager() {
        return this._brokerManager;
    }

    public void setDomainManager(DomainManager manager) {
        this._broker.setDomainManager(manager);
    }

    public void setLinkManager(ServerAuthManager linkManager) {
        this._linkManager = linkManager;
    }

    public ServerAuthManager getLinkManager() {
        return this._linkManager;
    }

    public int getStartPriority() {
        return 30;
    }

    public void start() {
        new BamServiceAdmin(this).register();
    }

    public void stop() {
        this._broker.close();
    }

    public void addExternalMessageRead() {
        this._externalMessageReadCount.incrementAndGet();
    }

    public long getExternalMessageReadCount() {
        return this._externalMessageReadCount.get();
    }

    public void addExternalMessageWrite() {
        this._externalMessageWriteCount.incrementAndGet();
    }

    public long getExternalMessageWriteCount() {
        return this._externalMessageWriteCount.get();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._address + "]";
    }
}

