/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bootjni;

import com.caucho.boot.Boot;
import com.caucho.bootjni.JniProcess;
import com.caucho.inject.Module;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class JniBoot
implements Boot {
    private JniProcess _jniProcess = new JniProcess();

    @Override
    public boolean isValid() {
        return this._jniProcess != null && this._jniProcess.isEnabled();
    }

    @Override
    public String getValidationMessage() {
        return this._jniProcess != null ? this._jniProcess.getTroubleshootMessage() : null;
    }

    @Override
    public void clearSaveOnExec() {
        if (this._jniProcess != null) {
            this._jniProcess.clearSaveOnExec();
        }
    }

    @Override
    public Process exec(ArrayList<String> argv, HashMap<String, String> env, String chroot, String pwd, String user, String group) {
        if (this._jniProcess != null) {
            return this._jniProcess.create(argv, env, chroot, pwd, user, group);
        }
        return null;
    }
}

