/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.bam.RemoteConnectionFailedException;
import com.caucho.bam.RemoteListenerUnavailableException;
import com.caucho.bam.actor.ActorSender;
import com.caucho.bam.actor.BamActorRef;
import com.caucho.bam.manager.SimpleBamManager;
import com.caucho.boot.Boot;
import com.caucho.boot.BootResinConfig;
import com.caucho.boot.GuiCommand;
import com.caucho.boot.ResinGUI;
import com.caucho.boot.ResultStatus;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogChild;
import com.caucho.boot.WatchdogConfig;
import com.caucho.boot.WatchdogProxy;
import com.caucho.config.ConfigException;
import com.caucho.env.service.ResinSystem;
import com.caucho.hmtp.HmtpClient;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WatchdogClient {
    private static final L10N L = new L10N(WatchdogClient.class);
    private static final Logger log = Logger.getLogger(WatchdogClient.class.getName());
    private static final long BAM_TIMEOUT = 180000L;
    public static final String WATCHDOG_ADDRESS = "watchdog@admin.resin.caucho";
    private final BootResinConfig _bootManager;
    private final String _id;
    private ResinSystem _system;
    private WatchdogConfig _config;
    private WatchdogChild _watchdog;
    private ActorSender _conn;
    private Boot _jniBoot;
    private ResinGUI _ui;

    WatchdogClient(ResinSystem system, BootResinConfig bootManager, WatchdogConfig config) {
        this._system = system;
        this._bootManager = bootManager;
        this._config = config;
        this._id = config.getId();
    }

    public WatchdogConfig getConfig() {
        return this._config;
    }

    public String getId() {
        return this._id;
    }

    public String getClusterId() {
        return this._config.getCluster().getId();
    }

    public int getIndex() {
        return this._config.getIndex();
    }

    public String getAddress() {
        return this._config.getAddress();
    }

    public int getPort() {
        return this._config.getPort();
    }

    public String getWatchdogAddress() {
        return this._config.getWatchdogAddress();
    }

    public int getWatchdogPort() {
        return this._config.getWatchdogPort();
    }

    String[] getArgv() {
        return this._config.getArgv();
    }

    Path getPwd() {
        return this._config.getPwd();
    }

    Path getResinHome() {
        return this._bootManager.getResinHome();
    }

    Path getRootDirectory() {
        return this._bootManager.getRootDirectory();
    }

    boolean hasXmx() {
        return this._config.hasXmx();
    }

    boolean hasXss() {
        return this._config.hasXss();
    }

    boolean is64bit() {
        return this._config.is64bit();
    }

    boolean isVerbose() {
        return this._config.isVerbose();
    }

    public String getGroupName() {
        return this._config.getGroupName();
    }

    public String getUserName() {
        return this._config.getUserName();
    }

    public Path getLogDirectory() {
        return this._config.getLogDirectory();
    }

    public Path getResinDataDirectory() {
        return this._bootManager.getResinDataDirectory();
    }

    public String getClusterSystemKey() {
        return this._bootManager.getClusterSystemKey();
    }

    public long getShutdownWaitTime() {
        return this._config.getShutdownWaitTime();
    }

    public int startConsole() throws IOException {
        if (this._watchdog == null) {
            this._watchdog = new WatchdogChild(this._system, this._config);
        }
        return this._watchdog.startConsole();
    }

    public void stopConsole() {
        this._watchdog.stop();
    }

    public int startGui(GuiCommand command) throws IOException {
        if (this._ui != null && this._ui.isVisible()) {
            return 1;
        }
        if (this._ui != null) {
            return 0;
        }
        this._ui = new ResinGUI(command, this);
        this._ui.setVisible(true);
        return 1;
    }

    public String statusWatchdog() throws IOException {
        ActorSender conn = this.getConnection();
        try {
            WatchdogProxy watchdogProxy = this.getWatchdogProxy(conn);
            ResultStatus status = watchdogProxy.status();
            if (status.isSuccess()) {
                return status.getMessage();
            }
            throw new RuntimeException(L.l("{0}: watchdog status failed because of '{1}'", (Object)this, (Object)status.getMessage()));
        }
        catch (Exception e) {
            Throwable e1 = e;
            while (e1.getCause() != null) {
                e1 = e1.getCause();
            }
            log.log(Level.FINE, e.toString(), e);
            return e1.toString();
        }
    }

    public Process startAllWatchdog(String[] argv, boolean isLaunch) throws ConfigException, IOException {
        return this.startWatchdog(argv, isLaunch, true);
    }

    public Process startWatchdog(String[] argv, boolean isLaunch) throws ConfigException, IOException {
        return this.startWatchdog(argv, isLaunch, false);
    }

    private Process startWatchdog(String[] argv, boolean isLaunch, boolean isAll) throws ConfigException, IOException {
        long timeout;
        if (this.getUserName() != null && !this.hasBoot()) {
            String message = this.getTroubleshootMessage();
            if (message == null) {
                message = "Check the $RESIN_HOME/libexec or $RESIN_HOME/libexec64 directory for libresin_os.so.";
            }
            throw new ConfigException(L.l("<user-name> requires compiled JNI.\n{0}", (Object)message));
        }
        if (this.getGroupName() != null && !this.hasBoot()) {
            String message = this.getTroubleshootMessage();
            if (message == null) {
                message = "Check the $RESIN_HOME/libexec or $RESIN_HOME/libexec64 directory for libresin_os.so.";
            }
            throw new ConfigException(L.l("<group-name> requires compiled JNI.\n{0}", (Object)message));
        }
        long l = timeout = isLaunch ? -1L : 10000L;
        if (this.startCommand(argv, timeout)) {
            return null;
        }
        long expireTime = CurrentTime.getCurrentTimeActual() + timeout;
        if (!isLaunch) {
            throw new ConfigException(L.l("Can't contact watchdog at {0}:{1}.", (Object)this.getWatchdogAddress(), this.getWatchdogPort()));
        }
        Process process = this.launchManager(argv);
        timeout = 15000L;
        expireTime = CurrentTime.getCurrentTimeActual() + timeout;
        while (CurrentTime.getCurrentTimeActual() <= expireTime) {
            if (this.pingWatchdog()) {
                return process;
            }
            try {
                Thread.sleep(250L);
            }
            catch (Exception e) {}
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean startCommand(String[] argv, long timeout) {
        expireTime = CurrentTime.getCurrentTimeActual() + timeout;
        do {
            block16: {
                conn = null;
                try {
                    conn = this.getConnection();
                    watchdogProxy = this.getWatchdogProxy(conn);
                    serverId = this.getId();
                    status = watchdogProxy.start(serverId, argv);
                    if (status.isSuccess()) {
                        var10_12 = true;
                        if (conn == null) return var10_12;
                    }
                    ** GOTO lbl-1000
                }
                catch (RemoteConnectionFailedException e) {
                    WatchdogClient.log.log(Level.FINE, e.toString(), e);
                    if (conn != null) {
                        conn.close();
                    }
                    break block16;
                }
                catch (RemoteListenerUnavailableException e) {
                    WatchdogClient.log.log(Level.FINE, e.toString(), e);
                    break block16;
                    catch (RuntimeException e) {
                        WatchdogClient.log.log(Level.FINE, e.toString(), e);
                        throw e;
                    }
                    finally {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                }
                conn.close();
                return var10_12;
lbl-1000:
                // 1 sources

                {
                    throw new ConfigException(WatchdogClient.L.l("{0}: watchdog start failed because of '{1}'", (Object)this, (Object)status.getMessage()));
                }
            }
            try {
                Thread.sleep(250L);
            }
            catch (Exception e) {
                // empty catch block
            }
        } while (CurrentTime.getCurrentTimeActual() <= expireTime);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pingWatchdog() {
        ActorSender conn = null;
        try {
            conn = this.getConnection();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    public void stopWatchdog(String serverId, String[] argv) {
        ActorSender conn = this.getConnection();
        try {
            WatchdogProxy watchdogProxy = this.getWatchdogProxy(conn);
            ResultStatus status = watchdogProxy.stop(serverId, argv);
            if (!status.isSuccess()) {
                throw new RuntimeException(L.l("{0}: watchdog '{1}' stop failed because of '{2}'", (Object)this, (Object)serverId, (Object)status.getMessage()));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killWatchdog(String serverId) throws IOException {
        ActorSender conn = this.getConnection();
        try {
            WatchdogProxy watchdogProxy = this.getWatchdogProxy(conn);
            ResultStatus status = watchdogProxy.kill(serverId);
            if (!status.isSuccess()) {
                throw new RuntimeException(L.l("{0}: watchdog kill failed because of '{1}'", (Object)this, (Object)status.getMessage()));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartWatchdog(String[] argv) throws IOException {
        ActorSender conn = this.getConnection();
        try {
            WatchdogProxy watchdogProxy = this.getWatchdogProxy(conn);
            String id = this.getId();
            ResultStatus status = watchdogProxy.restart(id, argv);
            if (!status.isSuccess()) {
                throw new RuntimeException(L.l("{0}: watchdog restart failed because of '{1}'", (Object)this, (Object)status.getMessage()));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() throws IOException {
        ActorSender conn = this.getConnection();
        try {
            WatchdogProxy watchdogProxy = this.getWatchdogProxy(conn);
            ResultStatus status = watchdogProxy.shutdown();
            if (!status.isSuccess()) {
                throw new RuntimeException(L.l("{0}: watchdog shutdown failed because of '{1}'", (Object)this, (Object)status.getMessage()));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            conn.close();
        }
        return true;
    }

    private WatchdogProxy getWatchdogProxy(ActorSender conn) {
        String to = WATCHDOG_ADDRESS;
        SimpleBamManager bamManager = new SimpleBamManager(conn.getBroker());
        BamActorRef toRef = bamManager.createActorRef(to);
        WatchdogProxy proxy = bamManager.createProxy(WatchdogProxy.class, toRef, conn);
        String cliResinHome = this._bootManager.getResinHome().getFullPath();
        String watchdogResinHome = proxy.getResinHome();
        if (watchdogResinHome == null || !watchdogResinHome.equals(cliResinHome)) {
            throw new ConfigException(L.l("Unexpected resin.home mismatch:\n  CLI resin.home: {0}\n  watchdog resin.home: {1}", (Object)cliResinHome, (Object)watchdogResinHome));
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActorSender getConnection() {
        WatchdogClient watchdogClient = this;
        synchronized (watchdogClient) {
            if (this._conn == null) {
                String url = "http://" + this.getWatchdogAddress() + ":" + this.getWatchdogPort() + "/hmtp";
                HmtpClient client = new HmtpClient(url);
                try {
                    client.setVirtualHost("admin.resin");
                    String uid = "";
                    client.setEncryptPassword(true);
                    client.connect(uid, this.getClusterSystemKey());
                    this._conn = client;
                    client = null;
                }
                finally {
                    if (client != null) {
                        client.close();
                    }
                }
            }
        }
        return this._conn;
    }

    private Process launchManager(String[] argv) throws IOException {
        String libexecPath;
        System.out.println(L.l("Resin/{0} launching watchdog at {1}:{2}", (Object)VersionFactory.getVersion(), (Object)this.getWatchdogAddress(), (Object)this.getWatchdogPort()));
        log.fine(this + " starting ResinWatchdogManager");
        Path resinHome = this.getResinHome();
        Path resinRoot = this.getRootDirectory();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(new File(resinRoot.getNativePath()));
        Map<String, String> env = builder.environment();
        env.putAll(System.getenv());
        String classPath = WatchdogArgs.calculateClassPath(resinHome);
        env.put("CLASSPATH", classPath);
        if (this.is64bit()) {
            libexecPath = resinHome.lookup("libexec64").getNativePath();
            WatchdogClient.appendEnvPath(env, "LD_LIBRARY_PATH", libexecPath);
            WatchdogClient.appendEnvPath(env, "LD_LIBRARY_PATH_64", libexecPath);
            WatchdogClient.appendEnvPath(env, "DYLD_LIBRARY_PATH", libexecPath);
            if (CauchoSystem.isWindows()) {
                WatchdogClient.appendEnvPath(env, "Path", resinHome.lookup("win64").getNativePath());
            }
        } else {
            libexecPath = resinHome.lookup("libexec").getNativePath();
            WatchdogClient.appendEnvPath(env, "LD_LIBRARY_PATH", libexecPath);
            WatchdogClient.appendEnvPath(env, "DYLD_LIBRARY_PATH", libexecPath);
            if (CauchoSystem.isWindows()) {
                WatchdogClient.appendEnvPath(env, "Path", resinHome.lookup("win32").getNativePath());
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(this._config.getJavaExe());
        list.addAll(this._config.getWatchdogJvmArgs());
        list.add("-Dresin.watchdog=" + this._id);
        list.add("-Djava.util.logging.manager=com.caucho.log.LogManagerImpl");
        list.add("-Djavax.management.builder.initial=com.caucho.jmx.MBeanServerBuilderImpl");
        list.add("-Djava.awt.headless=true");
        list.add("-Djava.awt.headlesslib=true");
        list.add("-Dresin.home=" + resinHome.getFullPath());
        list.add("-Dresin.root=" + resinRoot.getFullPath());
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].startsWith("-Djava.class.path=") || !argv[i].startsWith("-J") || argv[i].startsWith("-J-X")) continue;
            list.add(argv[i].substring(2));
        }
        list.add("-Xrs");
        if (!this._config.hasWatchdogXss()) {
            list.add("-Xss256k");
        }
        if (!this._config.hasWatchdogXmx()) {
            list.add("-Xmx32m");
        }
        if (!list.contains("-d32") && !list.contains("-d64") && this.is64bit() && !CauchoSystem.isWindows()) {
            list.add("-d64");
        }
        if (!(list.contains("-server") || list.contains("-client") || CauchoSystem.isWindows())) {
            list.add("-server");
        }
        WatchdogArgs args = this._bootManager.getArgs();
        list.add("com.caucho.boot.WatchdogManager");
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-conf") || argv[i].equals("--conf")) {
                list.add(argv[i]);
                list.add(resinHome.lookup(argv[i + 1]).getNativePath());
                ++i;
                continue;
            }
            if ("".equals(argv[i]) && CauchoSystem.isWindows()) {
                list.add("\"\"");
                continue;
            }
            list.add(argv[i]);
        }
        list.add("--log-directory");
        list.add(this.getLogDirectory().getFullPath());
        builder = builder.command(list);
        Process process = null;
        try {
            process = builder.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InputStream stdIs = process.getInputStream();
        InputStream stdErr = process.getErrorStream();
        OutputStream stdOs = process.getOutputStream();
        ProcessThreadReader reader = new ProcessThreadReader(stdIs);
        reader.setDaemon(true);
        reader.start();
        ProcessThreadReader errorReader = new ProcessThreadReader(stdErr);
        errorReader.setDaemon(true);
        errorReader.start();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        stdOs.close();
        return process;
    }

    public static void appendEnvPath(Map<String, String> env, String prop, String value) {
        String winProp;
        String oldValue = env.get(prop);
        if (oldValue == null && CauchoSystem.isWindows() && (oldValue = env.get(winProp = prop.toUpperCase(Locale.ENGLISH))) != null) {
            prop = winProp;
        }
        if (oldValue != null && !"".equals(oldValue)) {
            value = value + File.pathSeparator + oldValue;
        }
        env.put(prop, value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }

    Boot getJniBoot() {
        if (this._jniBoot != null) {
            return this._jniBoot.isValid() ? this._jniBoot : null;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName("com.caucho.bootjni.JniBoot", false, loader);
            this._jniBoot = (Boot)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.fine(e.toString());
        }
        catch (IllegalStateException e) {
            log.fine(e.toString());
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return this._jniBoot != null && this._jniBoot.isValid() ? this._jniBoot : null;
    }

    private boolean hasBoot() {
        try {
            Boot boot = this.getJniBoot();
            return boot != null && boot.isValid();
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    private String getTroubleshootMessage() {
        Boot boot = this.getJniBoot();
        if (this._jniBoot != null) {
            boot = this._jniBoot;
        }
        return boot != null ? boot.getValidationMessage() : null;
    }

    static class ProcessThreadReader
    extends Thread {
        private InputStream _is;

        ProcessThreadReader(InputStream is) {
            this._is = is;
        }

        public void run() {
            try {
                int ch;
                while ((ch = this._is.read()) >= 0) {
                    System.out.print((char)ch);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

