/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractManagementCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.server.admin.ListUsersQueryReply;
import com.caucho.server.admin.ManagerClient;
import com.caucho.server.admin.UserQueryReply;
import com.caucho.util.L10N;

public class UserListCommand
extends AbstractManagementCommand {
    private static final L10N L = new L10N(UserListCommand.class);

    public String getDescription() {
        return "lists the administration users";
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient) {
        ListUsersQueryReply result = managerClient.listUsers();
        if (result.getUsers().length == 0) {
            System.out.println("no users found");
            return 0;
        }
        for (UserQueryReply.User user : result.getUsers()) {
            System.out.print(user.getName());
            String[] roles = user.getRoles();
            if (roles == null || roles.length == 0) {
                System.out.println();
                continue;
            }
            System.out.print(": ");
            for (int i = 0; i < roles.length; ++i) {
                System.out.print(roles[i]);
                if (i + 1 >= roles.length) continue;
                System.out.print(", ");
            }
            System.out.println();
        }
        return 0;
    }
}

