/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.boot.AbstractStartCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StartCommand
extends AbstractStartCommand {
    private static Logger _log;
    private static L10N _L;

    public String getDescription() {
        return "starts a Resin server";
    }

    public boolean isStart() {
        return true;
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        try {
            client.startWatchdog(args.getArgv(), true);
            System.out.println(StartCommand.L().l("Resin/{0} started{1} with watchdog at {2}:{3}", (Object)VersionFactory.getVersion(), (Object)this.getServerUsageArg(args, client.getId()), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort()));
        }
        catch (Exception e) {
            String eMsg = e instanceof ConfigException ? e.getMessage() : e.toString();
            System.out.println(StartCommand.L().l("Resin/{0} can't start -server '{1}' for watchdog at {2}:{3}.\n  {4}", (Object)VersionFactory.getVersion(), (Object)client.getId(), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort(), (Object)eMsg));
            StartCommand.log().log(Level.FINE, e.toString(), e);
            System.exit(1);
        }
        return 0;
    }

    public boolean isRetry() {
        return true;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(StartCommand.class.getName());
        }
        return _log;
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(StartCommand.class);
        }
        return _L;
    }
}

