/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractManagementCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.server.admin.ManagerClient;
import com.caucho.server.admin.StringQueryReply;
import com.caucho.util.L10N;

public class ScoreboardCommand
extends AbstractManagementCommand {
    private static final L10N L = new L10N(ScoreboardCommand.class);

    protected void initBootOptions() {
        this.addValueOption("type", "resin", "scoreboard report type");
        this.addValueOption("greedy", "true", "threads can not be in more than one scoreboard");
        super.initBootOptions();
    }

    public String getDescription() {
        return "produces a concise thread activity report for groups of related threads";
    }

    public boolean isProOnly() {
        return true;
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient) {
        String greedy = args.getArg("-greedy");
        String type = args.getArg("-type");
        boolean isGreedy = true;
        if ("no".equals(greedy) || "false".equals(greedy)) {
            isGreedy = false;
        }
        if (type == null) {
            type = "resin";
        }
        StringQueryReply result = managerClient.scoreboard(type, isGreedy);
        System.out.println(result.getValue());
        return 0;
    }
}

