/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.BootClusterConfig;
import com.caucho.boot.BootCommand;
import com.caucho.boot.BootResinConfig;
import com.caucho.boot.ProLoader;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.core.ResinProperties;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.lib.ResinConfigLibrary;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.loader.Environment;
import com.caucho.loader.LibraryLoader;
import com.caucho.server.resin.ResinELContext;
import com.caucho.server.webbeans.ResinServerConfigLibrary;
import com.caucho.util.L10N;
import com.caucho.vfs.NullPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResinBoot {
    private static final Logger log = Logger.getLogger(ResinBoot.class.getName());
    private static L10N _L;
    private WatchdogArgs _args;
    private BootResinConfig _resinConfig;

    ResinBoot(String[] argv) throws Exception {
        this._args = new WatchdogArgs(argv);
        if (this._args.isVerbose()) {
            ResinBoot.setLoggingLevel(Level.FINER);
        }
        Path resinHome = this._args.getResinHome();
        System.setProperty("resin.home", resinHome.getNativePath());
        ProLoader loader = ProLoader.create(resinHome, this._args.is64Bit());
        if (loader != null) {
            Thread.currentThread().setContextClassLoader(loader);
            Environment.init();
            Vfs.initJNI();
            resinHome = Vfs.lookup(resinHome.getFullPath());
            this._args.setResinHome(resinHome);
        } else {
            Environment.init();
        }
        if (!this._args.getResinConf().canRead()) {
            throw new ConfigException(ResinBoot.L().l("Resin/{0} can't open configuration file '{1}'", (Object)VersionFactory.getVersion(), (Object)this._args.getResinConf().getNativePath()));
        }
        Path rootDirectory = this._args.getRootDirectory();
        Path dataDirectory = rootDirectory.lookup("watchdog-data");
        System.setProperty("resin.root", rootDirectory.getNativePath());
        ResinSystem system = this._args.getCommand().isConsole() ? new ResinSystem("watchdog", rootDirectory, dataDirectory) : new ResinSystem("watchdog", rootDirectory, new NullPath("boot-temp"));
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader(system.getClassLoader());
        LibraryLoader libLoader = new LibraryLoader();
        libLoader.setPath(rootDirectory.lookup("lib"));
        libLoader.init();
        Config config = new Config();
        this._resinConfig = new BootResinConfig(system, this._args);
        ResinELContext elContext = this._args.getELContext();
        InjectManager beanManager = InjectManager.create();
        Config.setProperty("resinHome", elContext.getResinHome());
        Config.setProperty("java", elContext.getJavaVar());
        Config.setProperty("resin", elContext.getResinVar());
        Config.setProperty("server", elContext.getServerVar());
        Config.setProperty("system", System.getProperties());
        Config.setProperty("getenv", System.getenv());
        Config.setProperty("server_id", this._args.getServerId());
        Config.setProperty("rvar0", this._args.getServerId());
        ResinConfigLibrary.configure(beanManager);
        ResinServerConfigLibrary.configure(beanManager);
        if (this._args.getUserProperties() != null && this._args.getUserProperties().canRead()) {
            ResinProperties properties = new ResinProperties();
            properties.setPath(this._args.getUserProperties());
            String mode = this._args.getMode();
            if (mode == null && this._args.getCommand().isRemote(this._args)) {
                mode = "remote";
            }
            properties.setMode(this._args.getMode());
            properties.init();
        }
        config.configure((Object)this._resinConfig, this._args.getResinConf(), "com/caucho/server/resin/resin.rnc");
        if (!this._args.isHelp()) {
            this.initClient();
        }
    }

    public String getServerId() {
        String serverId = this._args.getServerId();
        if (serverId == null) {
            serverId = this._resinConfig.getHomeServer();
        }
        return serverId;
    }

    private WatchdogArgs getArgs() {
        return this._args;
    }

    private void initClient() {
        if (!this._resinConfig.isElasticServer(this._args)) {
            return;
        }
        WatchdogClient client = this._resinConfig.addElasticClient(this._args);
        if (client != null) {
            this._args.setElasticServerId(client.getId());
        }
    }

    boolean isElasticServer(WatchdogArgs args) {
        return this._resinConfig.isElasticServer(args);
    }

    ArrayList<BootResinConfig.ElasticServer> getElasticServerList() {
        return this._resinConfig.getElasticServerList();
    }

    public boolean isElasticIp(WatchdogArgs args) {
        return this._resinConfig.isElasticDns(args);
    }

    String getHomeCluster(WatchdogArgs args) {
        String clusterId = args.getClusterId();
        if (clusterId != null) {
            return clusterId;
        }
        return this._resinConfig.getHomeCluster();
    }

    BootClusterConfig findCluster(String clusterId) {
        return this._resinConfig.findCluster(clusterId);
    }

    WatchdogClient findClient(String serverId, WatchdogArgs args) {
        return this._resinConfig.findClient(serverId, args);
    }

    WatchdogClient findWatchdogClient(WatchdogArgs args) {
        return this._resinConfig.findWatchdogClient(args.getClusterId());
    }

    ArrayList<WatchdogClient> findLocalClients() {
        return this._resinConfig.findLocalClients(this.getServerId());
    }

    ArrayList<String> findLocalClientIds() {
        return this._resinConfig.findLocalClientIds(this.getServerId());
    }

    BootCommand getCommand() {
        return this._args.getCommand();
    }

    boolean start() throws Exception {
        BootCommand command = this.getCommand();
        if (command != null && this._args.isHelp()) {
            command.usage(this._args.isVerbose());
            return false;
        }
        if (command != null && command.isRetry()) {
            int code = command.doCommand(this, this._args);
            return code != 0;
        }
        if (command != null) {
            if (!command.isProOnly() || command.isProOnly() && this.isPro()) {
                int code = command.doCommand(this, this._args);
                System.exit(code);
            } else {
                System.err.println(ResinBoot.L().l("command '{0}' is only available with Resin Pro", (Object)command.getName()));
                System.exit(ExitCode.UNKNOWN.ordinal());
            }
        }
        throw new IllegalStateException(ResinBoot.L().l("Unknown start mode"));
    }

    private boolean isPro() {
        return this._args.isResinProfessional();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        String jvmVersion = System.getProperty("java.runtime.version");
        if ("1.6".compareTo(jvmVersion) > 0) {
            throw new ConfigException(ResinBoot.L().l("Resin requires Java 1.6 or later but was started with {0}", (Object)jvmVersion));
        }
        ResinBoot boot = null;
        BootCommand command = null;
        try {
            boot = new ResinBoot(argv);
            if (System.getProperty("log.level") == null && !boot.getArgs().isVerbose()) {
                for (Handler handler : Logger.getLogger("").getHandlers()) {
                    if (!(handler instanceof ConsoleHandler)) continue;
                    handler.setLevel(Level.FINER);
                    Logger.getLogger("").removeHandler(handler);
                }
            }
            command = boot.getCommand();
            while (boot.start()) {
                try {
                    BootCommand bootCommand = command;
                    synchronized (bootCommand) {
                        command.wait(5000L);
                    }
                }
                catch (Exception exception) {
                }
            }
            System.exit(ExitCode.OK.ordinal());
        }
        catch (BootArgumentException bootArgumentException) {
            ResinBoot.printException(bootArgumentException, boot);
            if (command != null) {
                command.usage(false);
            }
            System.exit(ExitCode.UNKNOWN_ARGUMENT.ordinal());
        }
        catch (ConfigException configException) {
            ResinBoot.printException(configException, boot);
            System.exit(ExitCode.BAD_CONFIG.ordinal());
        }
        catch (Exception exception) {
            ResinBoot.printException(exception, boot);
            System.exit(ExitCode.UNKNOWN.ordinal());
        }
    }

    private static void setLoggingLevel(Level level) {
        Logger.getLogger("").setLevel(level);
        for (Handler handler : Logger.getLogger("").getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.setLevel(level);
        }
    }

    private static void printException(Throwable e, ResinBoot boot) {
        System.err.println(e.getMessage());
        if (e.getMessage() == null || boot != null && boot.getArgs().isVerbose() || log.isLoggable(Level.FINER)) {
            e.printStackTrace();
        }
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(ResinBoot.class);
        }
        return _L;
    }
}

