/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.JmxCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.server.admin.JmxSetQueryReply;
import com.caucho.server.admin.ManagerClient;
import com.caucho.util.L10N;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JmxSetCommand
extends JmxCommand {
    private static final L10N L = new L10N(JmxSetCommand.class);

    protected void initBootOptions() {
        this.addValueOption("pattern", "pattern", "pattern to match MBean, adheres to the rules defined for javax.managment.ObjectName e.g. qa:type=Foo");
        this.addValueOption("attribute", "attribute", "name of the attribute");
        super.initBootOptions();
    }

    public String getDescription() {
        return "sets a JMX value for a server MBean";
    }

    public String getUsageArgs() {
        return " <value>";
    }

    public boolean isDefaultArgsAccepted() {
        return true;
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient) {
        String pattern = args.getArg("-pattern");
        if (pattern == null) {
            throw new ConfigException(L.l("-pattern is required for jmx-set command"));
        }
        try {
            ObjectName.getInstance(pattern);
        }
        catch (MalformedObjectNameException e) {
            throw new ConfigException(L.l("invalid pattern `{0}': `{1}'", (Object)pattern, (Object)e.getMessage()));
        }
        String attribute = args.getArg("-attribute");
        if (attribute == null) {
            throw new ConfigException(L.l("-attribute is required for jmx-set command"));
        }
        String value = args.getDefaultArg();
        if (value == null) {
            throw new ConfigException(L.l("jmx-set requires <value> parameter be specified"));
        }
        JmxSetQueryReply reply = managerClient.setJmx(pattern, attribute, value);
        String message = L.l("value for attribute `{0}' on bean `{1}' is changed from `{2}' to `{3}'", (Object)reply.getAttribute(), (Object)reply.getBean(), (Object)reply.getOldValue(), (Object)reply.getNewValue());
        System.out.println(message);
        return 0;
    }
}

