/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractScalingCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.cloud.scaling.ResinScalingClient;
import com.caucho.cloud.topology.CloudServerState;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;

public class DisableSoftCommand
extends AbstractScalingCommand {
    private static final L10N L = new L10N(DisableSoftCommand.class);

    public String getDescription() {
        return "allows existing sessions to finish and disables the server";
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        if (!this.isPro()) {
            System.out.println("command 'disable-soft' is only available with Resin Pro");
            return 3;
        }
        ResinScalingClient scalingClient = this.getScalingClient(args, client);
        String server = args.getDefaultArg();
        if (server == null) {
            server = args.getServerId();
        }
        if (server == null) {
            throw new ConfigException("server is not specified");
        }
        CloudServerState state = scalingClient.disableSoft(server);
        scalingClient.close();
        String message = state == null ? L.l("server '{0}' is not found", (Object)server) : L.l("server '{0}' state: {1}", (Object)server, (Object)state);
        System.out.println(message);
        return 0;
    }

    public String getUsageArgs() {
        return " [<server>]";
    }

    public boolean isDefaultArgsAccepted() {
        return true;
    }
}

