/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.boot.BootClusterConfig;
import com.caucho.boot.BootClusterProxy;
import com.caucho.boot.BootManagementConfig;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.boot.WatchdogConfig;
import com.caucho.boot.WatchdogConfigHandle;
import com.caucho.boot.WatchdogManagerConfig;
import com.caucho.cloud.security.SecurityService;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.env.service.ResinSystem;
import com.caucho.loader.SystemProperty;
import com.caucho.security.AdminAuthenticator;
import com.caucho.util.HostUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootResinConfig {
    private static final L10N L = new L10N(BootResinConfig.class);
    private static final Logger log = Logger.getLogger(BootResinConfig.class.getName());
    private boolean _isWatchdogManagerConfig;
    private ArrayList<ContainerProgram> _clusterDefaultList = new ArrayList();
    private ArrayList<BootClusterConfig> _clusterList = new ArrayList();
    private HashMap<String, WatchdogClient> _watchdogMap = new HashMap();
    private HashMap<String, WatchdogConfig> _serverMap = new HashMap();
    private ClassLoader _classLoader;
    private ResinSystem _system;
    private WatchdogArgs _args;
    private Path _resinHome;
    private Path _rootDirectory;
    private Path _resinDataDirectory;
    private BootManagementConfig _management;
    private String _clusterSystemKey;
    private String _homeCluster;
    private String _homeServer;
    private boolean _isElasticServer;
    private int _elasticServerPort;
    private boolean _isElasticDns;
    private ArrayList<ElasticServer> _elasticServerList;

    BootResinConfig(ResinSystem system, WatchdogArgs args) {
        this._system = system;
        this._args = args;
        this._classLoader = this._system.getClassLoader();
    }

    WatchdogArgs getArgs() {
        return this._args;
    }

    public Path getResinHome() {
        if (this._resinHome != null) {
            return this._resinHome;
        }
        return this._args.getResinHome();
    }

    public void setRootDirectory(Path rootDirectory) {
        this._rootDirectory = rootDirectory;
    }

    public Path getRootDirectory() {
        if (this._rootDirectory != null) {
            return this._rootDirectory;
        }
        return this._args.getRootDirectory();
    }

    public Path getLogDirectory() {
        Path logDirectory = this._args.getLogDirectory();
        if (logDirectory != null) {
            return logDirectory;
        }
        return this.getRootDirectory().lookup("log");
    }

    public void setResinDataDirectory(Path path) {
        this._resinDataDirectory = path;
    }

    public Path getResinDataDirectory() {
        if (this._resinDataDirectory != null) {
            return this._resinDataDirectory;
        }
        return this.getRootDirectory().lookup("resin-data");
    }

    public void setClusterSystemKey(String digest) {
        if (digest == null || "".equals(digest)) {
            return;
        }
        this._clusterSystemKey = digest;
        SecurityService security = SecurityService.getCurrent();
        if (security != null) {
            security.setSignatureSecret(digest);
        }
    }

    public void setResinSystemAuthKey(String key) {
        this.setClusterSystemKey(key);
    }

    public String getClusterSystemKey() {
        return this._clusterSystemKey;
    }

    @Configurable
    public void setJoinCluster(String joinCluster) {
        this.setHomeCluster(joinCluster);
    }

    @Configurable
    public void setHomeCluster(String homeCluster) {
        this._homeCluster = homeCluster;
    }

    public String getHomeCluster() {
        return this._homeCluster;
    }

    public boolean isHomeCluster() {
        return this._homeCluster != null && !"".equals(this._homeCluster);
    }

    public boolean isElasticServer() {
        return this._isElasticServer;
    }

    @Configurable
    public void setElasticServer(String servers) {
        if (servers == null || "".equals(servers) || "no".equalsIgnoreCase(servers) || "false".equalsIgnoreCase(servers)) {
            this._isElasticServer = false;
            return;
        }
        this._elasticServerList = new ArrayList();
        if ("yes".equalsIgnoreCase(servers) || "true".equalsIgnoreCase(servers)) {
            this._isElasticServer = true;
            this._elasticServerList.add(new ElasticServer(null, 1));
            return;
        }
        this.parseElasticServers(servers);
        this._isElasticServer = true;
    }

    private void parseElasticServers(String servers) {
        String[] serverList;
        for (String server : serverList = servers.split("[\\s,]+")) {
            int count;
            String cluster;
            int p = server.indexOf(58);
            if (p >= 0) {
                cluster = server.substring(0, p);
                count = Integer.parseInt(server.substring(p + 1));
            } else if (Character.isDigit(server.charAt(0))) {
                cluster = null;
                count = Integer.parseInt(server);
            } else {
                cluster = server;
                count = 1;
            }
            this._elasticServerList.add(new ElasticServer(cluster, count));
        }
    }

    public ArrayList<ElasticServer> getElasticServers() {
        return this._elasticServerList;
    }

    @Configurable
    public void setElasticDns(boolean isElasticDns) {
        this._isElasticDns = isElasticDns;
    }

    public boolean isElasticDns() {
        return this._isElasticDns;
    }

    @Configurable
    public void setElasticServerPort(int port) {
        this._elasticServerPort = port;
    }

    public int getElasticServerPort() {
        return this._elasticServerPort;
    }

    public int getElasticServerPort(WatchdogArgs arg, int count) {
        int port = arg.getDynamicPort();
        if (port <= 0) {
            port = this._elasticServerPort;
        }
        if (port <= 0) {
            port = 6830 + count;
        }
        return port;
    }

    @Configurable
    public void setHomeServer(String homeServer) {
        if (homeServer != null && !homeServer.isEmpty()) {
            this._homeServer = homeServer;
        }
    }

    public String getHomeServer() {
        return this._homeServer;
    }

    public void add(AdminAuthenticator auth) {
        this.createManagement().setAdminAuthenticator(auth);
    }

    public BootManagementConfig createManagement() {
        if (this._management == null) {
            this._management = new BootManagementConfig();
        }
        return this._management;
    }

    public void setManagement(BootManagementConfig management) {
        this._management = management;
    }

    public BootManagementConfig getManagement() {
        return this._management;
    }

    public boolean isWatchdogManagerConfig() {
        return this._isWatchdogManagerConfig;
    }

    public WatchdogClient findClient(String id) {
        return this._watchdogMap.get(id);
    }

    public WatchdogClient findClientByAddress(String address, int port) {
        if (port <= 0) {
            return null;
        }
        if (address == null) {
            return null;
        }
        for (WatchdogClient client : this._watchdogMap.values()) {
            if (!address.equals(client.getAddress()) || port != client.getPort()) continue;
            return client;
        }
        return null;
    }

    WatchdogClient findClient(String cliServerId, WatchdogArgs args) {
        WatchdogClient client = null;
        String serverId = this.getServerId(args);
        if (serverId != null) {
            client = this.findClient(serverId);
            if (client != null) {
                return client;
            }
            if (this.isElasticServer(args)) {
                return null;
            }
            throw new ConfigException(L.l("Resin/{0}: server '{1}' does not match a unique <server> or <server-multi>\nin {2}\nserver ids: {3}.", (Object)VersionFactory.getVersion(), (Object)this.getDisplayServerName(cliServerId), (Object)this._args.getResinConf(), (Object)this.toStringList(this._watchdogMap.values())));
        }
        if (this.isElasticServer(args)) {
            return null;
        }
        if (serverId == null) {
            client = this.findClient("default");
        }
        return client;
    }

    WatchdogClient findLocalClient(String cliServerId, WatchdogArgs args) {
        ArrayList<WatchdogClient> clientList = this.findLocalClients(cliServerId);
        if (clientList.size() == 0) {
            return null;
        }
        WatchdogClient client = clientList.get(0);
        if (client != null && !client.getConfig().isRequireExplicitId()) {
            return client;
        }
        return null;
    }

    WatchdogClient findUniqueLocalClient(String cliServerId, WatchdogArgs args) {
        ArrayList<WatchdogClient> clientList = this.findLocalClients(cliServerId);
        if (clientList.size() == 0) {
            return null;
        }
        if (clientList.size() > 1) {
            throw new ConfigException(L.l("Resin/{0}: server '{1}' does not match a unique <server> or <server-multi>\nin {2}\nserver ids: {3}.", (Object)VersionFactory.getVersion(), (Object)this.getDisplayServerName(cliServerId), (Object)this._args.getResinConf(), (Object)this.toStringList(clientList)));
        }
        WatchdogClient client = clientList.get(0);
        if (client != null && !client.getConfig().isRequireExplicitId()) {
            return client;
        }
        return null;
    }

    private String toStringList(Collection<WatchdogClient> clientList) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (WatchdogClient client : clientList) {
            list.add(client.getId());
        }
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append((String)list.get(i));
        }
        return sb.toString();
    }

    private String getDisplayServerName(String name) {
        if (name == null || "".equals(name)) {
            return "default";
        }
        return name;
    }

    String getServerId(WatchdogArgs args) {
        String serverId = args.getServerId();
        if (serverId != null) {
            return serverId;
        }
        return this.getHomeServer();
    }

    boolean isDynamicServerAllowed(WatchdogArgs args) {
        return this.isElasticServer(args) || this.getHomeCluster() != null;
    }

    String getClusterId(WatchdogArgs args) {
        if (args.getClusterId() != null) {
            return args.getClusterId();
        }
        return this.getHomeCluster();
    }

    boolean isElasticServer(WatchdogArgs args) {
        if (args.isElasticServer()) {
            return true;
        }
        return this.isElasticServer();
    }

    boolean isElasticDns(WatchdogArgs args) {
        return args.isElasticDns() || this.isElasticDns();
    }

    public ArrayList<WatchdogClient> findLocalClients(String serverId) {
        WatchdogClient client;
        ArrayList<WatchdogClient> clientList = new ArrayList<WatchdogClient>();
        if (serverId != null && (client = this._watchdogMap.get(serverId)) != null) {
            clientList.add(client);
            return clientList;
        }
        this.fillLocalClients(clientList);
        return clientList;
    }

    public ArrayList<String> findLocalClientIds(String serverId) {
        ArrayList<WatchdogClient> clientList = new ArrayList<WatchdogClient>();
        this.fillLocalClients(clientList);
        ArrayList<String> ids = new ArrayList<String>();
        for (WatchdogClient client : clientList) {
            ids.add(client.getId());
        }
        Collections.sort(ids);
        return ids;
    }

    public WatchdogClient findWatchdogClient(String clusterId) {
        WatchdogClient bestClient = null;
        for (WatchdogClient client : this._watchdogMap.values()) {
            if (client == null || clusterId != null && !clusterId.equals(client.getClusterId()) || bestClient != null && client.getIndex() >= bestClient.getIndex()) continue;
            bestClient = client;
        }
        return bestClient;
    }

    public void fillLocalClients(ArrayList<WatchdogClient> clientList) {
        ArrayList<InetAddress> localAddresses = BootResinConfig.getLocalAddresses();
        for (WatchdogClient client : this._watchdogMap.values()) {
            if (client == null || !BootResinConfig.isLocalClient(localAddresses, client.getConfig())) continue;
            clientList.add(client);
        }
        Collections.sort(clientList, new ClientComparator());
    }

    public static boolean isLocalClient(ArrayList<InetAddress> localAddresses, WatchdogConfig config) {
        if (config.isRequireExplicitId()) {
            return false;
        }
        String address = config.getAddress();
        return BootResinConfig.isLocalAddress(localAddresses, address);
    }

    static ArrayList<InetAddress> getLocalAddresses() {
        return HostUtil.getLocalAddresses();
    }

    private static boolean isLocalAddress(ArrayList<InetAddress> localAddresses, String address) {
        if (address == null || "".equals(address)) {
            return false;
        }
        try {
            InetAddress addr = InetAddress.getByName(address);
            if (localAddresses.contains(addr)) {
                return true;
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
        return false;
    }

    public int getNextIndex() {
        return this._watchdogMap.size();
    }

    public void addClient(WatchdogClient client) {
        this._watchdogMap.put(client.getId(), client);
    }

    public WatchdogConfig findServer(String id) {
        return this._serverMap.get(id);
    }

    public void addServer(WatchdogConfig config) {
        this._serverMap.put(config.getId(), config);
    }

    WatchdogClient addElasticClient(WatchdogArgs args) {
        if (!this.isElasticServer(args) && !this.isHomeCluster()) {
            throw new IllegalStateException();
        }
        int count = 0;
        Iterator<ElasticServer> i$ = this.getElasticServerList().iterator();
        while (i$.hasNext()) {
            int i = 0;
            ElasticServer elasticServer = i$.next();
            int serverCount = elasticServer.getCount();
            if (i >= serverCount) continue;
            WatchdogClient client = this.addElasticServer(elasticServer, args, i, count++);
            return client;
        }
        return null;
    }

    ArrayList<ElasticServer> getElasticServerList() {
        ArrayList<ElasticServer> elasticServers = this._elasticServerList;
        if (elasticServers == null) {
            elasticServers = new ArrayList();
            elasticServers.add(new ElasticServer(null, 1));
        }
        return elasticServers;
    }

    private WatchdogClient addElasticServer(ElasticServer elasticServer, WatchdogArgs args, int index, int count) {
        String clusterId = elasticServer.getCluster();
        if (clusterId == null) {
            clusterId = args.getClusterId();
        }
        if (clusterId == null) {
            clusterId = this.getHomeCluster();
        }
        String address = args.getDynamicAddress();
        int port = this.getElasticServerPort(args, count);
        BootClusterConfig cluster = this.findCluster(clusterId);
        if (cluster == null) {
            throw new ConfigException(L.l("'{0}' is an unknown cluster. --cluster must specify an existing cluster", (Object)clusterId));
        }
        if (!cluster.isClusterServerEnable()) {
            throw new ConfigException(L.l("cluster '{0}' does not have <resin:ElasticCloudService>. --elastic-server requires a <resin:ElasticCloudService> tag.", (Object)clusterId));
        }
        clusterId = cluster.getId();
        String serverId = args.getServerId();
        if (serverId == null) {
            serverId = "dyn-" + clusterId + "-" + index;
        }
        WatchdogConfigHandle configHandle = cluster.createServer();
        configHandle.setId(serverId);
        configHandle.setAddress(address);
        configHandle.setPort(port);
        if (this.findClient(configHandle.getId()) != null) {
            throw new ConfigException(L.l("--elastic-server '{0}' already exists as a static server. Elastic server names must not conflict with static server names.", (Object)configHandle.getId()));
        }
        WatchdogConfig config = cluster.addServer(configHandle);
        config.setElastic(true);
        config.setElasticServerPort(port);
        config.setElasticServerCluster(clusterId);
        this.addServer(config);
        WatchdogClient client = new WatchdogClient(this._system, this, config);
        this.addClient(client);
        return client;
    }

    public WatchdogManagerConfig createWatchdogManager() {
        this._isWatchdogManagerConfig = true;
        return new WatchdogManagerConfig(this._system, this);
    }

    public void addClusterDefault(ContainerProgram program) {
        this._clusterDefaultList.add(program);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCluster(BootClusterProxy proxy) {
        BootClusterConfig cluster = this.findCluster(proxy.getId());
        if (cluster == null) {
            cluster = new BootClusterConfig(this._system, this);
            cluster.setId(proxy.getId());
            Object oldCluster = Config.getProperty("cluster");
            try {
                Config.setProperty("cluster", new ConfigVar(cluster));
                for (int i = 0; i < this._clusterDefaultList.size(); ++i) {
                    this._clusterDefaultList.get(i).configure(cluster);
                }
            }
            finally {
                Config.setProperty("cluster", oldCluster);
            }
            this._clusterList.add(cluster);
        }
        proxy.getProgram().configure(cluster);
    }

    BootClusterConfig findCluster(String id) {
        if (id == null) {
            if (this._clusterList.size() == 1) {
                return this._clusterList.get(0);
            }
            return null;
        }
        for (int i = 0; i < this._clusterList.size(); ++i) {
            BootClusterConfig cluster = this._clusterList.get(i);
            if (!id.equals(cluster.getId())) continue;
            return cluster;
        }
        return null;
    }

    public void addSystemProperty(SystemProperty property) {
    }

    public void addContentProgram(ConfigProgram program) {
    }

    static class ElasticServer {
        private final String _cluster;
        private final int _count;

        ElasticServer(String cluster, int count) {
            this._cluster = cluster;
            this._count = count;
        }

        String getCluster() {
            return this._cluster;
        }

        int getCount() {
            return this._count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClientComparator
    implements Comparator<WatchdogClient> {
        ClientComparator() {
        }

        @Override
        public int compare(WatchdogClient a, WatchdogClient b) {
            return a.getId().compareTo(b.getId());
        }
    }

    public static class ConfigVar {
        private BootClusterConfig _cluster;

        public ConfigVar(BootClusterConfig cluster) {
            this._cluster = cluster;
        }

        public String getId() {
            return this._cluster.getId();
        }
    }
}

