/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.bam.BamException;
import com.caucho.bam.ErrorPacketException;
import com.caucho.bam.NotAuthorizedException;
import com.caucho.bam.actor.RemoteActorSender;
import com.caucho.boot.AbstractRemoteCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.server.admin.WebAppDeployClient;
import com.caucho.vfs.Path;

public abstract class AbstractRepositoryCommand
extends AbstractRemoteCommand {
    protected void initBootOptions() {
        this.addValueOption("name", "name", "name of the deployment context");
        super.initBootOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        int n;
        block13: {
            WebAppDeployClient deployClient = null;
            try {
                deployClient = this.getDeployClient(args, client);
                n = this.doCommand(args, client, deployClient);
                Object var8_6 = null;
                if (deployClient == null) break block13;
            }
            catch (Exception e) {
                int n2;
                block16: {
                    block14: {
                        int n3;
                        block15: {
                            try {
                                Throwable cause = e;
                                if (cause instanceof ConfigException || cause instanceof ErrorPacketException) {
                                    System.out.println(cause.getMessage());
                                } else if (cause instanceof BamException) {
                                    BamException bamException = (BamException)cause;
                                    if (bamException.getActorError() != null) {
                                        System.out.println(bamException.getActorError().getText());
                                    } else {
                                        System.out.println(bamException.getMessage());
                                    }
                                } else {
                                    while (cause.getCause() != null) {
                                        cause = cause.getCause();
                                    }
                                    System.out.println(cause.toString());
                                }
                                if (args.isVerbose()) {
                                    e.printStackTrace();
                                }
                                if (!(e instanceof NotAuthorizedException)) break block14;
                                n3 = 1;
                                Object var8_7 = null;
                                if (deployClient == null) break block15;
                            }
                            catch (Throwable throwable) {
                                block17: {
                                    Object var8_9 = null;
                                    if (deployClient == null) break block17;
                                    deployClient.close();
                                }
                                throw throwable;
                            }
                            deployClient.close();
                        }
                        return n3;
                    }
                    n2 = 2;
                    Object var8_8 = null;
                    if (deployClient == null) break block16;
                    deployClient.close();
                }
                return n2;
            }
            deployClient.close();
        }
        return n;
    }

    protected abstract int doCommand(WatchdogArgs var1, WatchdogClient var2, WebAppDeployClient var3);

    protected WebAppDeployClient getDeployClient(WatchdogArgs args, WatchdogClient client) {
        RemoteActorSender sender = this.createBamClient(args, client);
        return new WebAppDeployClient(sender.getUrl(), sender);
    }

    String getName(WatchdogArgs args, Path path) {
        return AbstractRepositoryCommand.getWebAppName(args, path);
    }

    static String getWebAppName(WatchdogArgs args, Path path) {
        String name = args.getArg("-name");
        String webapp = args.getArg("-web-app");
        if (webapp != null) {
            name = webapp;
        }
        if (name == null && path != null) {
            String tail = path.getTail();
            int p = tail.lastIndexOf(46);
            name = p > 0 ? tail.substring(0, p) : tail;
        }
        if (name == null && args.getDefaultArg() != null) {
            name = args.getDefaultArg();
        }
        if (name == null || name.equals("/")) {
            name = "ROOT";
        } else if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }
}

