/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.router;

import com.caucho.bam.BamError;
import com.caucho.bam.actor.ActorSender;
import com.caucho.bam.actor.BamActorRef;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.query.QueryCallback;
import com.caucho.bam.router.AbstractBamRouter;
import java.io.Serializable;

public class BamFirstActorRouter
extends AbstractBamRouter {
    private final Broker _broker;
    private final ActorSender _sender;
    private final BamActorRef[] _actors;
    private final long _actorTimeout;

    public BamFirstActorRouter(ActorSender sender, long timeout, BamActorRef ... actors) {
        this._broker = sender.getBroker();
        this._sender = sender;
        this._actors = actors;
        this._actorTimeout = timeout;
    }

    public String getAddress() {
        return this.getActors()[0].getAddress();
    }

    protected BamActorRef[] getActors() {
        return this._actors;
    }

    public boolean isActive() {
        for (BamActorRef actor : this.getActors()) {
            if (!actor.isActive()) continue;
            return true;
        }
        return false;
    }

    public ActorSender getSender() {
        return this._sender;
    }

    public void message(String from, Serializable payload) {
        for (BamActorRef actor : this._actors) {
            if (!actor.isActive()) continue;
            actor.message(from, payload);
            return;
        }
    }

    public void query(long id, String from, Serializable payload) {
        new FirstMethodCallback(id, from, payload, this._actorTimeout).start();
    }

    class FirstMethodCallback
    implements QueryCallback {
        private final long _id;
        private final String _from;
        private final Serializable _payload;
        private final long _actorTimeout;
        private int _index;

        FirstMethodCallback(long id, String from, Serializable payload, long actorTimeout) {
            this._id = id;
            this._from = from;
            this._payload = payload;
            this._actorTimeout = actorTimeout;
        }

        void start() {
            if (!this.nextQuery()) {
                this.fail();
            }
        }

        private void fail() {
            BamFirstActorRouter.this._broker.queryError(this._id, this._from, BamFirstActorRouter.this._sender.getAddress(), this._payload, new BamError("cancel", "remote-connection-failed", "no valid actors"));
        }

        public void onQueryResult(String to, String from, Serializable payload) {
            BamFirstActorRouter.this._broker.queryResult(this._id, this._from, from, payload);
        }

        public void onQueryError(String to, String from, Serializable payload, BamError error) {
            if (!this.nextQuery()) {
                BamFirstActorRouter.this._broker.queryError(this._id, this._from, from, payload, error);
            }
        }

        private boolean nextQuery() {
            while (this._index < BamFirstActorRouter.this._actors.length) {
                int index = this._index;
                this._index = index + 1;
                BamActorRef actor = BamFirstActorRouter.this._actors[index];
                if (!actor.isActive()) continue;
                BamFirstActorRouter.this._sender.query(actor.getAddress(), this._payload, (QueryCallback)this, this._actorTimeout);
                return true;
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + BamFirstActorRouter.this._sender + "," + this._from + "," + this._payload + "]";
        }
    }
}

