/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam;

import com.caucho.bam.BamException;
import com.caucho.bam.ErrorPacketException;
import com.caucho.bam.FeatureNotImplementedException;
import com.caucho.bam.ForbiddenException;
import com.caucho.bam.InternalServerException;
import com.caucho.bam.NotAuthorizedException;
import com.caucho.bam.RemoteConnectionFailedException;
import com.caucho.bam.RemoteListenerUnavailableException;
import com.caucho.bam.ServiceUnavailableException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BamError
implements Serializable {
    private static final Logger log = Logger.getLogger(BamError.class.getName());
    public static final String TYPE_AUTH = "auth";
    public static final String TYPE_CANCEL = "cancel";
    public static final String TYPE_CONTINUE = "continue";
    public static final String TYPE_MODIFY = "modify";
    public static final String TYPE_WAIT = "wait";
    public static final String CONNECTION_TIMEOUT = "connection-timeout";
    public static final String REMOTE_CONNECTION_FAILED = "remote-connection-failed";
    public static final String REMOTE_LISTENER_UNAVAILABLE = "remote-listener-unavailable";
    public static final String BAD_REQUEST = "bad-request";
    public static final String CONFLICT = "conflict";
    public static final String FEATURE_NOT_IMPLEMENTED = "feature-not-implemented";
    public static final String FORBIDDEN = "forbidden";
    public static final String GONE = "gone";
    public static final String INTERNAL_SERVER_ERROR = "internal-server-error";
    public static final String ITEM_NOT_FOUND = "item-not-found";
    public static final String address_MALFORMED = "address-malformed";
    public static final String NOT_ACCEPTABLE = "not-acceptable";
    public static final String NOT_ALLOWED = "not-allowed";
    public static final String NOT_AUTHORIZED = "not-authorized";
    public static final String PAYMENT_REQUIRED = "payment-required";
    public static final String RECIPIENT_UNAVAILABLE = "recipient-unavailable";
    public static final String REDIRECT = "redirect";
    public static final String REGISTRATION_REQUIRED = "registration-required";
    public static final String REMOTE_SERVER_NOT_FOUND = "remote-server-not-found";
    public static final String REMOTE_SERVER_TIMEOUT = "remote-server-timeout";
    public static final String RESOURCE_CONSTRAINT = "resource-constraint";
    public static final String SERVICE_UNAVAILABLE = "service-unavailable";
    public static final String SUBSCRIPTION_REQUIRED = "subscription-required";
    public static final String UNDEFINED_CONDITION = "undefined-condition";
    public static final String UNEXPECTED_REQUEST = "unexpected-request";
    private static final HashMap<String, ErrorGroup> _errorMap = new HashMap();
    private final String type;
    private final String group;
    private final String text;
    private Serializable data;
    private Serializable extra;

    private BamError() {
        this.type = null;
        this.group = null;
        this.text = null;
    }

    public BamError(String text) {
        this.type = TYPE_CANCEL;
        this.group = INTERNAL_SERVER_ERROR;
        this.text = text;
    }

    public BamError(String type, String group) {
        this(type, group, null);
    }

    public BamError(String type, String group, String text) {
        this.type = type;
        this.group = group;
        this.text = text;
    }

    public BamError(String type, String group, String text, Serializable data) {
        this(type, group, text);
        this.data = data;
    }

    public static BamError create(Throwable e) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (e instanceof BamException) {
            return ((BamException)e).createActorError();
        }
        return new BamError(TYPE_CANCEL, INTERNAL_SERVER_ERROR, e.toString(), e);
    }

    public String getType() {
        return this.type;
    }

    public String getGroup() {
        return this.group;
    }

    public String getText() {
        return this.text;
    }

    public Serializable getData() {
        return this.data;
    }

    public void setData(Serializable data) {
        this.data = data;
    }

    public Throwable getException() {
        if (this.getData() instanceof Throwable) {
            return (Throwable)this.getData();
        }
        return null;
    }

    public Serializable getExtra() {
        return this.extra;
    }

    public void setExtra(Serializable extra) {
        this.extra = extra;
    }

    public ErrorPacketException createException() {
        ErrorGroup group = _errorMap.get(this.getGroup());
        if (group == null) {
            return new ErrorPacketException(this);
        }
        switch (group) {
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotImplementedException(this);
            }
            case NOT_AUTHORIZED: {
                return new NotAuthorizedException(this);
            }
            case FORBIDDEN: {
                return new ForbiddenException(this);
            }
            case REMOTE_CONNECTION_FAILED: {
                return new RemoteConnectionFailedException(this);
            }
            case REMOTE_LISTENER_UNAVAILABLE: {
                return new RemoteListenerUnavailableException(this);
            }
            case SERVICE_UNAVAILABLE: {
                return new ServiceUnavailableException(this);
            }
            case INTERNAL_SERVER_ERROR: {
                return new InternalServerException(this);
            }
        }
        return new ErrorPacketException(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[type=");
        sb.append(this.type);
        sb.append(",group=");
        sb.append(this.group);
        if (this.data != null) {
            sb.append(",data=");
            sb.append(this.data);
        }
        if (this.text != null) {
            sb.append(",text=");
            sb.append(this.text);
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        _errorMap.put(FEATURE_NOT_IMPLEMENTED, ErrorGroup.FEATURE_NOT_IMPLEMENTED);
        _errorMap.put(NOT_AUTHORIZED, ErrorGroup.NOT_AUTHORIZED);
        _errorMap.put(FORBIDDEN, ErrorGroup.FORBIDDEN);
        _errorMap.put(REMOTE_CONNECTION_FAILED, ErrorGroup.REMOTE_CONNECTION_FAILED);
        _errorMap.put(REMOTE_LISTENER_UNAVAILABLE, ErrorGroup.REMOTE_LISTENER_UNAVAILABLE);
        _errorMap.put(SERVICE_UNAVAILABLE, ErrorGroup.SERVICE_UNAVAILABLE);
        _errorMap.put(ITEM_NOT_FOUND, ErrorGroup.SERVICE_UNAVAILABLE);
        _errorMap.put(INTERNAL_SERVER_ERROR, ErrorGroup.INTERNAL_SERVER_ERROR);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorGroup {
        BAD_FORMAT,
        BAD_NAMESPACE_PREFIX,
        CONFLICT,
        CONNECTION_TIMEOUT,
        FORBIDDEN,
        HOST_GONE,
        HOST_UNKNOWN,
        IMPROPER_ADDRESSING,
        INTERNAL_SERVER_ERROR,
        INVALID_FROM,
        INVALID_ID,
        INVALID_NAMESPACE,
        INVALID_XML,
        NOT_AUTHORIZED,
        POLICY_VIOLATION,
        REMOTE_CONNECTION_FAILED,
        REMOTE_LISTENER_UNAVAILABLE,
        RESOURCE_CONSTRAINT,
        RESTRICTED_XML,
        SEE_OTHER_HOST,
        SYSTEM_SHUTDOWN,
        UNDEFINED_CONDITION,
        UNSUPPORTED_ENCODING,
        UNSUPPORTED_STANZA_TYPE,
        UNSUPPORTED_VERSION,
        XML_NOT_WELL_FORMED,
        FEATURE_NOT_IMPLEMENTED,
        SERVICE_UNAVAILABLE;

    }
}

