/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.amqp.io.AmqpAbstractFrame;
import com.caucho.amqp.io.AmqpFrameHandler;
import com.caucho.amqp.io.AmqpReader;
import com.caucho.amqp.io.AmqpWriter;
import com.caucho.amqp.io.LinkSource;
import com.caucho.amqp.io.LinkTarget;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameAttach
extends AmqpAbstractFrame {
    public static final int CODE = 18;
    private String _name;
    private int _handle;
    private Role _role = Role.RECEIVER;
    private SenderSettleMode _senderSettleMode = SenderSettleMode.MIXED;
    private ReceiverSettleMode _receiverSettleMode = ReceiverSettleMode.FIRST;
    private LinkSource _source;
    private LinkTarget _target;
    private Map<?, ?> _unsettled;
    private boolean _isIncompleteUnsettled;
    private long _initialDeliveryCount;
    private long _maxMessageSize;
    private List<String> _offeredCapabilities;
    private List<String> _desiredCapabilities;
    private Map<String, ?> _properties;

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getHandle() {
        return this._handle;
    }

    public void setHandle(int handle) {
        this._handle = handle;
    }

    public Role getRole() {
        return this._role;
    }

    public void setRole(Role role) {
        this._role = role;
    }

    public void setSenderSettleMode(SenderSettleMode mode) {
        this._senderSettleMode = mode;
    }

    public SenderSettleMode getSenderSettleMode() {
        return this._senderSettleMode;
    }

    public void setReceiverSettleMode(ReceiverSettleMode mode) {
        this._receiverSettleMode = mode;
    }

    public ReceiverSettleMode getReceiverSettleMode() {
        return this._receiverSettleMode;
    }

    public LinkSource getSource() {
        return this._source;
    }

    public void setSource(LinkSource source) {
        this._source = source;
    }

    public LinkTarget getTarget() {
        return this._target;
    }

    public void setTarget(LinkTarget target) {
        this._target = target;
    }

    public Map<?, ?> getUnsettled() {
        return this._unsettled;
    }

    public boolean isIncompleteUnsettled() {
        return this._isIncompleteUnsettled;
    }

    public long getInitialDeliveryCount() {
        return this._initialDeliveryCount;
    }

    public void setInitialDeliveryCount(long deliveryCount) {
        this._initialDeliveryCount = deliveryCount;
    }

    public long getMaxMessageSize() {
        return this._maxMessageSize;
    }

    public List<String> getOfferedCapabilities() {
        return this._offeredCapabilities;
    }

    public List<String> getDesiredCapabilities() {
        return this._desiredCapabilities;
    }

    public void setProperties(Map<String, ?> properties) {
        this._properties = properties;
    }

    public Map<String, ?> getProperties() {
        return this._properties;
    }

    @Override
    public long getDescriptorCode() {
        return 18L;
    }

    @Override
    public FrameAttach createInstance() {
        return new FrameAttach();
    }

    @Override
    public void invoke(AmqpReader ain, AmqpFrameHandler receiver) throws IOException {
        receiver.onAttach(this);
    }

    @Override
    public int writeBody(AmqpWriter out) throws IOException {
        out.writeString(this._name);
        out.writeUint(this._handle);
        out.writeBoolean(this._role == Role.RECEIVER);
        out.writeUbyte(this._senderSettleMode.ordinal());
        out.writeUbyte(this._receiverSettleMode.ordinal());
        if (this._source != null) {
            this._source.write(out);
        } else {
            out.writeNull();
        }
        if (this._target != null) {
            this._target.write(out);
        } else {
            out.writeNull();
        }
        out.writeMap(this._unsettled);
        out.writeBoolean(this._isIncompleteUnsettled);
        out.writeUint((int)this._initialDeliveryCount);
        out.writeUlong(this._maxMessageSize);
        out.writeSymbolArray(this._offeredCapabilities);
        out.writeSymbolArray(this._desiredCapabilities);
        out.writeFieldsMap(this._properties);
        return 14;
    }

    @Override
    public void readBody(AmqpReader in, int count) throws IOException {
        this._name = in.readString();
        this._handle = in.readInt();
        this._role = Role.values()[in.readBoolean() ? 1 : 0];
        this._senderSettleMode = SenderSettleMode.values()[in.readInt()];
        this._receiverSettleMode = ReceiverSettleMode.values()[in.readInt()];
        this._source = in.readObject(LinkSource.class);
        this._target = in.readObject(LinkTarget.class);
        this._unsettled = in.readMap();
        this._isIncompleteUnsettled = in.readBoolean();
        this._initialDeliveryCount = in.readInt();
        this._maxMessageSize = in.readLong();
        this._offeredCapabilities = in.readSymbolArray();
        this._desiredCapabilities = in.readSymbolArray();
        this._properties = in.readFieldMap();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._handle + "," + this._name + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReceiverSettleMode {
        FIRST,
        SECOND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SenderSettleMode {
        UNSETTLED,
        SETTLED,
        MIXED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Role {
        SENDER,
        RECEIVER;

    }
}

