/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.amqp.io.AmqpBaseWriter;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;

public class AmqpFrameWriter
extends AmqpBaseWriter {
    private WriteStream _os;
    private TempBuffer _head;
    private byte[] _buffer;
    private int _offset;

    public AmqpFrameWriter() {
    }

    public AmqpFrameWriter(WriteStream os) {
        this.init(os);
    }

    public void init(WriteStream os) {
        this._os = os;
        this._head = TempBuffer.allocate();
        this._buffer = this._head.getBuffer();
    }

    public void startFrame(int type) {
        this._buffer[4] = 2;
        this._buffer[5] = (byte)type;
        this._offset = 8;
    }

    public void startFrame(int type, int channel) {
        this._buffer[4] = 2;
        this._buffer[5] = (byte)type;
        this._buffer[6] = (byte)(channel >> 8);
        this._buffer[7] = (byte)channel;
        this._offset = 8;
    }

    public void finishFrame() throws IOException {
        if (this._offset < 0) {
            throw new IllegalStateException();
        }
        this._buffer[0] = (byte)(this._offset >> 24);
        this._buffer[1] = (byte)(this._offset >> 16);
        this._buffer[2] = (byte)(this._offset >> 8);
        this._buffer[3] = (byte)this._offset;
        this._os.write(this._buffer, 0, this._offset);
        this._offset = 0;
    }

    public int write(InputStream is) throws IOException {
        int ch;
        int len = 0;
        while ((ch = is.read()) >= 0) {
            ++len;
            this.write(ch);
        }
        return len;
    }

    public void write(int ch) {
        this._buffer[this._offset++] = (byte)ch;
    }

    public int getOffset() {
        return this._offset;
    }

    public void writeByte(int offset, int value) {
        this._buffer[offset] = (byte)value;
    }

    public void flush() throws IOException {
        this._os.flush();
    }
}

