/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.common;

import com.caucho.amqp.common.AmqpLink;
import com.caucho.amqp.common.DeliveryNode;
import com.caucho.amqp.io.DeliveryState;
import com.caucho.message.SettleMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferSettleManager<L extends AmqpLink> {
    private long _deliveryId = 1L;
    private DeliveryNode[] _unsettledList = new DeliveryNode[128];
    private int _unsettledCount;
    private int _unsettledHead;
    private int _unsettledTail;

    public long addDelivery(L link, long messageId, SettleMode settleMode) {
        long deliveryId = this._deliveryId++;
        if (settleMode == SettleMode.ALWAYS) {
            return deliveryId;
        }
        DeliveryNode node = new DeliveryNode(deliveryId, (AmqpLink)link, messageId, settleMode);
        this._unsettledList[this._unsettledHead++] = node;
        return deliveryId;
    }

    public void onDisposition(long xid, DeliveryState deliveryState, long first, long last) {
        DeliveryNode[] unsettledList = this._unsettledList;
        int head = this._unsettledHead;
        for (int i = this._unsettledTail; i < head; ++i) {
            DeliveryNode node = unsettledList[i];
            if (node == null) continue;
            long deliveryId = node.getDeliveryId();
            if (last < deliveryId) {
                return;
            }
            if (deliveryId < first) continue;
            unsettledList[i] = null;
            deliveryState.update(xid, node);
        }
    }
}

