/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.common;

import com.caucho.amqp.common.AmqpLink;
import com.caucho.amqp.io.FrameAttach;
import com.caucho.amqp.io.FrameFlow;
import com.caucho.message.SettleMode;
import java.io.InputStream;

public abstract class AmqpSenderLink
extends AmqpLink {
    private long _deliveryCount;
    private long _deliveryLimit;
    private int _peerLinkCredit;

    protected AmqpSenderLink(String name, String address) {
        super(name, address);
    }

    public final FrameAttach.Role getRole() {
        return FrameAttach.Role.SENDER;
    }

    public final long getDeliveryCount() {
        return this._deliveryCount;
    }

    public final int getLinkCredit() {
        long linkCredit = this._deliveryLimit - this._deliveryCount;
        return Math.max((int)linkCredit, 0);
    }

    public void transfer(long mid, SettleMode settleMode, InputStream is) {
        ++this._deliveryCount;
        this.getSession().transfer(this, mid, settleMode, is);
    }

    public void onFlow(FrameFlow flow) {
        long peerDeliveryCount = flow.getDeliveryCount();
        int peerLinkCredit = flow.getLinkCredit();
        long deliveryCount = this._deliveryCount;
        if (peerDeliveryCount < 0L) {
            this._deliveryLimit = deliveryCount + (long)peerLinkCredit;
        } else {
            long delta = Math.max(deliveryCount - peerDeliveryCount, 0L);
            long linkCredit = Math.max((long)peerLinkCredit - delta, 0L);
            this._deliveryLimit = this._deliveryCount + linkCredit;
        }
    }
}

