/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.client;

import com.caucho.amqp.AmqpConnection;
import com.caucho.amqp.AmqpException;
import com.caucho.amqp.AmqpReceiver;
import com.caucho.amqp.client.AmqpClientFrameReader;
import com.caucho.amqp.client.AmqpClientReceiver;
import com.caucho.amqp.client.AmqpClientReceiverFactory;
import com.caucho.amqp.client.AmqpClientSender;
import com.caucho.amqp.client.AmqpClientSenderFactory;
import com.caucho.amqp.client.AmqpClientSenderLink;
import com.caucho.amqp.common.AmqpConnectionHandler;
import com.caucho.amqp.common.AmqpLinkFactory;
import com.caucho.amqp.common.AmqpReceiverLink;
import com.caucho.amqp.common.AmqpSenderLink;
import com.caucho.amqp.common.AmqpSession;
import com.caucho.env.thread.ThreadPool;
import com.caucho.message.DistributionMode;
import com.caucho.message.SettleMode;
import com.caucho.vfs.QSocketWrapper;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmqpClientConnectionImpl
implements AmqpConnection,
AmqpLinkFactory {
    private static final Logger log = Logger.getLogger(AmqpClientConnectionImpl.class.getName());
    private String _hostname;
    private int _port;
    private QSocketWrapper _s;
    private ReadStream _is;
    private WriteStream _os;
    private AmqpConnectionHandler _handler;
    private AmqpSession _session;
    private AmqpClientFrameReader _reader;
    private final AtomicInteger _linkId = new AtomicInteger();
    private final AtomicBoolean _isClosed = new AtomicBoolean();
    private boolean _isDisconnected;

    public AmqpClientConnectionImpl() {
    }

    public AmqpClientConnectionImpl(String hostname, int port) {
        this._hostname = hostname;
        this._port = port;
    }

    public void setHostname(String hostname) {
        this._hostname = hostname;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public boolean isDisconnected() {
        return this._isDisconnected;
    }

    public void connect() {
        boolean isValid = false;
        try {
            this.connectSocket();
            this._handler = new AmqpConnectionHandler(this, this._is, this._os);
            this._handler.getWriter().writeVersion(0);
            this._handler.getWriter().writeOpen();
            this._session = this._handler.beginSession();
            this._handler.getWriter().flush();
            this._handler.getReader().readVersion();
            this._handler.getReader().readOpen();
            this._reader = new AmqpClientFrameReader(this, this._handler.getReader());
            ThreadPool.getCurrent().schedule(this._reader);
            isValid = true;
        }
        catch (IOException e) {
            throw new AmqpException(e);
        }
        finally {
            if (!isValid) {
                this.disconnect();
            }
        }
    }

    public AmqpClientSenderFactory createSenderFactory() {
        return new AmqpClientSenderFactory(this);
    }

    public AmqpClientSender<?> createSender(String address) {
        return (AmqpClientSender)this.createSenderFactory().setAddress(address).build();
    }

    AmqpClientSender<?> buildSender(AmqpClientSenderFactory factory) {
        return new AmqpClientSender(this, this._session, factory);
    }

    @Override
    public AmqpClientReceiverFactory createReceiverFactory() {
        return new AmqpClientReceiverFactory(this);
    }

    @Override
    public AmqpReceiver<?> createReceiver(String address) {
        AmqpClientReceiverFactory factory = this.createReceiverFactory();
        factory.setAddress(address);
        return factory.build();
    }

    AmqpClientReceiver<?> buildReceiver(AmqpClientReceiverFactory factory) {
        return new AmqpClientReceiver(this, this._session, factory);
    }

    void closeSender(AmqpClientSenderLink link) {
        this._handler.closeSender(link);
    }

    void closeReceiver(AmqpClientSenderLink link) {
        this.closeSender(link);
    }

    @Override
    public AmqpReceiverLink createReceiverLink(String name, String address, Map<String, Object> nodeProperties) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public AmqpSenderLink createSenderLink(String name, String address, DistributionMode distMode, SettleMode settleMode, Map<String, Object> nodeProperties) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    private void connectSocket() throws IOException {
        Socket socket = new Socket(this._hostname, this._port);
        this._s = new QSocketWrapper(socket);
        this._is = new ReadStream(this._s.getStream());
        this._os = new WriteStream(this._s.getStream());
    }

    public int nextLinkId() {
        return this._linkId.incrementAndGet();
    }

    public void onClose() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this._isClosed.compareAndSet(false, true)) {
            return;
        }
        try {
            this._handler.closeSessions();
            this._handler.closeConnection();
        }
        finally {
            this.disconnect();
        }
    }

    public void disconnect() {
        try {
            this.disconnectImpl();
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    private void disconnectImpl() throws IOException {
        this._isDisconnected = true;
        QSocketWrapper s = this._s;
        this._s = null;
        ReadStream is = this._is;
        this._is = null;
        WriteStream os = this._os;
        this._os = null;
        if (s != null) {
            s.close();
        }
        if (is != null) {
            is.close();
        }
        if (os != null) {
            os.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._hostname + ":" + this._port + "]";
    }
}

