/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.AmberType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class YesNoType
extends AmberType {
    private static final L10N L = new L10N(YesNoType.class);
    private static final YesNoType YES_NO_TYPE = new YesNoType();

    private YesNoType() {
    }

    public static YesNoType create() {
        return YES_NO_TYPE;
    }

    public String getName() {
        return "java.lang.Boolean";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.YesNoType.toBoolean(" + rs + ".getString(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, 0);");
        out.println("else");
        out.println("  " + pstmt + ".setString(" + index + "++, " + value + ".booleanValue() ? \"y\" : \"n\");");
    }

    public static Boolean toBoolean(String value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        if ("y".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("n".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        String value = rs.getString(index);
        if (rs.wasNull()) {
            return null;
        }
        if ("y".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("n".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }
}

