/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AmberType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BigDecimalType
extends AmberType {
    private static final L10N L = new L10N(BigDecimalType.class);
    private int _scale = -1;

    private BigDecimalType() {
    }

    public static BigDecimalType create() {
        return new BigDecimalType();
    }

    public String getName() {
        return "java.math.BigDecimal";
    }

    public boolean isNumeric() {
        return true;
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getBigDecimal(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("rs.getBigDecimal(columnNames[" + index + "])");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.DECIMAL);");
        out.println("else");
        out.println("  " + pstmt + ".setBigDecimal(" + index + "++, " + value + ");");
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        pstmt.setBigDecimal(index, (BigDecimal)value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return rs.getBigDecimal(index);
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(2, length, precision, scale);
    }
}

