/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.AmberQuery;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.expr.ArgExpr;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.AmberSelectQuery;
import com.caucho.amber.query.QueryCacheKey;
import com.caucho.amber.query.ResultSetCacheChunk;
import com.caucho.amber.query.ResultSetImpl;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.ByteType;
import com.caucho.amber.type.DoubleType;
import com.caucho.amber.type.FloatType;
import com.caucho.amber.type.IntegerType;
import com.caucho.amber.type.LongType;
import com.caucho.amber.type.ObjectType;
import com.caucho.amber.type.ShortType;
import com.caucho.amber.type.SqlDateType;
import com.caucho.amber.type.SqlTimestampType;
import com.caucho.amber.type.StringType;
import com.caucho.jdbc.JdbcMetaData;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserQuery
implements AmberQuery {
    private static final int LIMIT_INF = 0x3FFFFFFF;
    private AmberConnection _aConn;
    private AbstractQuery _query;
    private ResultSetImpl _rs;
    private QueryCacheKey _cacheKey;
    private AmberType[] _argTypes;
    private Object[] _argValues;
    private int _argLength = 0;
    private int _firstResult = 0;
    private int _maxResults = -1;
    private long _cacheMaxAge;
    private boolean _copyOnLoad = true;
    private boolean _loadOnQuery;

    public UserQuery(AbstractQuery query) {
        this._query = query;
        ArgExpr[] argList = query.getArgList();
        this._argTypes = new AmberType[argList.length];
        this._argValues = new Object[argList.length];
        this._argLength = argList.length;
        if (query instanceof AmberSelectQuery) {
            AmberSelectQuery select = (AmberSelectQuery)query;
            if (select.getOffset() >= 0) {
                this._firstResult = select.getOffset();
            }
            if (select.getLimit() >= 0) {
                this._maxResults = select.getLimit();
            }
        }
    }

    @Override
    public String getQueryString() {
        return this._query.getQueryString();
    }

    @Override
    public void init(AmberConnection aConn) {
        this.setSession(aConn);
    }

    public void setSession(AmberConnection aConn) {
        this._aConn = aConn;
    }

    public AmberConnection getSession() {
        return this._aConn;
    }

    public AmberConnection getConnection() {
        return this._aConn;
    }

    @Override
    public void setLoadOnQuery(boolean loadOnQuery) {
        this._loadOnQuery = loadOnQuery;
    }

    public AbstractQuery getQuery() {
        return this._query;
    }

    AmberType[] getArgTypes() {
        return this._argTypes;
    }

    Object[] getArgValues() {
        return this._argValues;
    }

    int getArgLength() {
        return this._argLength;
    }

    @Override
    public void setString(int index, String v) {
        this._argTypes[index - 1] = StringType.create();
        this._argValues[index - 1] = v;
        this._argLength = index;
    }

    @Override
    public void setByte(int index, byte v) {
        this._argTypes[index - 1] = ByteType.create();
        this._argValues[index - 1] = new Integer(v);
        this._argLength = index;
    }

    @Override
    public void setShort(int index, short v) {
        this._argTypes[index - 1] = ShortType.create();
        this._argValues[index - 1] = new Integer(v);
        this._argLength = index;
    }

    @Override
    public void setInt(int index, int v) {
        this._argTypes[index - 1] = IntegerType.create();
        this._argValues[index - 1] = new Integer(v);
        this._argLength = index;
    }

    @Override
    public void setLong(int index, long v) {
        this._argTypes[index - 1] = LongType.create();
        this._argValues[index - 1] = new Long(v);
        this._argLength = index;
    }

    @Override
    public void setDouble(int index, double v) {
        this._argTypes[index - 1] = DoubleType.create();
        this._argValues[index - 1] = new Double(v);
        this._argLength = index;
    }

    @Override
    public void setFloat(int index, float v) {
        this._argTypes[index - 1] = FloatType.create();
        this._argValues[index - 1] = new Float(v);
        this._argLength = index;
    }

    @Override
    public void setTimestamp(int index, Timestamp v) {
        this._argTypes[index - 1] = SqlTimestampType.create();
        this._argValues[index - 1] = v;
        this._argLength = index;
    }

    @Override
    public void setDate(int index, Date v) {
        this._argTypes[index - 1] = SqlDateType.create();
        this._argValues[index - 1] = v;
        this._argLength = index;
    }

    @Override
    public void setObject(int index, Object v) {
        this._argTypes[index - 1] = ObjectType.create();
        this._argValues[index - 1] = v;
        this._argLength = index;
    }

    public void setObject(int index, Object v, AmberType type) {
        this._argTypes[index - 1] = type;
        this._argValues[index - 1] = v;
        this._argLength = index;
    }

    @Override
    public void setNull(int index, int v) {
        this._argTypes[index - 1] = StringType.create();
        this._argValues[index - 1] = null;
        this._argLength = index;
    }

    @Override
    public void setFirstResult(int index) {
        this._firstResult = index;
    }

    @Override
    public void setMaxResults(int index) {
        this._maxResults = index;
    }

    public int getMaxResults() {
        return this._maxResults;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this._aConn.flushNoChecks();
        if (this._rs == null) {
            this._rs = new ResultSetImpl();
        }
        AmberSelectQuery query = (AmberSelectQuery)this._query;
        int firstResult = this._firstResult;
        int maxResults = this._maxResults;
        this._rs.setQuery(query);
        this._rs.setSession(this._aConn);
        this._rs.setFirstResult(firstResult);
        this._rs.setMaxResults(maxResults);
        this._rs.setRow(0);
        int chunkSize = this._aConn.getCacheChunkSize();
        boolean isCacheable = chunkSize <= this._firstResult ? false : (this._aConn.isActiveTransaction() && !query.isTableReadOnly() ? false : query.isCacheable());
        ResultSetCacheChunk cacheChunk = null;
        ResultSetMetaData metaData = null;
        if (isCacheable) {
            int row = 0;
            cacheChunk = this._aConn.getQueryCacheChunk(query.getSQL(), this._argValues, row);
            metaData = this._aConn.getQueryMetaData();
            if (cacheChunk == null) {
                cacheChunk = this.fillCache(query);
            }
            firstResult = cacheChunk.getRowCount();
            maxResults = cacheChunk.getRowCount() < chunkSize ? 0 : (maxResults < 0 ? 0x3FFFFFFF : (maxResults -= firstResult - this._firstResult));
            this._rs.setCacheChunk(cacheChunk, metaData);
            this._rs.setUserQuery(this);
        } else if (maxResults < 0) {
            maxResults = 0x3FFFFFFF;
        }
        if (maxResults > 0) {
            ResultSet rs = this.executeQuery(firstResult, maxResults);
            metaData = rs.getMetaData();
            this._rs.setResultSet(rs, metaData);
            this._rs.setRow(this._firstResult);
        }
        this._rs.init();
        return this._rs;
    }

    private ResultSetCacheChunk fillCache(AmberSelectQuery query) throws SQLException {
        int chunkSize = this._aConn.getCacheChunkSize();
        ResultSet rs = this.executeQuery(0, chunkSize);
        ResultSetMetaData metaData = rs.getMetaData();
        this._rs.setResultSet(rs, metaData);
        ResultSetCacheChunk cacheChunk = new ResultSetCacheChunk();
        cacheChunk.setQuery(query);
        this._rs.fillCacheChunk(cacheChunk);
        this._aConn.putQueryCacheChunk(query.getSQL(), this._argValues, 0, cacheChunk, metaData);
        return cacheChunk;
    }

    ResultSet executeQuery(int firstResults, int maxResults) throws SQLException {
        String sql = this._query.getSQL();
        int row = 0;
        if (maxResults > 0 && maxResults < 0x3FFFFFFF) {
            JdbcMetaData metaData = this._aConn.getAmberManager().getMetaData();
            if (metaData.isLimitOffset()) {
                sql = metaData.limit(sql, firstResults, maxResults);
                row = firstResults;
            } else {
                sql = metaData.limit(sql, 0, firstResults + maxResults);
            }
        }
        PreparedStatement pstmt = this._aConn.prepareStatement(sql);
        ArgExpr[] args = this._query.getArgList();
        if (args.length > 0) {
            pstmt.clearParameters();
        }
        for (int i = 0; i < args.length; ++i) {
            args[i].setParameter(pstmt, i + 1, this._argTypes, this._argValues);
        }
        ResultSet rs = pstmt.executeQuery();
        for (int i = row; i < firstResults && rs.next(); ++i) {
        }
        return rs;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this._aConn.flushNoChecks();
        String sql = this._query.getSQL();
        PreparedStatement pstmt = this._aConn.prepareStatement(sql);
        ArgExpr[] args = this._query.getArgList();
        if (args.length > 0) {
            pstmt.clearParameters();
        }
        for (int i = 0; i < args.length; ++i) {
            args[i].setParameter(pstmt, i + 1, this._argTypes, this._argValues);
        }
        this._query.prepare(this, this._aConn);
        int count = pstmt.executeUpdate();
        if (count != 0) {
            this._query.complete(this, this._aConn);
        }
        return count;
    }

    @Override
    public void setCacheMaxAge(long ms) {
        this._cacheMaxAge = ms;
    }

    @Override
    public List<Object> list() throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        this.list(list);
        return list;
    }

    @Override
    public Object getSingleResult() throws SQLException {
        AmberSelectQuery query = (AmberSelectQuery)this._query;
        ResultSet rs = null;
        this._aConn.pushDepth();
        try {
            rs = this.executeQuery();
            if (rs.next()) {
                Object object = rs.getObject(1);
                return object;
            }
            Object var3_4 = null;
            return var3_4;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this._aConn.popDepth();
            if (rs != null) {
                rs.close();
            }
        }
    }

    @Override
    public void list(List<Object> list) throws SQLException {
        AmberSelectQuery query = (AmberSelectQuery)this._query;
        ResultSet rs = null;
        this._aConn.pushDepth();
        try {
            rs = this.executeQuery();
            int tupleCount = query.getResultCount();
            while (rs.next()) {
                if (tupleCount == 1) {
                    Object value = rs.getObject(1);
                    list.add(value);
                    continue;
                }
                Object[] values = new Object[tupleCount];
                for (int i = 0; i < tupleCount; ++i) {
                    values[i] = rs.getObject(i + 1);
                }
                list.add(values);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this._aConn.popDepth();
            if (rs != null) {
                rs.close();
            }
        }
    }

    @Override
    public void list(Map<Object, Object> map, Method methodGetMapKey) throws SQLException, IllegalAccessException, InvocationTargetException {
        AmberSelectQuery query = (AmberSelectQuery)this._query;
        ResultSet rs = null;
        this._aConn.pushDepth();
        try {
            rs = this.executeQuery();
            int tupleCount = query.getResultCount();
            while (rs.next()) {
                if (tupleCount == 1) {
                    Object value = rs.getObject(1);
                    Entity entity = (Entity)value;
                    Object mapKey = methodGetMapKey == null ? entity.__caucho_getPrimaryKey() : methodGetMapKey.invoke((Object)entity, null);
                    map.put(mapKey, value);
                    continue;
                }
                Object[] values = new Object[tupleCount];
                for (int i = 0; i < tupleCount; ++i) {
                    values[i] = rs.getObject(i + 1);
                }
                Object mapKey = values[0];
                map.put(mapKey, values);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this._aConn.popDepth();
            if (rs != null) {
                rs.close();
            }
        }
    }

    public String toString() {
        return "UserQuery[" + this._query.getQueryString() + "]";
    }
}

