/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.AndExpr;
import com.caucho.amber.expr.ArgExpr;
import com.caucho.amber.expr.EmbeddedExpr;
import com.caucho.amber.expr.JoinExpr;
import com.caucho.amber.expr.ManyToOneJoinExpr;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.query.CachedQuery;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParseException;
import com.caucho.amber.query.TableCacheUpdate;
import com.caucho.amber.query.UserQuery;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.EntityType;
import com.caucho.jdbc.JdbcMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuery {
    private String _sql;
    AmberExpr _where;
    AmberExpr _having;
    protected ArrayList<FromItem> _fromList = new ArrayList();
    protected HashMap<String, EmbeddedExpr> _embeddedAliases = new HashMap();
    private ArgExpr[] _argList;
    private ArrayList<String> _preparedMapping = new ArrayList();
    private JdbcMetaData _metaData;
    private boolean _hasSubQuery;

    AbstractQuery(String sql, JdbcMetaData metaData) {
        this._sql = sql;
        this._metaData = metaData;
    }

    public String getQueryString() {
        return this._sql;
    }

    public void addEmbeddedAlias(String alias, EmbeddedExpr expr) {
        this._embeddedAliases.put(alias, expr);
    }

    public HashMap<String, EmbeddedExpr> getEmbeddedAliases() {
        return this._embeddedAliases;
    }

    public FromItem createFromItem(AmberTable table, String name) {
        return this.createFromItem(null, table, name);
    }

    public FromItem createFromItem(EntityType entityType, AmberTable table, String name) {
        FromItem item = new FromItem(entityType, table, name, this._fromList.size());
        item.setQuery(this);
        this._fromList.add(item);
        return item;
    }

    public FromItem createDependentFromItem(FromItem parent, LinkColumns link, String name) {
        JoinExpr join;
        for (int i = 0; i < this._fromList.size(); ++i) {
            join = this._fromList.get(i).getJoinExpr();
            if (join == null || !join.isDependent(parent, link)) continue;
            return this._fromList.get(i);
        }
        FromItem item = this.createFromItem(null, link.getSourceTable(), name);
        join = new ManyToOneJoinExpr(link, item, parent);
        item.setJoinExpr(join);
        return item;
    }

    public ArrayList<FromItem> getFromList() {
        return this._fromList;
    }

    public AbstractQuery getParentQuery() {
        return null;
    }

    public ArrayList<String> getPreparedMapping() {
        return this._preparedMapping;
    }

    public abstract String getSQL();

    void init() throws QueryParseException {
        FromItem item;
        int i;
        JoinExpr link;
        AmberExpr component;
        int i2;
        ArrayList<AmberExpr> components;
        AndExpr and;
        if (this._where instanceof AndExpr) {
            and = (AndExpr)this._where;
            components = and.getComponents();
            for (i2 = components.size() - 1; i2 >= 0; --i2) {
                component = components.get(i2);
                if (!(component instanceof JoinExpr) || !(link = (JoinExpr)component).bindToFromItem()) continue;
                components.remove(i2);
            }
            this._where = and.getSingle();
        }
        if (this._having instanceof AndExpr) {
            and = (AndExpr)this._having;
            components = and.getComponents();
            for (i2 = components.size() - 1; i2 >= 0; --i2) {
                component = components.get(i2);
                if (!(component instanceof JoinExpr) || !(link = (JoinExpr)component).bindToFromItem()) continue;
                components.remove(i2);
            }
            this._having = and.getSingle();
        }
        for (i = 0; i < this._fromList.size(); ++i) {
            FromItem subItem;
            JoinExpr nextJoin;
            boolean isTarget;
            item = this._fromList.get(i);
            JoinExpr join = item.getJoinExpr();
            if (join == null) continue;
            FromItem joinParent = join.getJoinParent();
            FromItem joinTarget = join.getJoinTarget();
            boolean bl = isTarget = item == joinTarget;
            if (joinParent == null) continue;
            if (joinParent.getJoinExpr() == null && joinParent == joinTarget && !this.usesFromData(joinParent)) {
                this._fromList.remove(joinParent);
                this.replaceJoin(join);
                item.setJoinExpr(null);
                i = -1;
                AmberExpr joinWhere = join.getWhere();
                if (joinWhere == null) continue;
                this._where = AndExpr.create(this._where, joinWhere);
                continue;
            }
            if (item != joinTarget || this.isJoinParent(item) || this.usesFromData(item)) continue;
            boolean isManyToOne = false;
            boolean isManyToMany = false;
            if (join instanceof ManyToOneJoinExpr) {
                isManyToOne = true;
                ManyToOneJoinExpr manyToOneJoinExpr = (ManyToOneJoinExpr)join;
                isManyToMany = manyToOneJoinExpr.isManyToMany();
            }
            if (!isManyToMany && (!isManyToOne || item.isInnerJoin()) || i + 1 < this._fromList.size() && (nextJoin = (subItem = this._fromList.get(i + 1)).getJoinExpr()) != null && nextJoin instanceof ManyToOneJoinExpr) continue;
            this._fromList.remove(item);
            this.replaceJoin(join);
            i = -1;
            AmberExpr joinWhere = join.getWhere();
            if (joinWhere == null) continue;
            this._where = AndExpr.create(this._where, joinWhere);
        }
        for (i = 0; i < this._fromList.size(); ++i) {
            item = this._fromList.get(i);
            if (item.isInnerJoin() || item.getJoinExpr() == null) continue;
            boolean isFromInner = this.isFromInnerJoin(item);
            item.setOuterJoin(!isFromInner);
        }
    }

    boolean isJoinParent(FromItem item) {
        for (int i = 0; i < this._fromList.size(); ++i) {
            FromItem subItem = this._fromList.get(i);
            if (subItem.getJoinExpr() == null || subItem.getJoinExpr().getJoinParent() != item) continue;
            return true;
        }
        return false;
    }

    boolean isFromInnerJoin(FromItem item) {
        return this.usesFrom(item, 1);
    }

    boolean usesFromData(FromItem item) {
        return this.usesFrom(item, 0);
    }

    public boolean hasSubQuery() {
        return this._hasSubQuery;
    }

    public void setHasSubQuery(boolean hasSubQuery) {
        this._hasSubQuery = hasSubQuery;
    }

    public boolean exists(FromItem item) {
        return this._where != null && this._where.exists(item);
    }

    public boolean usesFrom(FromItem item, int type) {
        return this._where != null && this._where.usesFrom(item, type);
    }

    void replaceJoin(JoinExpr join) {
        if (this._where != null) {
            this._where = this._where.replaceJoin(join);
        }
    }

    boolean setArgList(ArgExpr[] argList) {
        this._argList = argList;
        int n = argList.length;
        if (n > 0 && argList[0].getName() != null) {
            for (int i = 0; i < n; ++i) {
                String name = argList[i].getName();
                if (name == null) {
                    this._preparedMapping = null;
                    return false;
                }
                this._preparedMapping.add(name);
            }
        }
        return true;
    }

    public ArgExpr[] getArgList() {
        return this._argList;
    }

    void registerUpdates(CachedQuery query) {
        for (int i = 0; i < this._fromList.size(); ++i) {
            FromItem item = this._fromList.get(i);
            AmberEntityHome home = item.getEntityHome();
            TableCacheUpdate update = new TableCacheUpdate(query);
            home.addUpdate(update);
        }
    }

    public long getCacheMaxAge() {
        return -1L;
    }

    public void prepare(UserQuery userQuery, AmberConnection aConn) throws SQLException {
    }

    public void complete(UserQuery userQuery, AmberConnection aConn) throws SQLException {
    }

    JdbcMetaData getMetaData() {
        return this._metaData;
    }
}

