/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.gen;

import com.caucho.VersionFactory;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.CascadableField;
import com.caucho.amber.field.CompositeId;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.StubMethod;
import com.caucho.amber.field.VersionField;
import com.caucho.amber.gen.LoadGroupGenerator;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.MappedSuperclassType;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.ClassComponent;
import com.caucho.loader.Environment;
import com.caucho.util.L10N;
import com.caucho.vfs.PersistentDependency;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import javax.persistence.CascadeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AmberMappedComponent
extends ClassComponent {
    private static final L10N L = new L10N(AmberMappedComponent.class);
    String _baseClassName;
    String _extClassName;
    EntityType _entityType;
    private ArrayList<PersistentDependency> _dependencies = new ArrayList();

    void setRelatedType(EntityType entityType) {
        this._entityType = entityType;
        this._dependencies.addAll(entityType.getDependencies());
        for (int i = 0; i < this._dependencies.size(); ++i) {
            Environment.addDependency(this._dependencies.get(i));
        }
    }

    public EntityType getEntityType() {
        return this._entityType;
    }

    public void setBaseClassName(String baseClassName) {
        this._baseClassName = baseClassName;
    }

    public String getBaseClassName() {
        return this._baseClassName;
    }

    public void setExtClassName(String extClassName) {
        this._extClassName = extClassName;
    }

    public String getClassName() {
        return this._extClassName;
    }

    public String getBeanClassName() {
        return this._baseClassName;
    }

    public ArrayList<PersistentDependency> getDependencies() {
        return this._dependencies;
    }

    protected boolean isEntityParent() {
        EntityType parentType = this.getEntityType().getParentType();
        return parentType != null && parentType.isEntity();
    }

    @Override
    public final void generate(JavaWriter out) throws IOException {
        EntityType parentType = this.getEntityType().getParentType();
        this.generateHeader(out, this.isEntityParent());
        this.generateInit(out);
        HashSet<Object> completedSet = new HashSet<Object>();
        this.generatePrologue(out, completedSet);
        this.generateGetCacheEntity(out);
        this.generateGetEntityType(out);
        if (!this.isEntityParent()) {
            this.generateGetEntityState(out);
        }
        this.generateIsLoaded(out);
        this.generateIsDirty(out);
        this.generateMatch(out);
        this.generateFields(out);
        this.generateMethods(out);
        this.generateDetach(out, this.isEntityParent());
        this.generateLoad(out, this.isEntityParent());
        int min = 0;
        if (this.isEntityParent()) {
            min = this.getEntityType().getParentType().getLoadGroupIndex() + 1;
        }
        int max = this.getEntityType().getLoadGroupIndex();
        for (int i = min; i <= max; ++i) {
            this.generateLoadGroup(out, i);
        }
        this.generateResultSetLoad(out, this.isEntityParent());
        this.generateSetQuery(out, this.isEntityParent());
        this.generateMerge(out);
        this.generateSetLoadMask(out);
        this.generateMakePersistent(out);
        this.generateCascadePersist(out);
        this.generateCascadeRemove(out);
        this.generateCreate(out);
        this.generateDelete(out);
        this.generateDeleteForeign(out);
        this.generateFlush(out);
        this.generateIncrementVersion(out);
        this.generateAfterCommit(out, this.isEntityParent());
        this.generateAfterRollback(out);
        this.generateLoadKey(out);
        this.generateHome(out);
    }

    void generateHeader(JavaWriter out, boolean isEntityParent) throws IOException {
        out.println("/*");
        out.println(" * Generated by Resin Amber");
        out.println(" * " + VersionFactory.getVersion());
        out.println(" */");
        out.print("private static final java.util.logging.Logger __caucho_log = ");
        out.println("java.util.logging.Logger.getLogger(\"" + this.getBeanClassName() + "\");");
        if (this._entityType.getParentType() == null) {
            out.println();
            out.println("protected transient com.caucho.amber.type.EntityType __caucho_home;");
            out.println("public transient com.caucho.amber.entity.EntityItem __caucho_cacheItem;");
            out.println("protected transient com.caucho.amber.manager.AmberConnection __caucho_session;");
            out.println("protected transient com.caucho.amber.entity.EntityState __caucho_state = com.caucho.amber.entity.EntityState.TRANSIENT;");
            int loadCount = this._entityType.getLoadGroupIndex();
            for (int i = 0; i <= loadCount / 64; ++i) {
                out.println("protected transient long __caucho_loadMask_" + i + ";");
            }
            int dirtyCount = this._entityType.getDirtyIndex();
            for (int i = 0; i <= dirtyCount / 64; ++i) {
                out.println("protected transient long __caucho_dirtyMask_" + i + ";");
                out.println("protected transient long __caucho_updateMask_" + i + ";");
            }
            out.println("protected transient boolean __caucho_inc_version;");
        }
    }

    void generateInit(JavaWriter out) throws IOException {
        if (this.isEntityParent()) {
            return;
        }
        String className = this.getClassName();
        int p = className.lastIndexOf(46);
        if (p > 0) {
            className = className.substring(p + 1);
        }
        ArrayList<AmberField> fields = this._entityType.getFields();
        Class beanClass = this._entityType.getBeanClass();
        for (Constructor<?> ctor : beanClass.getDeclaredConstructors()) {
            int i;
            out.println();
            out.print("public ");
            out.print(className);
            out.print("(");
            Class<?>[] args = ctor.getParameterTypes();
            for (i = 0; i < args.length; ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                out.printClass(args[i]);
                out.print(" a" + i);
            }
            out.println(")");
            out.println("{");
            out.pushDepth();
            out.print("super(");
            for (i = 0; i < args.length; ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                out.print("a" + i);
            }
            out.println(");");
            out.println("__caucho_state = com.caucho.amber.entity.EntityState.TRANSIENT;");
            if (this._entityType.getId() instanceof CompositeId) {
                out.println("try {");
                out.println("  __caucho_setPrimaryKey(__caucho_getPrimaryKey());");
                out.println("} catch (Exception e) {");
                out.println("  __caucho_log.fine(\"amber unable to set primary key within argument constructor \" + this.getClass().getName() + \"[PK: unknown]\");");
                out.println("}");
            }
            for (AmberField field : fields) {
                field.generatePostConstructor(out);
            }
            out.popDepth();
            out.println("}");
        }
        Id id = this._entityType.getId();
        if (id == null && this._entityType.isEntity()) {
            throw new IllegalStateException(L.l("'{0}' is missing a key.", (Object)this._entityType.getName()));
        }
        boolean isAbstract = Modifier.isAbstract(this._entityType.getBeanClass().getModifiers());
        out.println();
        out.println("public void __caucho_setPrimaryKey(Object key)");
        out.println("{");
        out.pushDepth();
        if (id != null && !isAbstract) {
            id.generateSet(out, "super", id.generateCastFromObject("key"));
        }
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public Object __caucho_getPrimaryKey()");
        out.println("{");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        out.print("return ");
        if (id == null || isAbstract) {
            out.print("null");
        } else {
            out.print(id.toObject(id.generateGet("super")));
        }
        out.println(";");
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  throw new com.caucho.amber.AmberRuntimeException(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public void __caucho_setConnection(com.caucho.amber.manager.AmberConnection aConn)");
        out.println("{");
        out.println("  __caucho_session = aConn;");
        out.println("}");
        out.println();
        out.println("public com.caucho.amber.manager.AmberConnection __caucho_getConnection()");
        out.println("{");
        out.println("  return __caucho_session;");
        out.println("}");
        this.generateExpire(out);
    }

    void generateExpire(JavaWriter out) throws IOException {
        out.println();
        out.println("public void __caucho_expire()");
        out.println("{");
        out.pushDepth();
        this.generateLogFine(out, " amber expire");
        out.println();
        int loadCount = this._entityType.getLoadGroupIndex();
        for (int i = 0; i <= loadCount / 64; ++i) {
            out.println("__caucho_loadMask_" + i + " = 0L;");
        }
        this._entityType.generateExpire(out);
        out.popDepth();
        out.println("}");
    }

    void generateIsDirty(JavaWriter out) throws IOException {
        out.println();
        out.println("public boolean __caucho_isDirty()");
        out.println("{");
        out.pushDepth();
        int dirtyCount = this._entityType.getDirtyIndex();
        for (int i = 0; i <= dirtyCount / 64; ++i) {
            out.println("if (__caucho_dirtyMask_" + i + " != 0L)");
            out.println("  return true;");
            out.println();
        }
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    void generateIsLoaded(JavaWriter out) throws IOException {
        out.println();
        out.println("public boolean __caucho_isLoaded()");
        out.println("{");
        out.pushDepth();
        out.println("return __caucho_loadMask_0 != 0L;");
        out.popDepth();
        out.println("}");
    }

    void generateMatch(JavaWriter out) throws IOException {
        out.println();
        out.println("public boolean __caucho_match(Class cl, Object key)");
        out.println("{");
        out.pushDepth();
        out.println("if (" + this.getBeanClassName() + ".class  != cl)");
        out.println("  return false;");
        out.println("else {");
        out.pushDepth();
        Id id = this._entityType.getId();
        if (id == null || Modifier.isAbstract(this._entityType.getBeanClass().getModifiers())) {
            out.println("return true;");
            out.popDepth();
            out.println("}");
            out.popDepth();
            out.println("}");
            return;
        }
        out.println("try {");
        out.pushDepth();
        id.generateMatch(out, id.generateCastFromObject("key"));
        out.popDepth();
        out.println("} catch (ClassCastException e) {");
        out.println("  throw new IllegalArgumentException(\"Primary key type is incorrect: '\"+key.getClass().getName()+\"'\");");
        out.println("}");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        boolean isAbstractParent;
        if (this._entityType.getColumns() != null) {
            for (AmberColumn column : this._entityType.getColumns()) {
                column.generatePrologue(out);
            }
        }
        Id id = this._entityType.getId();
        boolean bl = isAbstractParent = this._entityType.getParentType() == null || !this._entityType.getParentType().isEntity();
        if (id != null) {
            id.generatePrologue(out, completedSet);
        }
        ArrayList<AmberField> fields = this._entityType.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            AmberField prop = fields.get(i);
            prop.generatePrologue(out, completedSet);
        }
    }

    void generateGetCacheEntity(JavaWriter out) throws IOException {
        out.println();
        out.println("public com.caucho.amber.entity.Entity __caucho_getCacheEntity()");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_cacheItem != null)");
        out.println("  return __caucho_cacheItem.getEntity();");
        out.println("else");
        out.println("  return null;");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public com.caucho.amber.entity.EntityItem __caucho_getCacheItem()");
        out.println("{");
        out.pushDepth();
        out.println("return __caucho_cacheItem;");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public void __caucho_setCacheItem(com.caucho.amber.entity.EntityItem cacheItem)");
        out.println("{");
        out.pushDepth();
        out.println("__caucho_cacheItem = cacheItem;");
        out.popDepth();
        out.println("}");
    }

    void generateGetEntityType(JavaWriter out) throws IOException {
        out.println();
        out.println("public com.caucho.amber.type.EntityType __caucho_getEntityType()");
        out.println("{");
        out.pushDepth();
        out.println("return __caucho_home;");
        out.popDepth();
        out.println("}");
    }

    void generateGetEntityState(JavaWriter out) throws IOException {
        out.println();
        out.println("public com.caucho.amber.entity.EntityState __caucho_getEntityState()");
        out.println("{");
        out.pushDepth();
        out.println("return __caucho_state;");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public void __caucho_setEntityState(com.caucho.amber.entity.EntityState state)");
        out.println("{");
        out.pushDepth();
        out.println("__caucho_state = state;");
        out.popDepth();
        out.println("}");
    }

    void generateFields(JavaWriter out) throws IOException {
        if (this._entityType.getId() != null) {
            for (IdField key : this._entityType.getId().getKeys()) {
                if (this._entityType != key.getSourceType()) continue;
                key.generateSuperGetterMethod(out);
                key.generateSuperSetterMethod(out);
            }
        }
        for (AmberField prop : this._entityType.getFields()) {
            if (this._entityType != prop.getSourceType()) continue;
            prop.generateSuperGetterMethod(out);
            prop.generateSuperSetterMethod(out);
            if (prop instanceof IdField) continue;
            prop.generateGetterMethod(out);
            prop.generateSetterMethod(out);
        }
    }

    void generateMethods(JavaWriter out) throws IOException {
        for (StubMethod method : this._entityType.getMethods()) {
            method.generate(out);
        }
    }

    void generateLoad(JavaWriter out, boolean isEntityParent) throws IOException {
        boolean hasLoad;
        if (!isEntityParent) {
            out.println();
            out.println("public boolean __caucho_makePersistent(com.caucho.amber.manager.AmberConnection aConn, com.caucho.amber.type.EntityType home)");
            out.println("  throws java.sql.SQLException");
            out.println("{");
            out.pushDepth();
            out.println("__caucho_session = aConn;");
            out.println("if (home != null)");
            out.println("  __caucho_home = home;");
            int loadCount = this._entityType.getLoadGroupIndex();
            for (int i = 0; i <= loadCount / 64; ++i) {
                out.println("__caucho_loadMask_" + i + " = 0L;");
            }
            int dirtyCount = this._entityType.getDirtyIndex();
            for (int i = 0; i <= dirtyCount / 64; ++i) {
                out.println("__caucho_dirtyMask_" + i + " = 0L;");
                out.println("__caucho_updateMask_" + i + " = 0L;");
            }
            out.println();
            out.println("return true;");
            out.popDepth();
            out.println("}");
        }
        int index = this._entityType.getLoadGroupIndex();
        boolean bl = hasLoad = this._entityType.getFields().size() > 0;
        if (!isEntityParent) {
            index = 0;
            hasLoad = hasLoad || this._entityType.getId() != null;
        }
        out.println();
        out.println("public void __caucho_retrieve_eager(com.caucho.amber.manager.AmberConnection aConn)");
        out.println("{");
        out.pushDepth();
        this.generateRetrieveEager(out, this._entityType);
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public void __caucho_retrieve_self(com.caucho.amber.manager.AmberConnection aConn)");
        out.println("{");
        out.pushDepth();
        this.generateRetrieveSelf(out, this._entityType);
        out.popDepth();
        out.println("}");
    }

    private void generateRetrieveEager(JavaWriter out, EntityType entityType) throws IOException {
        if (entityType == null || !entityType.isEntity()) {
            return;
        }
        int index = entityType.getLoadGroupIndex();
        boolean hasLoad = entityType.getFields().size() > 0;
        EntityType parentType = entityType.getParentType();
        if (parentType == null || !parentType.isEntity()) {
            index = 0;
            hasLoad = true;
        }
        this.generateRetrieveEager(out, parentType);
        if (hasLoad) {
            out.println("__caucho_load_" + index + "(aConn);");
        }
    }

    private void generateRetrieveSelf(JavaWriter out, EntityType entityType) throws IOException {
        if (entityType == null || !entityType.isEntity()) {
            return;
        }
        int index = entityType.getLoadGroupIndex();
        boolean hasLoad = entityType.getFields().size() > 0;
        EntityType parentType = entityType.getParentType();
        if (parentType != null && parentType.isEntity()) {
            this.generateRetrieveSelf(out, parentType);
        } else {
            index = 0;
            hasLoad = true;
        }
        if (hasLoad) {
            int group = index / 64;
            long mask = 1L << index % 64;
            out.println("if ((__caucho_loadMask_" + group + " & " + mask + "L) == 0)");
            out.println("  __caucho_load_select_" + index + "(aConn);");
        }
    }

    void generateDetach(JavaWriter out, boolean isEntityParent) throws IOException {
        if (isEntityParent) {
            return;
        }
        out.println();
        out.println("public void __caucho_detach()");
        out.println("{");
        out.pushDepth();
        this.generateLogFinest(out, " amber detach");
        out.println();
        out.println("__caucho_session = null;");
        for (AmberField field : this._entityType.getFields()) {
            field.generateDetach(out);
        }
        out.println("__caucho_state = com.caucho.amber.entity.EntityState.TRANSIENT;");
        out.popDepth();
        out.println("}");
    }

    void generateLoadGroup(JavaWriter out, int groupIndex) throws IOException {
        if (this._entityType.hasLoadGroup(groupIndex)) {
            new LoadGroupGenerator(this._extClassName, this._entityType, groupIndex).generate(out);
        }
    }

    void generateResultSetLoad(JavaWriter out, boolean isEntityParent) throws IOException {
        if (isEntityParent) {
            return;
        }
        out.println();
        out.println("public int __caucho_load(com.caucho.amber.manager.AmberConnection aConn, java.sql.ResultSet rs, int index)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        int index = this._entityType.generateLoad(out, "rs", "index", 0, 0);
        out.println("__caucho_loadMask_0 |= 1L;");
        int dirtyCount = this._entityType.getDirtyIndex();
        for (int i = 0; i <= dirtyCount / 64; ++i) {
            out.println("__caucho_dirtyMask_" + i + " = 0;");
        }
        out.println();
        out.println("if (__caucho_state.isTransactional()) {");
        out.println("}");
        out.println("else if (__caucho_session == null");
        out.println("         || ! __caucho_session.isActiveTransaction()) {");
        out.println("  __caucho_state = com.caucho.amber.entity.EntityState.P_NON_TRANSACTIONAL;");
        out.println("  if (__caucho_cacheItem != null)");
        out.println("    __caucho_cacheItem.save((com.caucho.amber.entity.Entity) this);");
        out.println("}");
        out.println("else {");
        out.println("  __caucho_state = com.caucho.amber.entity.EntityState.P_TRANSACTIONAL;");
        out.println("}");
        if (this._entityType.getHasLoadCallback()) {
            out.println();
            out.println("__caucho_load_callback();");
        }
        out.println("return " + index + ";");
        out.popDepth();
        out.println("}");
    }

    void generateSetQuery(JavaWriter out, boolean isEntityParent) throws IOException {
        if (isEntityParent) {
            return;
        }
        out.println();
        out.println("public void __caucho_setKey(java.sql.PreparedStatement pstmt, int index)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        if (!this._entityType.isAbstractClass()) {
            this._entityType.generateSet(out, "pstmt", "index", "super");
        }
        out.popDepth();
        out.println("}");
    }

    void generateIncrementVersion(JavaWriter out) throws IOException {
        out.println();
        out.println("public void __caucho_increment_version()");
        out.println("{");
        out.pushDepth();
        VersionField version = this._entityType.getVersionField();
        if (version != null) {
            out.println("if (__caucho_inc_version)");
            out.println("  return;");
            out.println();
            out.println("__caucho_inc_version = true;");
            version.generateIncrementVersion(out);
        }
        out.popDepth();
        out.println("}");
    }

    void generateFlush(JavaWriter out) throws IOException {
    }

    void generateFlushUpdate(JavaWriter out, boolean isEntityParent) throws IOException {
        out.println();
        out.println("protected void __caucho_flushUpdate(long mask, com.caucho.amber.type.EntityType home)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        if (isEntityParent) {
            out.println("super.__caucho_flushUpdate(mask, home.getParentType());");
        }
        out.println("String sql = home.generateUpdateSQL(mask);");
        out.println("if (sql != null) {");
        out.pushDepth();
        out.println("java.sql.PreparedStatement pstmt = __caucho_session.prepareStatement(sql);");
        out.println("int index = 1;");
        ArrayList<AmberField> fields = this._entityType.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            AmberField field = fields.get(i);
            field.generateUpdate(out, "mask", "pstmt", "index");
        }
        out.println();
        this._entityType.getId().generateSet(out, "pstmt", "index");
        out.println();
        out.println("pstmt.executeUpdate();");
        out.println();
        this.generateLogFine(out, " amber update");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    void generateAfterCommit(JavaWriter out, boolean isEntityParent) throws IOException {
        out.println();
        out.println("public void __caucho_afterCommit()");
        out.println("{");
        out.pushDepth();
        out.println("com.caucho.amber.entity.EntityState state = __caucho_state;");
        out.println();
        out.println("__caucho_state = com.caucho.amber.entity.EntityState.P_NON_TRANSACTIONAL;");
        out.println();
        out.println("if (__caucho_session == null) {");
        int dirtyCount = this._entityType.getDirtyIndex();
        for (int i = 0; i <= dirtyCount / 64; ++i) {
            out.println("  __caucho_updateMask_" + i + " = 0L;");
        }
        out.println("  return;");
        out.println("}");
        out.println();
        out.println("if (__caucho_cacheItem == null)");
        out.println("  return;");
        out.println();
        out.println("if (state.isDeleting())");
        out.println("  return;");
        out.println();
        int group = 0;
        out.print(this.getClassName() + " item = (" + this.getClassName() + ")");
        out.println("__caucho_cacheItem.getEntity();");
        out.println("Object pk = __caucho_getPrimaryKey();");
        out.println("item.__caucho_setPrimaryKey(pk);");
        this._entityType.generateCopyLoadObject(out, "item", "super", group);
        out.println("item.__caucho_loadMask_" + group + " |= __caucho_loadMask_" + group + " & 1L;");
        out.println("__caucho_session.getPersistenceUnit().updateCacheItem((com.caucho.amber.type.EntityType) __caucho_home.getRootType(), pk, __caucho_cacheItem);");
        out.popDepth();
        out.println("}");
    }

    void generateAfterRollback(JavaWriter out) throws IOException {
        out.println();
        out.println("public void __caucho_afterRollback()");
        out.println("{");
        out.pushDepth();
        out.println("__caucho_state = com.caucho.amber.entity.EntityState.P_NON_TRANSACTIONAL;");
        int loadCount = this._entityType.getLoadGroupIndex();
        for (int i = 0; i <= loadCount / 64; ++i) {
            out.println("__caucho_loadMask_" + i + " = 0L;");
        }
        int dirtyCount = this._entityType.getDirtyIndex();
        for (int i = 0; i <= dirtyCount / 64; ++i) {
            out.println("__caucho_dirtyMask_" + i + " = 0L;");
        }
        out.popDepth();
        out.println("}");
    }

    String getDebug() {
        return "this";
    }

    void generateCreate(JavaWriter out) throws IOException {
        int i;
        boolean isAbstract = Modifier.isAbstract(this._entityType.getBeanClass().getModifiers());
        boolean isGeneratedValue = false;
        if (this._entityType.getId() != null && !isAbstract) {
            ArrayList<IdField> fields = this._entityType.getId().getKeys();
            IdField idField = fields.size() > 0 ? fields.get(0) : null;
            boolean hasReturnGeneratedKeys = false;
            try {
                hasReturnGeneratedKeys = this._entityType.getPersistenceUnit().hasReturnGeneratedKeys();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (idField != null && idField.isAutoGenerate()) {
                isGeneratedValue = true;
            }
            if (!hasReturnGeneratedKeys && idField != null && idField.getType().isAutoIncrement()) {
                out.println();
                out.println("private static com.caucho.amber.field.Generator __caucho_id_gen;");
                out.println("static {");
                out.pushDepth();
                out.println("com.caucho.amber.field.MaxGenerator gen = new com.caucho.amber.field.MaxGenerator();");
                out.print("gen.setColumn(\"");
                out.printJavaString(idField.getColumns().get(0).generateInsertName());
                out.println("\");");
                out.print("gen.setTable(\"");
                out.printJavaString(this._entityType.getName());
                out.println("\");");
                out.println("gen.init();");
                out.popDepth();
                out.println("}");
            }
        }
        out.println();
        out.println("public boolean __caucho_lazy_create(com.caucho.amber.manager.AmberConnection aConn, com.caucho.amber.type.EntityType home)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        int loadCount = 0;
        if (this._entityType.getTable() == null || this._entityType.getId() == null) {
            out.println("return false;");
            out.popDepth();
            out.println("}");
        } else {
            out.println("if (__caucho_session != null)");
            out.println("  return true;");
            out.println();
            out.println("__caucho_state = com.caucho.amber.entity.EntityState.P_PERSISTING;");
            loadCount = this._entityType.getLoadGroupIndex();
            for (int i2 = 0; i2 <= loadCount / 64; ++i2) {
                out.println("__caucho_loadMask_" + i2 + " = 0L;");
                EntityType parentType = this._entityType;
                do {
                    out.println("__caucho_loadMask_" + i2 + " |= " + parentType.getCreateLoadMask(i2) + ";");
                } while ((parentType = parentType.getParentType()) != null);
            }
            out.println();
            out.println("__caucho_session = aConn;");
            out.println("__caucho_home = home;");
            this._entityType.generatePrePersist(out);
            out.println();
            for (Method method : this._entityType.getPrePersistCallbacks()) {
                out.println(method.getName() + "();");
            }
            if (isGeneratedValue) {
                out.println("__caucho_create(aConn, home);");
            } else {
                out.println("__caucho_cascadePostPersist(aConn);");
            }
            out.println("__caucho_home.postPersist(this);");
            for (Method method : this._entityType.getPostPersistCallbacks()) {
                out.println(method.getName() + "();");
            }
            out.println();
            out.println("return true;");
            out.popDepth();
            out.println("}");
        }
        out.println();
        out.println("public boolean __caucho_create(com.caucho.amber.manager.AmberConnection aConn, com.caucho.amber.type.EntityType home)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        if (this._entityType.getTable() == null || this._entityType.getId() == null) {
            out.println("return false;");
            out.popDepth();
            out.println("}");
            return;
        }
        out.println("if (__caucho_state != com.caucho.amber.entity.EntityState.P_PERSISTING)");
        out.println("  return false;");
        out.println();
        out.println("__caucho_state = com.caucho.amber.entity.EntityState.P_PERSISTED;");
        out.println();
        out.println("__caucho_cascadePrePersist(aConn);");
        int dirtyCount = this._entityType.getDirtyIndex();
        for (int i3 = 0; i3 <= dirtyCount / 64; ++i3) {
            out.println("__caucho_dirtyMask_" + i3 + " = 0L;");
        }
        AmberTable table = this._entityType.getTable();
        String sql = null;
        out.println("String sql;");
        boolean isAutoInsert = false;
        if (this._entityType.getId() != null && !isAbstract && this._entityType.getId().isIdentityGenerator()) {
            isAutoInsert = true;
        }
        out.println("int index = 1;");
        this._entityType.getId().generateCheckCreateKey(out);
        out.println("java.sql.PreparedStatement pstmt;");
        if (isAutoInsert) {
            out.println("if (__caucho_home.isIdentityGenerator()) {");
            out.pushDepth();
            out.print("sql = \"");
            out.printJavaString(this._entityType.generateAutoCreateSQL(table));
            out.println("\";");
            out.println("pstmt = aConn.prepareInsertStatement(sql, true);");
            out.popDepth();
            out.println("} else {");
            out.pushDepth();
        }
        out.print("sql = \"");
        out.printJavaString(this._entityType.generateCreateSQL(table));
        out.println("\";");
        out.println("pstmt = aConn.prepareInsertStatement(sql, false);");
        if (isAutoInsert) {
            out.popDepth();
            out.println("}");
        }
        this._entityType.getId().generateSetInsert(out, "pstmt", "index");
        this._entityType.generateInsertSet(out, table, "pstmt", "index", "super");
        out.println();
        out.println("pstmt.executeUpdate();");
        out.println();
        this._entityType.getId().generateSetGeneratedKeys(out, "pstmt");
        EntityType parentType = this._entityType;
        do {
            for (AmberTable subTable : parentType.getSecondaryTables()) {
                sql = parentType.generateCreateSQL(subTable);
                out.println();
                out.print("sql = \"");
                out.printJavaString(sql);
                out.println("\";");
                out.println("pstmt = aConn.prepareStatement(sql);");
                out.println("index = 1;");
                out.println();
                parentType.getId().generateSetInsert(out, "pstmt", "index");
                parentType.generateInsertSet(out, subTable, "pstmt", "index", "super");
                out.println();
                out.println("pstmt.executeUpdate();");
                out.println();
                parentType.getId().generateSetGeneratedKeys(out, "pstmt");
            }
        } while ((parentType = parentType.getParentType()) != null);
        out.println("__caucho_cacheItem = new com.caucho.amber.entity.CacheableEntityItem(home.getHome(), new " + this.getClassName() + "());");
        out.println(this.getClassName() + " cacheEntity = (" + this.getClassName() + ") __caucho_cacheItem.getEntity();");
        out.println("cacheEntity.__caucho_home = home;");
        Id id = this._entityType.getId();
        out.println("Object pk = null;");
        if (!id.isEmbeddedId()) {
            ArrayList<IdField> keys = id.getKeys();
            for (IdField key : keys) {
                String value = keys.size() == 1 ? key.getType().generateCastFromObject("(pk = __caucho_getPrimaryKey())") : key.generateGet("super");
                out.println(key.generateSet("cacheEntity", value) + ";");
            }
        } else {
            id.generateCopy(out, "cacheEntity", "this");
        }
        out.println("try {");
        out.pushDepth();
        out.println("Object child;");
        for (i = 0; i <= loadCount; ++i) {
            this._entityType.generateCopyLoadObject(out, "cacheEntity", "super", i);
        }
        out.popDepth();
        out.println("} catch (RuntimeException e) {");
        out.println("  throw e;");
        out.println("} catch (Exception e) {");
        out.println("  throw new com.caucho.amber.AmberRuntimeException(e);");
        out.println("}");
        parentType = this._entityType;
        for (i = 0; i <= loadCount / 64; ++i) {
            out.println("cacheEntity.__caucho_loadMask_" + i + " = 0L;");
            do {
                out.println("cacheEntity.__caucho_loadMask_" + i + " |= " + parentType.getCreateLoadMask(i) + ";");
            } while ((parentType = parentType.getParentType()) != null);
        }
        out.println();
        out.println("if (pk == null)");
        out.println("  pk = __caucho_getPrimaryKey();");
        out.println();
        this.generateLogFine(out, " amber create");
        out.println();
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    void generateDelete(JavaWriter out) throws IOException {
    }

    void generateDeleteForeign(JavaWriter out) throws IOException {
        out.println();
        out.println("public void __caucho_invalidate_foreign(String table, Object key)");
        out.println("{");
        out.pushDepth();
        this._entityType.generateInvalidateForeign(out);
        out.popDepth();
        out.println("}");
    }

    void generateMerge(JavaWriter out) throws IOException {
        out.println();
        out.println("public void __caucho_mergeFrom(AmberConnection aConn,");
        out.println("                               Entity sourceEntity)");
        out.println("{");
        out.pushDepth();
        out.println(this.getClassName() + " source = (" + this.getClassName() + ") sourceEntity;");
        this._entityType.generateMergeFrom(out, "this", "source");
        out.popDepth();
        out.println("}");
    }

    void generateSetLoadMask(JavaWriter out) throws IOException {
    }

    void generateMakePersistent(JavaWriter out) throws IOException {
        out.println();
        out.println("public void __caucho_makePersistent(com.caucho.amber.manager.AmberConnection aConn,");
        out.println("                                    com.caucho.amber.entity.EntityItem cacheItem)");
        out.println("{");
        out.pushDepth();
        out.println(this._extClassName + " entity = (" + this._extClassName + ") cacheItem.getEntity();");
        out.println("__caucho_home = entity.__caucho_home;");
        out.println("if (__caucho_home == null) throw new NullPointerException();");
        out.println("__caucho_cacheItem = cacheItem;");
        if (this._entityType.getId() != null) {
            this._entityType.getId().generateCopy(out, "super", "entity");
        }
        out.println("__caucho_session = aConn;");
        out.println("__caucho_state = com.caucho.amber.entity.EntityState.P_NON_TRANSACTIONAL;");
        out.popDepth();
        out.println("}");
    }

    void generateCascadePersist(JavaWriter out) throws IOException {
        CascadableField cascadable;
        AmberField field;
        int i;
        out.println();
        out.println("public void __caucho_cascadePrePersist(com.caucho.amber.manager.AmberConnection aConn)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        ArrayList<AmberField> fields = this._entityType.getFields();
        for (i = 0; i < fields.size(); ++i) {
            field = fields.get(i);
            if (!field.isCascadable()) continue;
            cascadable = (CascadableField)field;
            out.println();
            cascadable.generatePreCascade(out, "aConn", CascadeType.PERSIST);
        }
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public void __caucho_cascadePostPersist(com.caucho.amber.manager.AmberConnection aConn)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        for (i = 0; i < fields.size(); ++i) {
            field = fields.get(i);
            if (!field.isCascadable()) continue;
            cascadable = (CascadableField)field;
            out.println();
            cascadable.generatePostCascade(out, "aConn", CascadeType.PERSIST);
        }
        out.popDepth();
        out.println("}");
    }

    void generateCascadeRemove(JavaWriter out) throws IOException {
        CascadableField cascadable;
        AmberField field;
        int i;
        out.println();
        out.println("public void __caucho_cascadePreRemove(com.caucho.amber.manager.AmberConnection aConn)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        ArrayList<AmberField> fields = this._entityType.getFields();
        for (i = 0; i < fields.size(); ++i) {
            field = fields.get(i);
            if (!field.isCascadable()) continue;
            cascadable = (CascadableField)field;
            out.println();
            cascadable.generatePreCascade(out, "aConn", CascadeType.REMOVE);
        }
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public void __caucho_cascadePostRemove(com.caucho.amber.manager.AmberConnection aConn)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        for (i = 0; i < fields.size(); ++i) {
            field = fields.get(i);
            if (!field.isCascadable()) continue;
            cascadable = (CascadableField)field;
            out.println();
            cascadable.generatePostCascade(out, "aConn", CascadeType.REMOVE);
        }
        out.popDepth();
        out.println("}");
    }

    void generateHome(JavaWriter out) throws IOException {
        this.generateHomeFind(out);
        boolean generateHomeNew = true;
        if (this._entityType instanceof MappedSuperclassType) {
            generateHomeNew = false;
        }
        if (generateHomeNew) {
            this.generateHomeNew(out);
            this.generateHomeFindNew(out);
        }
    }

    void generateLoadKey(JavaWriter out) throws IOException {
        out.println();
        out.print("public Object __caucho_load_key(");
        out.print("com.caucho.amber.manager.AmberConnection aConn,");
        out.println("java.sql.ResultSet rs, int index)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        boolean isAbstract = Modifier.isAbstract(this._entityType.getBeanClass().getModifiers());
        if (this._entityType.getId() == null || isAbstract) {
            out.println("return null;");
            out.popDepth();
            out.println("}");
            return;
        }
        out.print("return ");
        int index = this._entityType.getId().generateLoadForeign(out, "rs", "index", 0);
        out.println(";");
        out.popDepth();
        out.println("}");
    }

    void generateHomeFind(JavaWriter out) throws IOException {
        out.println();
        out.print("public com.caucho.amber.entity.EntityItem __caucho_home_find(");
        out.print("com.caucho.amber.manager.AmberConnection aConn,");
        out.print("com.caucho.amber.entity.AmberEntityHome home,");
        out.println("java.sql.ResultSet rs, int index)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        boolean isAbstract = Modifier.isAbstract(this._entityType.getBeanClass().getModifiers());
        if (this._entityType.getId() == null || isAbstract) {
            out.println("return null;");
            out.popDepth();
            out.println("}");
            return;
        }
        out.print("Object key = ");
        int index = this._entityType.getId().generateLoadForeign(out, "rs", "index", 0);
        out.println(";");
        if (this._entityType.getDiscriminator() == null) {
            out.println("return aConn.loadCacheItem(home.getJavaClass(), key, home);");
        } else {
            out.println("String discriminator = rs.getString(index + " + index + ");");
            out.println();
            out.println("return home.findDiscriminatorEntityItem(aConn, key, discriminator);");
        }
        out.popDepth();
        out.println("}");
    }

    void generateHomeNew(JavaWriter out) throws IOException {
        out.println();
        out.print("public com.caucho.amber.entity.Entity __caucho_home_new(");
        out.print("com.caucho.amber.entity.AmberEntityHome home");
        out.println(", Object key");
        out.println(", AmberConnection aConn");
        out.println(", EntityItem cacheItem");
        out.println(")");
        out.println("{");
        out.pushDepth();
        if (this._entityType.isAbstractClass() || this._entityType.getId() == null) {
            out.println("return null;");
            out.popDepth();
            out.println("}");
            return;
        }
        out.println(this.getClassName() + " entity = new " + this.getClassName() + "();");
        out.println("entity.__caucho_home = home.getEntityType();");
        out.println("entity.__caucho_setPrimaryKey(key);");
        out.println("entity.__caucho_session = aConn;");
        out.println("entity.__caucho_cacheItem = cacheItem;");
        out.println("return entity;");
        out.popDepth();
        out.println("}");
    }

    void generateHomeFindNew(JavaWriter out) throws IOException {
        EntityType parentType = this._entityType.getParentType();
        if (this.isEntityParent()) {
            return;
        }
        out.println();
        out.print("public com.caucho.amber.entity.Entity __caucho_home_find(");
        out.print("com.caucho.amber.manager.AmberConnection aConn, ");
        out.print("com.caucho.amber.entity.AmberEntityHome home, ");
        out.println("Object key)");
        out.println("{");
        out.pushDepth();
        AmberColumn discriminator = this._entityType.getDiscriminator();
        if (this._entityType.isAbstractClass() || this._entityType.getId() == null || discriminator == null) {
            out.println("return __caucho_home_new(home, key, aConn, null);");
            out.popDepth();
            out.println("}");
            return;
        }
        String rootTableName = this._entityType.getRootTableName();
        if (rootTableName == null) {
            rootTableName = "";
        }
        out.println("java.sql.ResultSet rs = null;");
        out.println("java.sql.PreparedStatement pstmt = null;");
        out.println("String sql = null;");
        out.println();
        out.println("try {");
        out.pushDepth();
        String keyType = this._entityType.getId().getForeignTypeName();
        String discriminatorVar = "discriminator";
        out.println("String " + discriminatorVar + " = null;");
        this.generateHomeNewLoading(out, discriminatorVar);
        out.println("com.caucho.amber.entity.Entity entity = home.newDiscriminatorEntity(key, " + discriminatorVar + ");");
        out.println("entity.__caucho_load(aConn, rs, 1);");
        out.println("return entity;");
        out.popDepth();
        out.println("} catch (RuntimeException e) {");
        out.println("  throw e;");
        out.println("} catch (Exception e) {");
        out.println("  throw new com.caucho.amber.AmberRuntimeException(e);");
        out.println("} finally {");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    void generateHomeNewLoading(JavaWriter out, String discriminatorVar) throws IOException {
        out.print("sql = \"select ");
        EntityType parentType = this._entityType;
        out.printJavaString(parentType.generateLoadSelect("o"));
        out.print(" from ");
        out.printJavaString(this._entityType.getTable().getName());
        out.print(" o where ");
        out.printJavaString(parentType.getId().generateMatchArgWhere("o"));
        out.println("\";");
        out.println("pstmt = aConn.prepareStatement(sql);");
        String keyType = this._entityType.getId().getForeignTypeName();
        out.println(keyType + " " + "keyValue = (" + keyType + ") key;");
        out.println("int index = 1;");
        this._entityType.getId().generateSetKey(out, "pstmt", "index", "keyValue");
        out.println("rs = pstmt.executeQuery();");
        out.println("if (rs.next()) {");
        out.println("  " + discriminatorVar + " = rs.getString(1);");
        out.println("}");
    }

    void generateCallbacks(JavaWriter out, String object, ArrayList<Method> callbacks) throws IOException {
        if (callbacks.size() > 0) {
            out.println();
            for (Method method : callbacks) {
                out.println(object + "." + method.getName() + "();");
            }
        }
    }

    protected void generateLogFine(JavaWriter out, String msg) throws IOException {
        out.println("if (__caucho_log.isLoggable(java.util.logging.Level.FINE))");
        out.print("  __caucho_log.fine(");
        out.print("getClass().getName() + \"[\" + __caucho_getPrimaryKey() + \"]\"");
        out.print(" + \"");
        out.printJavaString(msg);
        out.println("\");");
    }

    protected void generateLogFinest(JavaWriter out, String msg) throws IOException {
        out.println("if (__caucho_log.isLoggable(java.util.logging.Level.FINEST))");
        out.print("  __caucho_log.finest(");
        out.print("getClass().getName() + \"[\" + __caucho_getPrimaryKey() + \"]\"");
        out.print(" + \"");
        out.printJavaString(msg);
        out.println("\");");
    }
}

