/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.EmbeddedIdField;
import com.caucho.amber.field.IdField;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.MappedSuperclassType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Id {
    private static final L10N L = new L10N(Id.class);
    private static final Logger log = Logger.getLogger(Id.class.getName());
    private EntityType _ownerType;
    private ArrayList<IdField> _keys = new ArrayList();
    private ArrayList<AmberColumn> _columns = new ArrayList();

    public Id(EntityType ownerType, ArrayList<IdField> keys) {
        this._ownerType = ownerType;
        for (IdField key : keys) {
            this.addKey(key);
        }
    }

    protected Id(EntityType ownerType) {
        this._ownerType = ownerType;
    }

    public Id(EntityType ownerType, IdField key) {
        this._ownerType = ownerType;
        if (key instanceof EmbeddedIdField) {
            throw new IllegalArgumentException();
        }
        this.addKey(key);
    }

    protected void addKey(IdField key) {
        this._keys.add(key);
        if (this._ownerType instanceof MappedSuperclassType) {
            return;
        }
        if (this._ownerType.isAbstractClass()) {
            return;
        }
        this._columns.addAll(key.getColumns());
        for (AmberColumn column : key.getColumns()) {
            this._ownerType.getTable().addIdColumn(column);
        }
    }

    private static ArrayList<IdField> createField(IdField field) {
        ArrayList<IdField> fields = new ArrayList<IdField>();
        fields.add(field);
        return fields;
    }

    public EntityType getOwnerType() {
        return this._ownerType;
    }

    public ArrayList<AmberColumn> getColumns() {
        return this._columns;
    }

    public ArrayList<IdField> getKeys() {
        return this._keys;
    }

    public int getKeyCount() {
        return this._keys.size();
    }

    public IdField getKey() {
        return this._keys.get(0);
    }

    public String getForeignTypeName() {
        return this._keys.get(0).getForeignTypeName();
    }

    public boolean isIdentityGenerator() {
        for (IdField key : this._keys) {
            String generator = this._keys.get(0).getGenerator();
            if (generator == null) continue;
            return "auto".equals(generator) || "identity".equals(generator);
        }
        return false;
    }

    public IdField getGeneratedIdField() {
        for (IdField key : this._keys) {
            if (key.getGenerator() == null) continue;
            return key;
        }
        return null;
    }

    public void init() throws ConfigException {
    }

    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet, String name) throws IOException {
    }

    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        for (int i = 0; i < this._keys.size(); ++i) {
            this._keys.get(i).generatePrologue(out, completedSet);
        }
    }

    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return this.generateLoadForeign(out, rs, indexVar, index, this.getForeignTypeName().replace('.', '_'));
    }

    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index, String name) throws IOException {
        if (this._keys.size() > 1) {
            throw new UnsupportedOperationException();
        }
        return this._keys.get(0).generateLoadForeign(out, rs, indexVar, index, name);
    }

    public void generateCopy(JavaWriter out, String dest, String source) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            IdField key = keys.get(i);
            out.println(key.generateSet(dest, key.generateGet(source)) + ";");
        }
    }

    public String generateSelect(String id) {
        return this.getKey().generateSelect(id);
    }

    public String generateJavaSelect(String id) {
        return this.getKey().generateJavaSelect(id);
    }

    public String generateLoadSelect(String id) {
        return null;
    }

    public String generateGetProxyKey(String value) {
        return "((" + this.getForeignTypeName() + ") " + value + ".getPrimaryKey())";
    }

    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateLoadFromObject(out, obj);
        }
    }

    public String generateGet(String obj) {
        return this.getKey().generateGet(obj);
    }

    public void generateSet(JavaWriter out, String obj, String value) throws IOException {
        IdField key = this.getKey();
        key.generateSet(out, obj, key.toValue(value));
    }

    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateUpdateFromObject(out, obj);
        }
    }

    public String generateMatchArgWhere(String id) {
        CharBuffer cb = new CharBuffer();
        boolean isFirst = true;
        for (IdField field : this.getKeys()) {
            for (AmberColumn column : field.getColumns()) {
                if (!isFirst) {
                    cb.append(" and ");
                }
                isFirst = false;
                cb.append(column.generateMatchArgWhere(id));
            }
        }
        return cb.toString();
    }

    public String generateRawWhere(String id) {
        ArrayList<IdField> keys = this.getKeys();
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(" and ");
            }
            cb.append(keys.get(i).generateRawWhere(id));
        }
        return cb.close();
    }

    public String generateCreateTableSQL(AmberPersistenceUnit manager) {
        String sql = this.getKey().generateCreateTableSQL(manager);
        if (this.getKey().getGenerator() != null) {
            return sql + " PRIMARY KEY auto_increment";
        }
        return sql + " PRIMARY KEY";
    }

    public void generateSetKey(JavaWriter out, String pstmt, String index, String keyObject) throws IOException {
        IdField key = this.getKey();
        key.getType().generateSet(out, pstmt, index, keyObject);
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateStatementSet(out, pstmt, index, value);
        }
    }

    public void generateStatementSet(JavaWriter out, String pstmt, String index) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateStatementSet(out, pstmt, index);
        }
    }

    public void generateSetInsert(JavaWriter out, String pstmt, String index) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateSetInsert(out, pstmt, index);
        }
    }

    public String generateCastFromObject(String value) {
        return value;
    }

    public void generateMatch(JavaWriter out, String key) throws IOException {
        IdField id = this.getKeys().get(0);
        out.println("return (" + id.generateEquals(id.generateSuperGetter("this"), id.toValue(key)) + ");");
    }

    public String generateEquals(String leftBase, String value) {
        ArrayList<IdField> keys = this.getKeys();
        String eq = "(";
        for (int i = 0; i < keys.size(); ++i) {
            IdField key = keys.get(i);
            if (i != 0) {
                eq = eq + " && ";
            }
            eq = eq + key.generateEquals(leftBase, value);
        }
        return eq + ")";
    }

    public void generateCheckCreateKey(JavaWriter out) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateCheckCreateKey(out);
        }
    }

    public void generateSetGeneratedKeys(JavaWriter out, String pstmt) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateSetGeneratedKeys(out, pstmt);
        }
    }

    public EmbeddedIdField getEmbeddedIdField() {
        return null;
    }

    public boolean isEmbeddedId() {
        return false;
    }

    public String toObject(String value) {
        return this.getKey().toObject(value);
    }

    public Object toObjectKey(long value) {
        return new Long(value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return null;
    }
}

