/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AmberColumnExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.IdExpr;
import com.caucho.amber.expr.JoinExpr;
import com.caucho.amber.expr.KeyColumnExpr;
import com.caucho.amber.expr.ManyToOneJoinExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.util.CharBuffer;

public class OneToManyJoinExpr
extends JoinExpr {
    private LinkColumns _linkColumns;
    private FromItem _sourceFromItem;
    private FromItem _targetFromItem;

    public OneToManyJoinExpr(LinkColumns linkColumns, FromItem source, FromItem target) {
        this._linkColumns = linkColumns;
        this._sourceFromItem = source;
        this._targetFromItem = target;
        if (source == null || target == null) {
            throw new NullPointerException();
        }
    }

    public boolean isBoolean() {
        return true;
    }

    public AmberExpr bindSelect(QueryParser parser) {
        return this;
    }

    public boolean bindToFromItem() {
        if (this._sourceFromItem.getJoinExpr() == null || this._sourceFromItem.getJoinExpr().equals(this)) {
            this._sourceFromItem.setJoinExpr(this);
            return true;
        }
        ManyToOneJoinExpr manyToOne = new ManyToOneJoinExpr(this._linkColumns, this._sourceFromItem, this._targetFromItem);
        if (this._targetFromItem.getJoinExpr() == null || this._targetFromItem.getJoinExpr().equals(manyToOne)) {
            this._targetFromItem.setJoinExpr(manyToOne);
            return true;
        }
        return false;
    }

    public FromItem getJoinTarget() {
        return this._targetFromItem;
    }

    public FromItem getJoinParent() {
        return this._targetFromItem;
    }

    public AmberExpr replace(KeyColumnExpr id) {
        PathExpr parent = id.getParent();
        if (parent.getChildFromItem() != this._targetFromItem) {
            return id;
        }
        ForeignColumn sourceColumn = this._linkColumns.getSourceColumn(id.getColumn());
        if (sourceColumn == null) {
            throw new IllegalStateException(id.getColumn().getName());
        }
        return new AmberColumnExpr(this._sourceFromItem.getIdExpr(), sourceColumn);
    }

    public AmberExpr replace(IdExpr id) {
        return id;
    }

    public AmberExpr getWhere() {
        return null;
    }

    public void generateWhere(CharBuffer cb) {
        cb.append(this._linkColumns.generateWhere(this._sourceFromItem.getName(), this._targetFromItem.getName()));
    }

    public void generateUpdateWhere(CharBuffer cb) {
        this.generateWhere(cb);
    }

    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    public void generateJoin(CharBuffer cb) {
        cb.append(this._linkColumns.generateJoin(this._sourceFromItem.getName(), this._targetFromItem.getName()));
    }

    public boolean equals(Object o) {
        if (!(o instanceof OneToManyJoinExpr)) {
            return false;
        }
        OneToManyJoinExpr joinExpr = (OneToManyJoinExpr)o;
        return this._linkColumns.equals(joinExpr._linkColumns) && this._targetFromItem.equals(joinExpr._targetFromItem) && this._sourceFromItem.equals(joinExpr._sourceFromItem);
    }

    public String toString() {
        return "OneToManyJoinExpr[" + this._linkColumns + "," + this._targetFromItem + "," + this._sourceFromItem + "]";
    }
}

