/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractAmberExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.JoinExpr;
import com.caucho.amber.expr.ManyToOneExpr;
import com.caucho.amber.expr.OneToManyExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.LinkColumns;
import com.caucho.util.CharBuffer;

public class EmptyExpr
extends AbstractAmberExpr {
    private AmberExpr _collectionExpr;
    private String _tableName;

    public EmptyExpr(AmberExpr collectionExpr) {
        this._collectionExpr = collectionExpr;
    }

    public boolean isBoolean() {
        return true;
    }

    public AmberExpr bindSelect(QueryParser parser) {
        this._tableName = parser.createTableName();
        return this;
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        return this._collectionExpr.usesFrom(from, type);
    }

    public AmberExpr replaceJoin(JoinExpr join) {
        this._collectionExpr = this._collectionExpr.replaceJoin(join);
        return this;
    }

    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    private void generateInternalWhere(CharBuffer cb, boolean select) {
        OneToManyExpr oneToMany = null;
        if (this._collectionExpr instanceof ManyToOneExpr) {
            PathExpr expr = ((ManyToOneExpr)this._collectionExpr).getParent();
            if (expr instanceof OneToManyExpr) {
                oneToMany = (OneToManyExpr)expr;
            }
        } else if (this._collectionExpr instanceof OneToManyExpr) {
            oneToMany = (OneToManyExpr)this._collectionExpr;
        } else {
            throw new UnsupportedOperationException();
        }
        LinkColumns join = oneToMany.getLinkColumns();
        AmberTable table = join.getSourceTable();
        cb.append("EXISTS(SELECT ");
        if (table.getIdColumns().size() > 0) {
            cb.append(table.getIdColumns().get(0).getName());
        } else {
            cb.append('*');
        }
        cb.append(" FROM " + table.getName() + " " + this._tableName);
        cb.append(" WHERE ");
        String targetTable = oneToMany.getParent().getChildFromItem().getName();
        cb.append(join.generateJoin(this._tableName, targetTable));
        cb.append(')');
    }
}

