/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractPathExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.EmbeddedSubField;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedExpr
extends AbstractPathExpr {
    private PathExpr _parent;
    private EmbeddableType _embeddableType;
    private ArrayList<EmbeddedSubField> _subFields;
    private FromItem _fromItem;
    private FromItem _childFromItem;

    public EmbeddedExpr(PathExpr parent, EmbeddableType embeddableType, ArrayList<EmbeddedSubField> subFields) {
        this._parent = parent;
        this._embeddableType = embeddableType;
        this._subFields = subFields;
    }

    @Override
    public EmbeddableType getTargetType() {
        return this._embeddableType;
    }

    @Override
    public AmberType getType() {
        return this._embeddableType;
    }

    public AmberColumn getColumnByFieldName(String fieldName) {
        for (int i = 0; i < this._subFields.size(); ++i) {
            EmbeddedSubField subField = this._subFields.get(i);
            if (!subField.getName().equals(fieldName)) continue;
            return subField.getColumn();
        }
        return null;
    }

    @Override
    public AmberExpr bindSelect(QueryParser parser) {
        this._fromItem = this._parent.bindSubPath(parser);
        return this;
    }

    public FromItem getFromItem() {
        return this._fromItem;
    }

    @Override
    public FromItem getChildFromItem() {
        return this._childFromItem;
    }

    @Override
    public FromItem bindSubPath(QueryParser parser) {
        FromItem parentFromItem;
        this._fromItem = parentFromItem = this._parent.bindSubPath(parser);
        return this._fromItem;
    }

    @Override
    public PathExpr bindSelect(QueryParser parser, String id) {
        this._fromItem = this.bindSubPath(parser);
        return this;
    }

    @Override
    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        return this._childFromItem == from && type == 1 || this._fromItem == from || this._parent.usesFrom(from, type);
    }

    public void generateMatchArgWhere(CharBuffer cb) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    @Override
    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    @Override
    public void generateSelect(CharBuffer cb) {
        for (int i = 0; i < this._subFields.size(); ++i) {
            if (i > 0) {
                cb.append(", ");
            }
            cb.append(this._subFields.get(i).generateSelect(null));
        }
    }

    public PathExpr getParent() {
        return this._parent;
    }

    public int hashCode() {
        return 65521 * this._parent.hashCode() + this._subFields.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        EmbeddedExpr embedded = (EmbeddedExpr)o;
        return this._parent.equals(embedded._parent) && this._subFields.equals(embedded._subFields);
    }

    public String toString() {
        return "EmbeddedExpr[" + this._childFromItem + "," + this._fromItem + "," + this._parent + "]";
    }

    private void generateInternalWhere(CharBuffer cb, boolean select) {
        throw new UnsupportedOperationException();
    }
}

