/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractAmberExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.JoinExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.util.CharBuffer;

public class BooleanColumnExpr
extends AbstractAmberExpr {
    protected PathExpr _parent;
    private AmberColumn _column;
    protected FromItem _fromItem;

    public BooleanColumnExpr(PathExpr parent, AmberColumn column) {
        this._parent = parent;
        this._column = column;
    }

    PathExpr getParent() {
        return this._parent;
    }

    AmberColumn getColumn() {
        return this._column;
    }

    public boolean isBoolean() {
        return true;
    }

    public AmberExpr bindSelect(QueryParser parser) {
        FromItem parentFromItem = this._parent.bindSubPath(parser);
        if (parentFromItem.getTable() == this.getColumn().getTable()) {
            this._fromItem = parentFromItem;
            return this;
        }
        LinkColumns link = this.getColumn().getTable().getDependentIdLink();
        this._fromItem = parser.createDependentFromItem(parentFromItem, link);
        return this;
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        if (this._fromItem == from) {
            return true;
        }
        return this._fromItem == null && this._parent.getChildFromItem() == from;
    }

    public AmberExpr replaceJoin(JoinExpr join) {
        this._parent = (PathExpr)this._parent.replaceJoin(join);
        return this;
    }

    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    public String toString() {
        return this._parent + "." + this._column.getName();
    }

    private void generateInternalWhere(CharBuffer cb, boolean select) {
        CharBuffer term = new CharBuffer();
        if (this._fromItem != null) {
            if (select) {
                term.append(this._fromItem.getName());
                term.append('.');
            }
            term.append(this._column.getName());
        } else {
            if (select) {
                term.append(this._parent.getChildFromItem().getName());
                term.append('.');
            }
            term.append(this._column.getName());
        }
        AmberPersistenceUnit manager = this._column.getTable().getAmberManager();
        JdbcMetaData metaData = manager.getMetaData();
        cb.append(metaData.generateBoolean(term.toString()));
    }
}

