/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.AbstractRelationConfig;
import com.caucho.amber.cfg.BaseConfigIntrospector;
import com.caucho.amber.cfg.JoinColumnConfig;
import com.caucho.amber.cfg.JoinTableConfig;
import com.caucho.amber.cfg.MapKeyConfig;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.ManyToManyField;
import com.caucho.amber.field.ManyToOneField;
import com.caucho.amber.field.OneToManyField;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JType;
import com.caucho.bytecode.JTypeWrapper;
import com.caucho.util.L10N;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OneToManyConfig
extends AbstractRelationConfig {
    private static final L10N L = new L10N(OneToManyConfig.class);
    private BaseConfigIntrospector _introspector;
    private EntityType _sourceType;
    private AccessibleObject _field;
    private String _fieldName;
    private Class _fieldType;
    private String _mappedBy;
    private MapKeyConfig _mapKey;
    private String _orderBy;
    private HashMap<String, JoinColumnConfig> _joinColumnMap = new HashMap();
    private ArrayList<String> _orderByFields = null;
    private ArrayList<Boolean> _orderByAscending = null;

    OneToManyConfig(BaseConfigIntrospector introspector, EntityType sourceType, AccessibleObject field, String fieldName, Class fieldType) {
        this._introspector = introspector;
        this._sourceType = sourceType;
        this._field = field;
        this._fieldName = fieldName;
        this._fieldType = fieldType;
        this.setName(fieldName);
        this.introspect();
    }

    public String getMappedBy() {
        return this._mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this._mappedBy = mappedBy;
    }

    public MapKeyConfig getMapKey() {
        return this._mapKey;
    }

    public void setMapKey(MapKeyConfig mapKey) {
        this._mapKey = mapKey;
    }

    public String getOrderBy() {
        return this._orderBy;
    }

    public void setOrderBy(String orderBy) {
        this._orderBy = orderBy;
    }

    public boolean isOwningSide() {
        return "".equals(this._mappedBy);
    }

    private void introspect() {
        JoinTable joinTableAnn;
        this.introspectTypes();
        OneToMany oneToMany = this._field.getAnnotation(OneToMany.class);
        if (oneToMany != null) {
            this.introspectOneToMany(oneToMany);
        }
        if ((joinTableAnn = this._field.getAnnotation(JoinTable.class)) != null) {
            this.setJoinTable(new JoinTableConfig(joinTableAnn));
        }
        JoinColumn joinColumnAnn = this._field.getAnnotation(JoinColumn.class);
        JoinColumns joinColumnsAnn = this._field.getAnnotation(JoinColumns.class);
        if (joinColumnsAnn != null && joinColumnAnn != null) {
            throw OneToManyConfig.error(this._field, L.l("{0} may not have both @JoinColumn and @JoinColumns", (Object)this._fieldName));
        }
        if (joinColumnsAnn != null) {
            this.introspectJoinColumns(joinColumnsAnn.value());
        } else if (joinColumnAnn != null) {
            this.introspectJoinColumns(new JoinColumn[]{joinColumnAnn});
        }
        OrderBy orderByAnn = this._field.getAnnotation(OrderBy.class);
        if (orderByAnn != null) {
            this._orderBy = orderByAnn.value();
        }
    }

    private void introspectTypes() {
        ClassLoader loader;
        Type retType = this._field instanceof Field ? ((Field)this._field).getGenericType() : ((Method)this._field).getGenericReturnType();
        JType type = JTypeWrapper.create(retType, loader = this._sourceType.getPersistenceUnit().getTempClassLoader());
        JType[] typeArgs = type.getActualTypeArguments();
        if (typeArgs.length > 0) {
            this.setTargetEntity(typeArgs[0].getRawType().getJavaClass());
        }
    }

    private void introspectOneToMany(OneToMany oneToMany) {
        Class targetClass = oneToMany.targetEntity();
        if (!Void.TYPE.equals(targetClass)) {
            this.setTargetEntity(targetClass);
        }
        this.setCascadeTypes(oneToMany.cascade());
        this.setFetch(oneToMany.fetch());
        this._mappedBy = oneToMany.mappedBy();
    }

    private void introspectJoinColumns(JoinColumn[] joinColumns) {
        for (JoinColumn joinColumn : joinColumns) {
            this.addJoinColumn(new JoinColumnConfig(joinColumn));
        }
    }

    private void calculateOrderBy(String orderBy) {
        this._orderByFields = new ArrayList();
        this._orderByAscending = new ArrayList();
        int len = orderBy.length();
        int i = 0;
        while (i < len) {
            int index = orderBy.indexOf(",", i);
            if (index < 0) {
                index = len;
            }
            String orderByField = orderBy.substring(i, index);
            i += index;
            index = orderByField.toUpperCase(Locale.ENGLISH).lastIndexOf("SC");
            Boolean asc = Boolean.TRUE;
            if (index > 1) {
                if (orderByField.charAt(index - 1) != 'E') {
                    if (orderByField.charAt(index - 1) == 'A' && Character.isSpaceChar(orderByField.charAt(index - 2))) {
                        index -= 2;
                    }
                } else if (index > 2 && orderByField.charAt(index - 2) == 'D' && Character.isSpaceChar(orderByField.charAt(index - 3))) {
                    asc = Boolean.FALSE;
                    index -= 3;
                }
            }
            if (index > 0) {
                orderByField = orderByField.substring(0, index).trim();
            }
            this._orderByFields.add(orderByField);
            this._orderByAscending.add(asc);
        }
    }

    public JoinColumnConfig getJoinColumn(String name) {
        return this._joinColumnMap.get(name);
    }

    public void addJoinColumn(JoinColumnConfig joinColumn) {
        this._joinColumnMap.put(joinColumn.getName(), joinColumn);
    }

    public HashMap<String, JoinColumnConfig> getJoinColumnMap() {
        return this._joinColumnMap;
    }

    @Override
    public EntityType getRelatedType() {
        return this._sourceType;
    }

    @Override
    public void complete() {
        AmberPersistenceUnit persistenceUnit = this._sourceType.getPersistenceUnit();
        Class targetEntity = this.getTargetEntity();
        if (targetEntity == null) {
            throw OneToManyConfig.error(this._field, L.l("Can't determine targetEntity for {0}.  @OneToMany properties must target @Entity beans.", (Object)this._fieldName));
        }
        EntityType targetType = persistenceUnit.getEntityType(targetEntity);
        if (targetType == null) {
            throw OneToManyConfig.error(this._field, L.l("targetEntity '{0}' is not an @Entity bean for {1}.  The targetEntity of a @OneToMany collection must be an @Entity bean.", (Object)targetEntity.getName(), (Object)this._fieldName));
        }
        if (this._orderBy != null) {
            this.calculateOrderBy(this._orderBy);
        }
        if (!this.isOwningSide()) {
            this.oneToManyBidirectional(targetType);
        } else {
            this.oneToManyUnidirectional(targetType);
        }
    }

    private void oneToManyBidirectional(EntityType targetType) {
        JoinTableConfig joinTableConfig = this.getJoinTable();
        if (joinTableConfig != null) {
            throw OneToManyConfig.error(this._field, L.l("Bidirectional @ManyToOne property {0} may not have a @JoinTable annotation.", (Object)this._fieldName));
        }
        String mappedBy = this.getMappedBy();
        ManyToOneField sourceField = this.getSourceField(targetType, mappedBy, null);
        if (sourceField == null) {
            throw OneToManyConfig.error(this._field, L.l("'{1}' is an unknown column in '{0}' for @ManyToOne(mappedBy={1}).", (Object)targetType.getName(), (Object)mappedBy));
        }
        OneToManyField oneToMany = new OneToManyField(this._sourceType, this._fieldName, this.getCascade());
        oneToMany.setSourceField(sourceField);
        oneToMany.setOrderBy(this._orderByFields, this._orderByAscending);
        oneToMany.setLazy(this.isFetchLazy());
        this._sourceType.addField(oneToMany);
    }

    private void oneToManyUnidirectional(EntityType targetType) {
        ManyToManyField manyToManyField = new ManyToManyField(this._sourceType, this._fieldName, this.getCascade());
        manyToManyField.setType(targetType);
        String sqlTable = this._sourceType.getTable().getName() + "_" + targetType.getTable().getName();
        JoinTable joinTableAnn = this._field.getAnnotation(JoinTable.class);
        JoinTableConfig joinTableConfig = this.getJoinTable();
        AmberTable mapTable = null;
        ArrayList<ForeignColumn> sourceColumns = null;
        ArrayList<ForeignColumn> targetColumns = null;
        AmberPersistenceUnit persistenceUnit = this._sourceType.getPersistenceUnit();
        if (joinTableConfig != null) {
            HashMap<String, JoinColumnConfig> joinColumnsConfig = null;
            HashMap<String, JoinColumnConfig> inverseJoinColumnsConfig = null;
            if (!joinTableConfig.getName().equals("")) {
                sqlTable = joinTableConfig.getName();
            }
            joinColumnsConfig = joinTableConfig.getJoinColumnMap();
            inverseJoinColumnsConfig = joinTableConfig.getInverseJoinColumnMap();
            mapTable = persistenceUnit.createTable(sqlTable);
            sourceColumns = this.calculateColumns(this._field, this._fieldName, mapTable, this._sourceType.getTable().getName() + "_", this._sourceType, joinColumnsConfig);
            targetColumns = this.calculateColumns(this._field, this._fieldName, mapTable, targetType.getTable().getName() + "_", targetType, inverseJoinColumnsConfig);
        } else {
            mapTable = persistenceUnit.createTable(sqlTable);
            sourceColumns = OneToManyConfig.calculateColumns(mapTable, this._sourceType.getTable().getName() + "_", this._sourceType);
            targetColumns = OneToManyConfig.calculateColumns(mapTable, OneToManyConfig.toSqlName(this._fieldName) + "_", targetType);
        }
        manyToManyField.setAssociationTable(mapTable);
        manyToManyField.setTable(sqlTable);
        manyToManyField.setSourceLink(new LinkColumns(mapTable, this._sourceType.getTable(), sourceColumns));
        manyToManyField.setTargetLink(new LinkColumns(mapTable, targetType.getTable(), targetColumns));
        this._sourceType.addField(manyToManyField);
    }

    ManyToOneField getSourceField(EntityType targetType, String mappedBy, EntityType sourceType) {
        do {
            ArrayList<AmberField> fields = targetType.getFields();
            for (AmberField field : fields) {
                if (!("".equals(mappedBy) || mappedBy == null ? field.getJavaType().isAssignableFrom(sourceType.getBeanClass()) : field.getName().equals(mappedBy))) continue;
                return (ManyToOneField)field;
            }
        } while ((targetType = targetType.getParentType()) != null);
        return null;
    }
}

