/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.BaseConfigIntrospector;
import com.caucho.amber.cfg.ColumnConfig;
import com.caucho.amber.cfg.CompletionImpl;
import com.caucho.amber.field.AbstractField;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributeOverrideCompletion
extends CompletionImpl {
    private static final L10N L = new L10N(AttributeOverrideCompletion.class);
    private Class _type;
    private HashMap<String, ColumnConfig> _overrideMap;

    AttributeOverrideCompletion(BaseConfigIntrospector base, EntityType entityType, Class type, HashMap<String, ColumnConfig> overrideMap) {
        super(base, entityType);
        this._type = type;
        this._overrideMap = overrideMap;
    }

    @Override
    public void complete() throws ConfigException {
        EntityType parent = this._entityType.getParentType();
        ArrayList<AmberField> fields = parent.getFields();
        for (AmberField field : fields) {
            this._entityType.addField(this.overrideField(field));
        }
        Id parentId = parent.getId();
        Id id = this._entityType.getId();
        if (parentId != null) {
            ArrayList<IdField> keys = parentId.getKeys();
            ArrayList<IdField> mappedKeys = new ArrayList<IdField>();
            for (IdField key : keys) {
                mappedKeys.add((IdField)this.overrideField(key));
            }
            id = new Id(this._entityType, mappedKeys);
            this._entityType.setId(id);
        }
    }

    private AmberField overrideField(AmberField field) {
        String fieldName = field.getName();
        ColumnConfig column = this._overrideMap.get(fieldName);
        AmberColumn oldColumn = field.getColumn();
        AbstractField newField = (AbstractField)field.override(this._entityType);
        if (column != null) {
            AmberTable table = this._entityType.getTable();
            AmberColumn newColumn = table.createColumn(column.getName(), oldColumn.getType());
            newField.setColumn(newColumn);
            newField.init();
            return newField;
        }
        AmberTable table = this._entityType.getTable();
        AmberColumn newColumn = table.createColumn(oldColumn.getName(), oldColumn.getType());
        newField.setColumn(newColumn);
        newField.init();
        return newField;
    }
}

