/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.compiler.XMLProcessor;
import org.eclipse.persistence.jaxb.metadata.MetadataSource;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JAXBContextFactory {
    private static final ValidationEventHandler JSON_BINDING_DOCUMENT_VEH = new DefaultValidationEventHandler();
    @Deprecated
    public static final String ECLIPSELINK_OXM_XML_KEY = "eclipselink-oxm-xml";
    @Deprecated
    public static final String DEFAULT_TARGET_NAMESPACE_KEY = "defaultTargetNamespace";
    @Deprecated
    public static final String ANNOTATION_HELPER_KEY = "annotationHelper";
    public static final String PKG_SEPARATOR = ".";

    public static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties) throws JAXBException {
        ClassLoader loader = null;
        if (classesToBeBound.length > 0) {
            loader = classesToBeBound[0].getClassLoader();
        }
        return JAXBContextFactory.createContext(classesToBeBound, properties, loader);
    }

    public static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        Type[] types = new Type[classesToBeBound.length];
        System.arraycopy(classesToBeBound, 0, types, 0, classesToBeBound.length);
        return JAXBContextFactory.createContext(types, properties, classLoader);
    }

    public static javax.xml.bind.JAXBContext createContext(String contextPath, ClassLoader classLoader) throws JAXBException {
        return JAXBContextFactory.createContext(contextPath, classLoader, null);
    }

    public static javax.xml.bind.JAXBContext createContext(String contextPath, ClassLoader classLoader, Map properties) throws JAXBException {
        JAXBContext.ContextPathInput contextInput = new JAXBContext.ContextPathInput(contextPath, properties, classLoader);
        JAXBContext context = new JAXBContext(contextInput);
        if (context.isRefreshable()) {
            context.postInitialize();
        }
        return context;
    }

    public static javax.xml.bind.JAXBContext createContext(Type[] typesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        HashMap<Type, TypeMappingInfo> typeToTypeMappingInfo = new HashMap<Type, TypeMappingInfo>();
        TypeMappingInfo[] typeMappingInfo = new TypeMappingInfo[typesToBeBound.length];
        int i = 0;
        while (i < typesToBeBound.length) {
            TypeMappingInfo tmi = new TypeMappingInfo();
            tmi.setType(typesToBeBound[i]);
            typeToTypeMappingInfo.put(typesToBeBound[i], tmi);
            typeMappingInfo[i] = tmi;
            ++i;
        }
        JAXBContext context = (JAXBContext)JAXBContextFactory.createContext(typeMappingInfo, properties, classLoader);
        context.setTypeToTypeMappingInfo(typeToTypeMappingInfo);
        return context;
    }

    public static javax.xml.bind.JAXBContext createContext(TypeMappingInfo[] typesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        JAXBContext.TypeMappingInfoInput contextInput = new JAXBContext.TypeMappingInfoInput(typesToBeBound, properties, classLoader);
        JAXBContext context = new JAXBContext(contextInput);
        if (context.isRefreshable()) {
            context.postInitialize();
        }
        return context;
    }

    public static Map<String, XmlBindings> getXmlBindingsFromProperties(Map properties, ClassLoader classLoader) {
        Map<String, List<XmlBindings>> bindings = new HashMap<String, List<XmlBindings>>();
        Object value = null;
        if (properties != null) {
            Object v = properties.get("eclipselink.oxm.metadata-source");
            value = v;
            if (v == null) {
                value = properties.get(ECLIPSELINK_OXM_XML_KEY);
            }
        }
        if (value != null) {
            if (value instanceof Map) {
                Map metadataFiles = null;
                try {
                    metadataFiles = value;
                }
                catch (ClassCastException classCastException) {
                    throw org.eclipse.persistence.exceptions.JAXBException.incorrectValueParameterTypeForOxmXmlKey();
                }
                if (metadataFiles != null) {
                    for (Map.Entry entry : metadataFiles.entrySet()) {
                        String key = null;
                        ArrayList<XmlBindings> xmlBindings = new ArrayList<XmlBindings>();
                        try {
                            key = (String)entry.getKey();
                            if (key == null) {
                                throw org.eclipse.persistence.exceptions.JAXBException.nullMapKey();
                            }
                        }
                        catch (ClassCastException classCastException) {
                            throw org.eclipse.persistence.exceptions.JAXBException.incorrectKeyParameterType();
                        }
                        Object metadataSource = entry.getValue();
                        if (metadataSource == null) {
                            throw org.eclipse.persistence.exceptions.JAXBException.nullMetadataSource(key);
                        }
                        if (metadataSource instanceof List) {
                            for (Object next : (List)metadataSource) {
                                XmlBindings binding = JAXBContextFactory.getXmlBindings(next, classLoader, properties);
                                if (binding == null) continue;
                                xmlBindings.add(binding);
                            }
                        } else {
                            XmlBindings binding = JAXBContextFactory.getXmlBindings(metadataSource, classLoader, properties);
                            if (binding != null) {
                                xmlBindings.add(binding);
                            }
                        }
                        if (xmlBindings == null) continue;
                        bindings.put(key, xmlBindings);
                    }
                }
            } else if (value instanceof List) {
                for (Object metadataSource : (List)value) {
                    if (metadataSource == null) {
                        throw org.eclipse.persistence.exceptions.JAXBException.nullMetadataSource();
                    }
                    bindings = JAXBContextFactory.processBindingFile(bindings, metadataSource, classLoader, properties);
                }
            } else {
                bindings = JAXBContextFactory.processBindingFile(bindings, value, classLoader, properties);
            }
        }
        HashMap<String, XmlBindings> mergedBindings = new HashMap<String, XmlBindings>(bindings.size());
        for (Map.Entry entry : bindings.entrySet()) {
            mergedBindings.put((String)entry.getKey(), XMLProcessor.mergeXmlBindings((List)entry.getValue()));
        }
        return mergedBindings;
    }

    private static Map<String, List<XmlBindings>> processBindingFile(Map<String, List<XmlBindings>> originalBindings, Object bindingHandle, ClassLoader classLoader, Map<String, Object> properties) {
        Map<String, List<XmlBindings>> bindingMap = originalBindings;
        XmlBindings binding = JAXBContextFactory.getXmlBindings(bindingHandle, classLoader, properties);
        if (binding != null) {
            String key = binding.getPackageName();
            if (key.equals("##default")) {
                throw org.eclipse.persistence.exceptions.JAXBException.packageNotSetForBindingException();
            }
            List<XmlBindings> existingBindings = bindingMap.get(key);
            if (existingBindings != null) {
                existingBindings.add(binding);
            } else {
                existingBindings = new ArrayList<XmlBindings>();
                existingBindings.add(binding);
                bindingMap.put(key, existingBindings);
            }
        }
        return bindingMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static XmlBindings getXmlBindings(Object metadata, ClassLoader classLoader, Map<String, Object> properties) {
        JAXBContext jaxbContext = CompilerHelper.getXmlBindingsModelContext();
        BufferedReader metadataBufferedReader = null;
        try {
            JAXBUnmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            if (metadata instanceof File) {
                metadataBufferedReader = new BufferedReader(new FileReader((File)metadata));
            } else if (metadata instanceof InputSource) {
                if (((InputSource)metadata).getByteStream() != null) {
                    metadataBufferedReader = new BufferedReader(new InputStreamReader(((InputSource)metadata).getByteStream()));
                } else if (((InputSource)metadata).getCharacterStream() != null) {
                    metadataBufferedReader = new BufferedReader(((InputSource)metadata).getCharacterStream());
                }
            } else if (metadata instanceof InputStream) {
                metadataBufferedReader = new BufferedReader(new InputStreamReader((InputStream)metadata));
            } else {
                if (metadata instanceof Node) {
                    return (XmlBindings)unmarshaller.unmarshal((Node)metadata);
                }
                if (metadata instanceof Reader) {
                    metadataBufferedReader = new BufferedReader((Reader)metadata);
                } else if (metadata instanceof Source) {
                    Source source = (Source)metadata;
                    if (source instanceof StreamSource) {
                        StreamSource ss = (StreamSource)metadata;
                        if (ss.getInputStream() != null) {
                            metadataBufferedReader = new BufferedReader(new InputStreamReader(ss.getInputStream()));
                        } else if (ss.getReader() != null) {
                            metadataBufferedReader = new BufferedReader(ss.getReader());
                        } else if (ss.getSystemId() != null) {
                            URL url = JAXBContextFactory.getURLFromString(ss.getSystemId(), classLoader);
                            if (url == null) throw org.eclipse.persistence.exceptions.JAXBException.unableToLoadMetadataFromLocation((String)metadata);
                            metadataBufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
                        }
                    } else {
                        if (source instanceof DOMSource) {
                            return (XmlBindings)unmarshaller.unmarshal((DOMSource)source);
                        }
                        if (source instanceof SAXSource) {
                            return (XmlBindings)unmarshaller.unmarshal((SAXSource)source);
                        }
                    }
                } else if (metadata instanceof URL) {
                    metadataBufferedReader = new BufferedReader(new InputStreamReader(((URL)metadata).openStream()));
                } else {
                    if (metadata instanceof XMLEventReader) {
                        return (XmlBindings)unmarshaller.unmarshal((XMLEventReader)metadata);
                    }
                    if (metadata instanceof XMLStreamReader) {
                        return (XmlBindings)unmarshaller.unmarshal((XMLStreamReader)metadata);
                    }
                    if (metadata instanceof MetadataSource) {
                        return ((MetadataSource)metadata).getXmlBindings(properties, classLoader);
                    }
                    if (!(metadata instanceof String)) throw org.eclipse.persistence.exceptions.JAXBException.incorrectValueParameterTypeForOxmXmlKey();
                    URL url = JAXBContextFactory.getURLFromString((String)metadata, classLoader);
                    if (url == null) throw org.eclipse.persistence.exceptions.JAXBException.unableToLoadMetadataFromLocation((String)metadata);
                    metadataBufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
                }
            }
            if (metadataBufferedReader == null) throw org.eclipse.persistence.exceptions.JAXBException.incorrectValueParameterTypeForOxmXmlKey();
            boolean isJSON = JAXBContextFactory.isJSONFormat(metadataBufferedReader);
            StreamSource metadataSource = new StreamSource(metadataBufferedReader);
            if (!isJSON) return JAXBContextFactory.getXmlBindingsByMediaType(unmarshaller, metadataSource, classLoader, properties, "application/xml");
            return JAXBContextFactory.getXmlBindingsByMediaType(unmarshaller, metadataSource, classLoader, properties, "application/json");
        }
        catch (IOException ioException) {
            throw org.eclipse.persistence.exceptions.JAXBException.couldNotUnmarshalMetadata(ioException);
        }
        catch (JAXBException ex) {
            throw org.eclipse.persistence.exceptions.JAXBException.couldNotUnmarshalMetadata((Exception)((Object)ex));
        }
    }

    private static boolean isJSONFormat(BufferedReader reader) throws IOException {
        boolean isJSONFormat = false;
        int readAheadLimit = 5;
        reader.mark(readAheadLimit);
        int i = 0;
        while (i < readAheadLimit) {
            if (!reader.ready()) break;
            char c = (char)reader.read();
            if (c == '[') {
                isJSONFormat = true;
                break;
            }
            if (c == '{') {
                isJSONFormat = true;
                break;
            }
            ++i;
        }
        reader.reset();
        return isJSONFormat;
    }

    private static URL getURLFromString(String stringValue, ClassLoader classLoader) {
        if (stringValue.length() == 0) {
            throw org.eclipse.persistence.exceptions.JAXBException.unableToLoadMetadataFromLocation(stringValue);
        }
        URL url = null;
        try {
            url = new URL(stringValue);
        }
        catch (MalformedURLException malformedURLException) {
            url = classLoader.getResource(stringValue);
        }
        return url;
    }

    private static XmlBindings getXmlBindingsByMediaType(Unmarshaller unmarshaller, Source metadata, ClassLoader classLoader, Map<String, Object> properties, String mediaType) throws JAXBException {
        if ("application/xml".equals(mediaType)) {
            unmarshaller.setEventHandler(JSON_BINDING_DOCUMENT_VEH);
        } else {
            unmarshaller.setEventHandler(JAXBContext.DEFAULT_VALIDATION_EVENT_HANDER);
        }
        unmarshaller.setProperty("eclipselink.media-type", (Object)mediaType);
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
        JAXBElement jbe = unmarshaller.unmarshal(metadata, XmlBindings.class);
        return (XmlBindings)jbe.getValue();
    }
}

