/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.xtpdoc.AbstractContentItem;
import com.caucho.xtpdoc.Document;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class VerboseText
extends AbstractContentItem {
    private Logger log = Logger.getLogger(VerboseText.class.getName());
    private String _text;
    private Document _document;

    public VerboseText(String text, Document document) {
        this._text = text;
        this._document = document;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        out.writeCharacters(this._text);
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        StringReader stringReader = new StringReader(this._text);
        LineNumberReader lineReader = new LineNumberReader(stringReader);
        String line = lineReader.readLine();
        while (line != null) {
            if (line.length() > 70) {
                this.log.warning("lines longer than 70 characters will not work in LaTeX");
                this.log.warning(line);
                this.log.warning("document: " + this._document.getDocumentPath());
            }
            line = lineReader.readLine();
        }
        out.print(this._text);
    }

    public void writeLaTeXVerbatim(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
        this.escapeAsciiDoc(out, this._text, true);
    }
}

