/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.xtpdoc.BlockQuote;
import com.caucho.xtpdoc.Center;
import com.caucho.xtpdoc.ContainerNode;
import com.caucho.xtpdoc.Def;
import com.caucho.xtpdoc.DefinitionList;
import com.caucho.xtpdoc.DefinitionTable;
import com.caucho.xtpdoc.Defun;
import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.Example;
import com.caucho.xtpdoc.Figure;
import com.caucho.xtpdoc.FormattedText;
import com.caucho.xtpdoc.FormattedTextWithAnchors;
import com.caucho.xtpdoc.Glossary;
import com.caucho.xtpdoc.IncludeDefun;
import com.caucho.xtpdoc.NamedText;
import com.caucho.xtpdoc.Note;
import com.caucho.xtpdoc.OrderedList;
import com.caucho.xtpdoc.Paragraph;
import com.caucho.xtpdoc.PreFormattedText;
import com.caucho.xtpdoc.Table;
import com.caucho.xtpdoc.UnorderedList;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class Section
extends ContainerNode {
    protected FormattedTextWithAnchors _description;
    protected String _name;
    protected String _title;
    protected String _version;
    protected String _type;
    private String _parentHref;

    public Section(Document document) {
        this(document, "");
    }

    public Section(Document document, String parentHref) {
        super(document);
        this._parentHref = parentHref;
    }

    public void setOccur(String occur) {
    }

    public void setLocalTOCIndent(String localTOCIndent) {
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setProduct(String product) {
    }

    public void setIndex(String index) {
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getName() {
        return this._name;
    }

    public String getTitle() {
        return this._title;
    }

    public String getHref() {
        if (this._name != null) {
            return Section.cleanHref(this._name);
        }
        return Section.cleanHref(this._title);
    }

    public static String cleanHref(String href) {
        if (href == null) {
            return href;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < href.length(); ++i) {
            char ch = href.charAt(i);
            if (!Character.isLetterOrDigit(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public Defun createDefun() {
        Defun defun = new Defun(this.getDocument());
        this.addItem(defun);
        return defun;
    }

    public IncludeDefun createIncludeDefun() {
        IncludeDefun includeDefun = new IncludeDefun(this.getDocument());
        this.addItem(includeDefun);
        return includeDefun;
    }

    public DefinitionList createDl() {
        DefinitionList list = new DefinitionList(this.getDocument());
        this.addItem(list);
        return list;
    }

    public FormattedTextWithAnchors createDescription() {
        this._description = new FormattedTextWithAnchors(this.getDocument());
        return this._description;
    }

    public BlockQuote createBlockquote() {
        BlockQuote blockQuote = new BlockQuote(this.getDocument());
        this.addItem(blockQuote);
        return blockQuote;
    }

    public Center createCenter() {
        Center center = new Center(this.getDocument());
        this.addItem(center);
        return center;
    }

    public Paragraph createP() {
        Paragraph paragraph = new Paragraph(this.getDocument());
        this.addItem(paragraph);
        return paragraph;
    }

    public PreFormattedText createPre() {
        PreFormattedText pretext = new PreFormattedText(this.getDocument());
        this.addItem(pretext);
        return pretext;
    }

    public OrderedList createOl() {
        OrderedList orderedList = new OrderedList(this.getDocument());
        this.addItem(orderedList);
        return orderedList;
    }

    public UnorderedList createUl() {
        UnorderedList unorderedList = new UnorderedList(this.getDocument());
        this.addItem(unorderedList);
        return unorderedList;
    }

    public Figure createFigure() {
        Figure figure = new Figure(this.getDocument());
        this.addItem(figure);
        return figure;
    }

    public Example createExample() {
        Example example = new Example(this.getDocument());
        this.addItem(example);
        return example;
    }

    public Table createTable() {
        Table table = new Table(this.getDocument());
        this.addItem(table);
        return table;
    }

    public DefinitionTable createDeftable() {
        DefinitionTable definitionTable = new DefinitionTable(this.getDocument());
        this.addItem(definitionTable);
        return definitionTable;
    }

    public DefinitionTable createDeftableChildtags() {
        DefinitionTable definitionTable = new DefinitionTable(this.getDocument());
        this.addItem(definitionTable);
        return definitionTable;
    }

    public DefinitionTable createDeftableParameters() {
        DefinitionTable definitionTable = new DefinitionTable(this.getDocument());
        this.addItem(definitionTable);
        return definitionTable;
    }

    public Example createResults() {
        Example results = new Example(this.getDocument());
        this.addItem(results);
        return results;
    }

    public Def createDef() {
        Def def = new Def(this.getDocument());
        this.addItem(def);
        return def;
    }

    public FormattedTextWithAnchors createNote() {
        Note note = new Note(this.getDocument());
        this.addItem(note);
        return note;
    }

    public FormattedTextWithAnchors createWarn() {
        FormattedTextWithAnchors warning = new FormattedTextWithAnchors(this.getDocument());
        this.addItem(new NamedText("Warning", warning));
        return warning;
    }

    public FormattedText createParents() {
        FormattedText parents = new FormattedText(this.getDocument());
        this.addItem(new NamedText("child of", parents));
        return parents;
    }

    public FormattedText createDefault() {
        FormattedText def = new FormattedText(this.getDocument());
        this.addItem(new NamedText("default", def));
        return def;
    }

    public Glossary createGlossary() {
        Glossary glossary = new Glossary(this.getDocument());
        this.addItem(glossary);
        return glossary;
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    protected void writeLaTeXLabel(PrintWriter out) {
        String fileName = this.getDocument().getDocumentPath().getUserPath();
        String label = fileName + ":" + this._title;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < label.length(); ++i) {
            char ch = label.charAt(i);
            if (ch == ' ') {
                sb.append('-');
                continue;
            }
            if (ch == '<' || ch == '>') continue;
            sb.append(ch);
        }
        label = sb.toString();
        out.println("\\label{" + label + "}");
        out.println("\\hypertarget{" + label + "}{}");
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        if (this.isWebOnly()) {
            return;
        }
        this.writeLaTeXLabel(out);
        super.writeLaTeX(out);
        if (this._type != null && this._type.equals("defun")) {
            out.println("\\newpage");
        }
    }

    public abstract void writeLaTeXEnclosed(PrintWriter var1) throws IOException;

    public void writeAsciiDoc(PrintWriter out) throws IOException {
        if (this.isWebOnly()) {
            return;
        }
        super.writeAsciiDoc(out);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getTitle() + "]";
    }
}

