/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.xtpdoc.ContentItem;
import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.LaTeXUtil;
import com.caucho.xtpdoc.S3;
import com.caucho.xtpdoc.Section;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class S2
extends Section {
    public S2(Document document, String parentHref) {
        super(document, parentHref);
    }

    public S3 createS3() {
        S3 s3 = new S3(this.getDocument(), this.getHref());
        this.addItem(s3);
        return s3;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        out.writeCharacters("\n");
        out.writeStartElement("div");
        out.writeAttribute("class", "s2");
        out.writeStartElement("a");
        out.writeAttribute("name", this.getHref());
        out.writeEndElement();
        if (this._title != null) {
            out.writeStartElement("h2");
            out.writeCharacters(this._title);
            out.writeEndElement();
        }
        for (ContentItem item : this.getItems()) {
            item.writeHtml(out);
        }
        out.writeEndElement();
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
        if (this._type != null && this._type.equals("defun")) {
            out.println("\\newpage");
        }
        if (this._title != null) {
            out.println("\\subsection{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
        }
        super.writeLaTeX(out);
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        if (this._type != null && this._type.equals("defun")) {
            out.println("\\newpage");
        }
        if (this._title != null) {
            if (this.isArticle()) {
                out.println("\\subsection{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
            } else {
                out.println("\\subsubsection{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
            }
        }
        super.writeLaTeX(out);
    }

    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        if (this._type != null && this._type.equals("defun")) {
            out.println("\\newpage");
        }
        if (this._title != null) {
            out.println("\\paragraph{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
        }
        super.writeLaTeX(out);
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
        out.println();
        out.println();
        out.println("==== " + this._title + " ====");
        super.writeAsciiDoc(out);
    }
}

