/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.LaTeXUtil;
import com.caucho.xtpdoc.S2;
import com.caucho.xtpdoc.Section;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class S1
extends Section {
    public S1(Document document) {
        super(document);
    }

    public S2 createS2() {
        S2 s2 = new S2(this.getDocument(), this.getHref());
        this.addItem(s2);
        return s2;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        if (this.getHref() != null || this._title != null) {
            out.writeCharacters("\n");
            out.writeStartElement("div");
            out.writeAttribute("class", "s1");
            if (this.getHref() != null) {
                out.writeStartElement("a");
                out.writeAttribute("name", this.getHref());
                out.writeEndElement();
            }
            if (this._title != null) {
                out.writeStartElement("h1");
                out.writeAttribute("class", "section");
                out.writeCharacters(this._title);
                out.writeEndElement();
            }
            out.writeEndElement();
        }
        super.writeHtml(out);
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
        if (this.isWebOnly()) {
            return;
        }
        if (this._type != null && this._type.equals("defun")) {
            out.println("\\newpage");
        }
        if (this._title != null) {
            out.println("\\section{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
        }
        super.writeLaTeXTop(out);
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        if (this.isWebOnly()) {
            return;
        }
        if (this._title != null) {
            if (this.isArticle()) {
                out.println("\\section{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
            } else {
                out.println("\\subsubsection{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
            }
        }
        super.writeLaTeX(out);
    }

    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        if (this._type != null && this._type.equals("defun")) {
            out.println("\\newpage");
        }
        if (this._title != null) {
            out.println("\\subsubsection{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
        }
        super.writeLaTeX(out);
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
        if (this.isWebOnly()) {
            return;
        }
        out.println();
        out.println();
        out.println("=== " + this._title + " ===");
        super.writeAsciiDoc(out);
    }
}

